/*
 * Decompiled with CFR 0.152.
 */
package com.sec.xincipher.simkey.kms.asn1;

import com.sec.xincipher.simkey.kms.asn1.gmt0009.SM2Cipher;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;

public class EnvelopedData
implements ASN1Encodable {
    private final int version;
    private final int symAlgID;
    private final SM2Cipher encryptedKey;
    private final byte[] encryptedData;

    /*
     * WARNING - void declaration
     */
    public EnvelopedData(int version, int symAlgID, SM2Cipher encryptedKey, byte[] encryptedData) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.version = var1_1;
        this.symAlgID = var2_2;
        this.encryptedKey = var3_3;
        this.encryptedData = encryptedData;
    }

    public static EnvelopedData getInstance(Object obj) {
        if (obj instanceof EnvelopedData) {
            return (EnvelopedData)obj;
        }
        if (obj != null) {
            Object object;
            return new EnvelopedData(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    private EnvelopedData(ASN1Sequence seq) {
        Enumeration enumeration;
        if (seq.size() < 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        enumeration = enumeration.getObjects();
        this.version = ASN1Integer.getInstance(enumeration.nextElement()).getValue().intValue();
        this.symAlgID = ASN1Integer.getInstance(enumeration.nextElement()).getValue().intValue();
        this.encryptedKey = SM2Cipher.getInstance(enumeration.nextElement());
        this.encryptedData = DERBitString.getInstance(enumeration.nextElement()).getOctets();
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer((long)this.version));
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer((long)this.symAlgID));
        aSN1EncodableVector.add((ASN1Encodable)this.encryptedKey);
        aSN1EncodableVector.add((ASN1Encodable)new DERBitString(this.encryptedData));
        return new DERSequence(aSN1EncodableVector);
    }

    public int getVersion() {
        return this.version;
    }

    public int getSymAlgID() {
        return this.symAlgID;
    }

    public SM2Cipher getEncryptedKey() {
        return this.encryptedKey;
    }

    public byte[] getEncryptedData() {
        return this.encryptedData;
    }
}

