/*
 * Decompiled with CFR 0.152.
 */
package com.sec.xincipher.simkey.kms.asn1.gmt0009;

import com.sec.xincipher.simkey.kms.asn1.gmt0009.Header04;
import com.sec.xincipher.simkey.sdf.ECCCipher;
import com.sec.xincipher.simkey.sdf.SDFEntitySetterUtil;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import tech.simkey.dove.num.ByteUtil;
import tech.simkey.dove.num.BytearraySegmentReader;

public class SM2Cipher
implements ASN1Encodable {
    private byte[] cipherC132No04;

    /*
     * WARNING - void declaration
     */
    public SM2Cipher(byte[] x2, byte[] y2, byte[] hash, byte[] cipherText) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.cipherC132No04 = ByteUtil.contact2(new byte[][]{var1_1, var2_2, var3_3, cipherText});
    }

    /*
     * WARNING - void declaration
     */
    public SM2Cipher(ECCCipher eccCipher) {
        void var1_1;
        this.cipherC132No04 = SDFEntitySetterUtil.getEccCipherBlob2Bytes((ECCCipher)var1_1);
    }

    public static SM2Cipher getInstance(Object obj) {
        if (obj instanceof SM2Cipher) {
            return (SM2Cipher)obj;
        }
        if (obj != null) {
            Object object;
            return new SM2Cipher(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public SM2Cipher(byte[] cipherC132, boolean with04) {
        void var1_1;
        void var2_2;
        if (var2_2 != false) {
            this.cipherC132No04 = ByteUtil.subBytes(cipherC132, 1, cipherC132.length - 1);
            return;
        }
        this.cipherC132No04 = var1_1;
    }

    public SM2Cipher(ASN1Sequence sequence) {
        byte[] byArray;
        byte[] byArray2 = ASN1Integer.getInstance((Object)sequence.getObjectAt(0)).getValue().toByteArray();
        byArray2 = ByteUtil.subBytes(byArray2, byArray2.length - 32, 32);
        byte[] byArray3 = ASN1Integer.getInstance((Object)sequence.getObjectAt(1)).getValue().toByteArray();
        byArray3 = ByteUtil.subBytes(byArray3, byArray3.length - 32, 32);
        byte[] byArray4 = DEROctetString.getInstance((Object)sequence.getObjectAt(2)).getOctets();
        byArray = DEROctetString.getInstance((Object)byArray.getObjectAt(3)).getOctets();
        this.cipherC132No04 = ByteUtil.contact2(byArray2, byArray3, byArray4, byArray);
    }

    public ASN1Primitive toASN1Primitive() {
        Object object = new BytearraySegmentReader(this.cipherC132No04);
        byte[] byArray = ((BytearraySegmentReader)object).readBytes(32);
        byte[] byArray2 = ((BytearraySegmentReader)object).readBytes(32);
        byte[] byArray3 = ((BytearraySegmentReader)object).readBytes(32);
        object = ((BytearraySegmentReader)object).readLeft();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, byArray)));
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, byArray2)));
        aSN1EncodableVector.add((ASN1Encodable)new DEROctetString(byArray3));
        aSN1EncodableVector.add((ASN1Encodable)new DEROctetString((byte[])object));
        return new DERSequence(aSN1EncodableVector);
    }

    public ECCCipher getECCCipher() {
        ECCCipher eCCCipher = new ECCCipher();
        SDFEntitySetterUtil.setEccCipherBlobValue(eCCCipher, this.cipherC132No04);
        return eCCCipher;
    }

    public byte[] getCipherC132No04() {
        return this.cipherC132No04;
    }

    public byte[] getCipherC132With04() {
        return ByteUtil.contact(Header04.header, this.cipherC132No04);
    }
}

