/*
 * Decompiled with CFR 0.152.
 */
package com.sec.xincipher.simkey.kms.asn1.gmt0009;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import tech.simkey.dove.num.ByteUtil;
import tech.simkey.dove.num.BytearraySegmentReader;

public class SM2Signature
implements ASN1Encodable {
    private byte[] r;
    private byte[] s;
    private static final int RS_LEN = 32;

    public SM2Signature(ASN1Sequence instance) throws IOException {
        Object object;
        if (instance.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + instance.size());
        }
        object = object.getObjects();
        byte[] byArray = ASN1Integer.getInstance(object.nextElement()).getValue().toByteArray();
        this.r = new byte[32];
        ByteUtil.copyFixedLength(byArray, this.r);
        object = ASN1Integer.getInstance(object.nextElement()).getValue().toByteArray();
        this.s = new byte[32];
        ByteUtil.copyFixedLength((byte[])object, this.s);
    }

    /*
     * WARNING - void declaration
     */
    public SM2Signature(byte[] r2, byte[] s2) {
        void var2_2;
        void var1_1;
        this.r = var1_1;
        this.s = var2_2;
    }

    public SM2Signature(byte[] rsPlain) {
        BytearraySegmentReader bytearraySegmentReader;
        if (rsPlain.length != 64) {
            throw new IllegalArgumentException("Bad rs size: " + rsPlain.length);
        }
        bytearraySegmentReader = new BytearraySegmentReader((byte[])bytearraySegmentReader);
        this.r = bytearraySegmentReader.readBytes(32);
        this.s = bytearraySegmentReader.readBytes(32);
    }

    public static SM2Signature getInstance(Object obj) throws IOException {
        if (obj instanceof SM2Signature) {
            return (SM2Signature)obj;
        }
        if (obj != null) {
            Object object;
            return new SM2Signature(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, this.r)));
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, this.s)));
        return new DERSequence(aSN1EncodableVector);
    }

    public byte[] getRSPlain() {
        return ByteUtil.contact(this.r, this.s);
    }

    public byte[] getR() {
        return this.r;
    }

    public byte[] getS() {
        return this.s;
    }
}

