/*
 * Decompiled with CFR 0.152.
 */
package com.sec.xincipher.simkey.kms.kmssdk;

import com.sec.xincipher.simkey.kms.asn1.SymmetricCiphertext;
import com.sec.xincipher.simkey.kms.exception.ErrorCodes;
import com.sec.xincipher.simkey.kms.exception.KMSException;
import com.sec.xincipher.simkey.kms.kmssdk.ClientAsymmetricEncryption;
import com.sec.xincipher.simkey.kms.kmssdk.ClientLocalEasyDecryption;
import com.sec.xincipher.simkey.kms.kmssdk.ClientLocalEncryption;
import com.sec.xincipher.simkey.kms.kmssdk.ClientLocalEncryptionCloseable;
import com.sec.xincipher.simkey.kms.kmssdk.ClientRemoteEasyDecryption;
import com.sec.xincipher.simkey.kms.kmssdk.ClientRemoteEncryption;
import com.sec.xincipher.simkey.kms.kmssdk.ClientSameCiphertextEncryption;
import com.sec.xincipher.simkey.kms.kmssdk.entity.KMSAsymBizKey;
import com.sec.xincipher.simkey.kms.kmssdk.entity.KMSBizKey;
import tech.simkey.dove.encoding.Base64NoCR;

public interface KMSClient {
    public KMSBizKey genBizKey() throws KMSException;

    public ClientRemoteEncryption useBizkeyRemoteEncryption(String var1, String var2);

    public ClientLocalEncryption useUserkeyLocalSoftEncryption(String var1, String var2, String var3, String var4) throws KMSException;

    public ClientLocalEncryptionCloseable useUserkeyLocalSDFEncryption(String var1, String var2, String var3, String var4) throws KMSException;

    public KMSAsymBizKey genSM2BizKey() throws KMSException;

    public ClientAsymmetricEncryption useSM2BizkeyRemoteEncryption(String var1, String var2);

    public byte[] genRandom(int var1) throws KMSException;

    default public String getKeyId(String base64Ciphertext) throws KMSException {
        KMSException kMSException;
        try {
            return this.getKeyId(Base64NoCR.decode((String)((Object)kMSException)));
        }
        catch (KMSException kMSException2) {
            kMSException = kMSException2;
            throw kMSException2;
        }
        catch (Exception exception) {
            throw new KMSException(ErrorCodes.UNKNOWN.getCode(), exception);
        }
    }

    default public String getKeyId(byte[] ciphertext) throws KMSException {
        SymmetricCiphertext symmetricCiphertext = SymmetricCiphertext.getInstance(ciphertext);
        return symmetricCiphertext.getKeyId();
    }

    public ClientLocalEasyDecryption useClientLocalEasyDecryptionSoft();

    public ClientLocalEasyDecryption useClientLocalEasyDecryptionSDF();

    public ClientRemoteEasyDecryption useClientRemoteEasyDecryption();

    public ClientSameCiphertextEncryption useUserkeySamecipherSoftEncryption(String var1, String var2, String var3, String var4) throws KMSException;
}

