/*
 * Decompiled with CFR 0.152.
 */
package com.sec.xincipher.simkey.kms.kmssdk.impl;

import com.sec.xincipher.simkey.kms.exception.ErrorCodes;
import com.sec.xincipher.simkey.kms.exception.KMSException;
import com.sec.xincipher.simkey.kms.kmssdk.ClientAsymmetricEncryption;
import com.sec.xincipher.simkey.kms.kmssdk.ClientLocalEasyDecryption;
import com.sec.xincipher.simkey.kms.kmssdk.ClientLocalEncryption;
import com.sec.xincipher.simkey.kms.kmssdk.ClientLocalEncryptionCloseable;
import com.sec.xincipher.simkey.kms.kmssdk.ClientRemoteEasyDecryption;
import com.sec.xincipher.simkey.kms.kmssdk.ClientRemoteEncryption;
import com.sec.xincipher.simkey.kms.kmssdk.ClientSameCiphertextEncryption;
import com.sec.xincipher.simkey.kms.kmssdk.KMSClient;
import com.sec.xincipher.simkey.kms.kmssdk.KMSConfig;
import com.sec.xincipher.simkey.kms.kmssdk.constant.LegacyKeytype;
import com.sec.xincipher.simkey.kms.kmssdk.entity.KMSAsymBizKey;
import com.sec.xincipher.simkey.kms.kmssdk.entity.KMSBizKey;
import com.sec.xincipher.simkey.sdf.MyLong;
import com.sec.xincipher.simkey.sdf.SDF;
import simkey.kms.N;
import simkey.kms.T;
import simkey.kms.U;
import simkey.kms.X;
import simkey.kms.ab;
import simkey.kms.ac;
import simkey.kms.ad;
import simkey.kms.ae;
import simkey.kms.af;
import simkey.kms.ah;
import tech.simkey.dove.encoding.Base64NoCR;
import tech.simkey.dove.security.HexStringConvert;

public final class KMSClientImpl
implements KMSClient {
    private final ah repo;
    private final KMSConfig kmsConfig;

    /*
     * WARNING - void declaration
     */
    public KMSClientImpl(String kmsBaseUrl, String appId, String appSecretEnc) throws KMSException {
        this(KMSConfig.newBuilder().build(), (String)var1_1, (String)var2_2, (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public KMSClientImpl(KMSConfig kmsConfig, String kmsBaseUrl, String appId, String appSecretEnc) throws KMSException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.kmsConfig = kmsConfig;
        this.repo = new ah((KMSConfig)var1_1, (String)var2_2, (String)var3_3, this.decryptAppSecretEnc(appSecretEnc));
    }

    /*
     * WARNING - void declaration
     */
    public KMSClientImpl(KMSConfig kmsConfig, String kmsBaseUrl, String appId, String appSecretEnc, boolean decrypt) throws KMSException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.kmsConfig = kmsConfig;
        if (decrypt) {
            this.repo = new ah(kmsConfig, kmsBaseUrl, appId, this.decryptAppSecretEnc(appSecretEnc));
            return;
        }
        this.repo = new ah((KMSConfig)var1_1, (String)var2_2, (String)var3_3, appSecretEnc);
    }

    private String decryptAppSecretEnc(String appSecretEnc) throws KMSException {
        MyLong myLong;
        byte[] byArray;
        byte[] byArray2;
        SDF sDF = N.getSdf();
        int n2 = sDF.AISEC_Simple_Decrypt(byArray2 = Base64NoCR.decode((String)byArray2), byArray2.length, byArray = new byte[16], myLong = new MyLong(16L));
        if (n2 != 0) {
            throw new KMSException(ErrorCodes.APP_KEY_DECRYPT_ERROR);
        }
        return HexStringConvert.parseByte2HexStr(byArray);
    }

    @Override
    public final KMSBizKey genBizKey() throws KMSException {
        KMSBizKey kMSBizKey = new KMSBizKey();
        ah ah2 = this.repo;
        kMSBizKey.setEncKeyId(ah2.a((LegacyKeytype)LegacyKeytype.SM4).keyId);
        ah2 = this.repo;
        kMSBizKey.setHmacKeyId(ah2.b((LegacyKeytype)LegacyKeytype.SM4).keyId);
        return kMSBizKey;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ClientRemoteEncryption useBizkeyRemoteEncryption(String bizEncKeyId, String bizHmacKeyId) {
        void var2_2;
        void var1_1;
        return new X(this.repo, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ClientLocalEncryption useUserkeyLocalSoftEncryption(String userEncKeyId, String userEncKey, String userHmacKeyId, String userHmacKey) throws KMSException {
        void var3_3;
        void var2_2;
        void var1_1;
        return new af(this.repo, (String)var1_1, (String)var2_2, (String)var3_3, userHmacKey);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ClientLocalEncryptionCloseable useUserkeyLocalSDFEncryption(String userEncKeyId, String userEncKey, String userHmacKeyId, String userHmacKey) throws KMSException {
        void var3_3;
        void var2_2;
        void var1_1;
        return new ae(this.repo, (String)var1_1, (String)var2_2, (String)var3_3, userHmacKey);
    }

    @Override
    public final KMSAsymBizKey genSM2BizKey() throws KMSException {
        KMSAsymBizKey kMSAsymBizKey = new KMSAsymBizKey();
        kMSAsymBizKey.setEncKeyId(this.repo.t().keyId);
        kMSAsymBizKey.setSignKeyId(this.repo.u().keyId);
        return kMSAsymBizKey;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ClientAsymmetricEncryption useSM2BizkeyRemoteEncryption(String sm2BizEncKeyId, String sm2BizSignKeyId) {
        void var2_2;
        void var1_1;
        return new U(this.repo, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte[] genRandom(int randomBytesLen) throws KMSException {
        void var1_1;
        return this.repo.a((int)var1_1);
    }

    @Override
    public final ClientLocalEasyDecryption useClientLocalEasyDecryptionSoft() {
        return new ac(this);
    }

    @Override
    public final ClientLocalEasyDecryption useClientLocalEasyDecryptionSDF() {
        return new ab(this);
    }

    @Override
    public final ClientRemoteEasyDecryption useClientRemoteEasyDecryption() {
        return new ad(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ClientSameCiphertextEncryption useUserkeySamecipherSoftEncryption(String userEncKeyId, String userEncKey, String userHmacKeyId, String userHmacKey) throws KMSException {
        void var3_3;
        void var2_2;
        void var1_1;
        return new T(this.repo, (String)var1_1, (String)var2_2, (String)var3_3, userHmacKey);
    }
}

