/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.collection;

import java.util.Arrays;
import tech.simkey.dove.collection.QueueEmptyException;
import tech.simkey.dove.collection.QueueFullException;

public class CircularQueue<E> {
    private int currentSize;
    private E[] circularQueueElements;
    private int maxSize;
    private int rear;
    private int front;

    /*
     * WARNING - void declaration
     */
    public CircularQueue(int maxSize) {
        void var1_1;
        this.maxSize = var1_1;
        this.circularQueueElements = new Object[this.maxSize];
        this.currentSize = 0;
        this.front = -1;
        this.rear = -1;
    }

    /*
     * WARNING - void declaration
     */
    public void enqueue(E item) throws QueueFullException {
        void var1_1;
        if (this.isFull()) {
            throw new QueueFullException("Circular Queue is full. Element cannot be added");
        }
        this.rear = (this.rear + 1) % this.circularQueueElements.length;
        this.circularQueueElements[this.rear] = var1_1;
        ++this.currentSize;
        if (this.front == -1) {
            this.front = this.rear;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void enqueueReplaceIfExist(E item) {
        void var1_1;
        if (this.isFull()) {
            this.dequeue();
        }
        this.enqueue(var1_1);
    }

    public E dequeue() throws QueueEmptyException {
        if (this.isEmpty()) {
            throw new QueueEmptyException("Circular Queue is empty. Element cannot be retrieved");
        }
        E e2 = this.circularQueueElements[this.front];
        this.circularQueueElements[this.front] = null;
        this.front = (this.front + 1) % this.circularQueueElements.length;
        --this.currentSize;
        return e2;
    }

    public E getFirst() {
        E e2 = this.circularQueueElements[this.front];
        return e2;
    }

    public E getLast() {
        int n2 = (this.front - 1 + this.circularQueueElements.length) % this.circularQueueElements.length;
        E e2 = this.circularQueueElements[n2];
        return e2;
    }

    public E getPosOffsetFromFirst(int offset) {
        int n2;
        if (offset < 0 || offset > this.maxSize) {
            throw new IllegalArgumentException("offset < 0 \u6216\u8005 \u8d85\u8fc7\u6700\u5927\u503c");
        }
        n2 = (this.front + n2 + this.circularQueueElements.length) % this.circularQueueElements.length;
        E e2 = this.circularQueueElements[n2];
        return e2;
    }

    public boolean isFull() {
        return this.currentSize == this.circularQueueElements.length;
    }

    public boolean isEmpty() {
        return this.currentSize == 0;
    }

    public void clear() {
        while (!this.isEmpty()) {
            this.dequeue();
        }
    }

    public String toString() {
        return "CircularQueue [" + Arrays.toString(this.circularQueueElements) + "]";
    }
}

