/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.encoding;

import java.io.UnsupportedEncodingException;

public class Base64FromAndroid {
    public static final int DEFAULT = 0;
    public static final int NO_PADDING = 1;
    public static final int NO_WRAP = 2;
    public static final int CRLF = 4;
    public static final int URL_SAFE = 8;
    public static final int NO_CLOSE = 16;

    /*
     * WARNING - void declaration
     */
    public static byte[] decode(String str, int flags) {
        void var1_1;
        return Base64FromAndroid.decode(str.getBytes(), (int)var1_1);
    }

    public static byte[] decode(String str) {
        return Base64FromAndroid.decode(str.getBytes(), 0);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decode(byte[] input, int flags) {
        void var1_1;
        byte[] byArray;
        return Base64FromAndroid.decode(input, 0, byArray.length, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decode(byte[] input, int offset, int len, int flags) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        void var3_3;
        Decoder decoder = new Decoder((int)var3_3, new byte[len * 3 / 4]);
        if (!decoder.process(byArray, (int)var1_1, (int)var2_2, true)) {
            throw new IllegalArgumentException("bad base-64");
        }
        if (decoder.op == decoder.output.length) {
            return decoder.output;
        }
        byArray = new byte[decoder.op];
        System.arraycopy(decoder.output, 0, byArray, 0, decoder.op);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public static String encodeToString(byte[] input, int flags) {
        try {
            void var1_2;
            byte[] byArray;
            return new String(Base64FromAndroid.encode(byArray, (int)var1_2), "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    public static String encodeToString(byte[] input) {
        return Base64FromAndroid.encodeToString(input, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static String encodeToString(byte[] input, int offset, int len, int flags) {
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            byte[] byArray;
            return new String(Base64FromAndroid.encode(byArray, (int)var1_2, (int)var2_3, (int)var3_4), "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] encode(byte[] input, int flags) {
        void var1_1;
        byte[] byArray;
        return Base64FromAndroid.encode(input, 0, byArray.length, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] encode(byte[] input, int offset, int len, int flags) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        void var3_3;
        Encoder encoder = new Encoder((int)var3_3, null);
        int n2 = len / 3 << 2;
        if (encoder.do_padding) {
            if (len % 3 > 0) {
                n2 += 4;
            }
        } else {
            switch (len % 3) {
                case 0: {
                    break;
                }
                case 1: {
                    n2 += 2;
                    break;
                }
                case 2: {
                    n2 += 3;
                }
            }
        }
        if (encoder.do_newline && len > 0) {
            n2 += ((len - 1) / 57 + 1) * (encoder.do_cr ? 2 : 1);
        }
        encoder.output = new byte[n2];
        encoder.process(byArray, (int)var1_1, (int)var2_2, true);
        assert (encoder.op == n2);
        return encoder.output;
    }

    private Base64FromAndroid() {
    }

    static class Encoder
    extends Coder {
        public static final int LINE_GROUPS = 19;
        private static final byte[] ENCODE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        private static final byte[] ENCODE_WEBSAFE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
        private final byte[] tail;
        int tailLen;
        private int count;
        public final boolean do_padding;
        public final boolean do_newline;
        public final boolean do_cr;
        private final byte[] alphabet;

        /*
         * WARNING - void declaration
         */
        public Encoder(int flags, byte[] output) {
            void var1_1;
            void var2_2;
            this.output = var2_2;
            this.do_padding = (flags & 1) == 0;
            this.do_newline = (flags & 2) == 0;
            this.do_cr = (flags & 4) != 0;
            this.alphabet = (var1_1 & 8) == 0 ? ENCODE : ENCODE_WEBSAFE;
            this.tail = new byte[2];
            this.tailLen = 0;
            this.count = this.do_newline ? 19 : -1;
        }

        @Override
        public int maxOutputSize(int len) {
            return (len << 3) / 5 + 10;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean process(byte[] input, int offset, int len, boolean finish) {
            void var3_3;
            int n2;
            byte[] byArray = this.alphabet;
            byte[] byArray2 = this.output;
            int n3 = 0;
            int n4 = this.count;
            int n5 = offset;
            len += offset;
            int n6 = -1;
            switch (this.tailLen) {
                case 0: {
                    break;
                }
                case 1: {
                    if (offset + 2 > len) break;
                    int n7 = ++n5;
                    ++n5;
                    n6 = (this.tail[0] & 0xFF) << 16 | (input[offset] & 0xFF) << 8 | input[n7] & 0xFF;
                    this.tailLen = 0;
                    break;
                }
                case 2: {
                    if (offset + 1 > len) break;
                    ++n5;
                    n6 = (this.tail[0] & 0xFF) << 16 | (this.tail[1] & 0xFF) << 8 | input[n2] & 0xFF;
                    this.tailLen = 0;
                }
            }
            if (n6 != -1) {
                ++n3;
                byArray2[0] = byArray[n6 >> 18 & 0x3F];
                ++n3;
                byArray2[1] = byArray[n6 >> 12 & 0x3F];
                ++n3;
                byArray2[2] = byArray[n6 >> 6 & 0x3F];
                ++n3;
                byArray2[3] = byArray[n6 & 0x3F];
                if (--n4 == 0) {
                    if (this.do_cr) {
                        byArray2[4] = 13;
                    }
                    int n8 = ++n3;
                    ++n3;
                    byArray2[n8] = 10;
                    n4 = 19;
                }
            }
            while (n5 + 3 <= len) {
                n6 = (input[n5] & 0xFF) << 16 | (input[n5 + 1] & 0xFF) << 8 | input[n5 + 2] & 0xFF;
                byArray2[n3] = byArray[n6 >> 18 & 0x3F];
                byArray2[n3 + 1] = byArray[n6 >> 12 & 0x3F];
                byArray2[n3 + 2] = byArray[n6 >> 6 & 0x3F];
                byArray2[n3 + 3] = byArray[n6 & 0x3F];
                n5 += 3;
                n3 += 4;
                if (--n4 != 0) continue;
                if (this.do_cr) {
                    byArray2[n3++] = 13;
                }
                byArray2[n3++] = 10;
                n4 = 19;
            }
            if (finish) {
                if (n5 - this.tailLen == len - 1) {
                    byte by;
                    n2 = 0;
                    if (this.tailLen > 0) {
                        ++n2;
                        by = this.tail[0];
                    } else {
                        by = input[n5++];
                    }
                    n6 = (by & 0xFF) << 4;
                    this.tailLen -= n2;
                    byArray2[n3++] = byArray[n6 >> 6 & 0x3F];
                    byArray2[n3++] = byArray[n6 & 0x3F];
                    if (this.do_padding) {
                        byArray2[n3++] = 61;
                        byArray2[n3++] = 61;
                    }
                    if (this.do_newline) {
                        if (this.do_cr) {
                            byArray2[n3++] = 13;
                        }
                        byArray2[n3++] = 10;
                    }
                } else if (n5 - this.tailLen == len - 2) {
                    byte by;
                    n2 = 0;
                    if (this.tailLen > 1) {
                        ++n2;
                        by = this.tail[0];
                    } else {
                        by = input[n5++];
                    }
                    n6 = (by & 0xFF) << 10 | ((this.tailLen > 0 ? this.tail[n2++] : input[n5++]) & 0xFF) << 2;
                    this.tailLen -= n2;
                    byArray2[n3++] = byArray[n6 >> 12 & 0x3F];
                    byArray2[n3++] = byArray[n6 >> 6 & 0x3F];
                    byArray2[n3++] = byArray[n6 & 0x3F];
                    if (this.do_padding) {
                        byArray2[n3++] = 61;
                    }
                    if (this.do_newline) {
                        if (this.do_cr) {
                            byArray2[n3++] = 13;
                        }
                        byArray2[n3++] = 10;
                    }
                } else if (this.do_newline && n3 > 0 && n4 != 19) {
                    if (this.do_cr) {
                        byArray2[n3++] = 13;
                    }
                    byArray2[n3++] = 10;
                }
                assert (this.tailLen == 0);
                assert (n5 == len);
            } else if (n5 == len - 1) {
                this.tail[this.tailLen++] = input[n5];
            } else if (n5 == var3_3 - 2) {
                void var1_1;
                this.tail[this.tailLen++] = input[n5];
                this.tail[this.tailLen++] = var1_1[n5 + 1];
            }
            this.op = n3;
            this.count = n4;
            return true;
        }
    }

    static class Decoder
    extends Coder {
        private static final int[] DECODE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -2, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        private static final int[] DECODE_WEBSAFE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -2, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        private static final int SKIP = -1;
        private static final int EQUALS = -2;
        private int state;
        private int value;
        private final int[] alphabet;

        /*
         * WARNING - void declaration
         */
        public Decoder(int flags, byte[] output) {
            void var1_1;
            void var2_2;
            this.output = var2_2;
            this.alphabet = (var1_1 & 8) == 0 ? DECODE : DECODE_WEBSAFE;
            this.state = 0;
            this.value = 0;
        }

        @Override
        public int maxOutputSize(int len) {
            return len * 3 / 4 + 10;
        }

        @Override
        public boolean process(byte[] input, int offset, int len, boolean finish) {
            int n2;
            if (this.state == 6) {
                return false;
            }
            int n3 = offset;
            len += n2;
            n2 = this.state;
            int n4 = this.value;
            int n5 = 0;
            byte[] byArray = this.output;
            int[] nArray = this.alphabet;
            while (n3 < len) {
                if (n2 == 0) {
                    while (n3 + 4 <= len && (n4 = nArray[input[n3] & 0xFF] << 18 | nArray[input[n3 + 1] & 0xFF] << 12 | nArray[input[n3 + 2] & 0xFF] << 6 | nArray[input[n3 + 3] & 0xFF]) >= 0) {
                        byArray[n5 + 2] = (byte)n4;
                        byArray[n5 + 1] = (byte)(n4 >> 8);
                        byArray[n5] = (byte)(n4 >> 16);
                        n5 += 3;
                        n3 += 4;
                    }
                    if (n3 >= len) break;
                }
                int n6 = nArray[input[n3++] & 0xFF];
                switch (n2) {
                    case 0: {
                        if (n6 >= 0) {
                            n4 = n6;
                            ++n2;
                            break;
                        }
                        if (n6 == -1) break;
                        this.state = 6;
                        return false;
                    }
                    case 1: {
                        if (n6 >= 0) {
                            n4 = n4 << 6 | n6;
                            ++n2;
                            break;
                        }
                        if (n6 == -1) break;
                        this.state = 6;
                        return false;
                    }
                    case 2: {
                        if (n6 >= 0) {
                            n4 = n4 << 6 | n6;
                            ++n2;
                            break;
                        }
                        if (n6 == -2) {
                            byArray[n5++] = (byte)(n4 >> 4);
                            n2 = 4;
                            break;
                        }
                        if (n6 == -1) break;
                        this.state = 6;
                        return false;
                    }
                    case 3: {
                        if (n6 >= 0) {
                            n4 = n4 << 6 | n6;
                            byArray[n5 + 2] = (byte)n4;
                            byArray[n5 + 1] = (byte)(n4 >> 8);
                            byArray[n5] = (byte)(n4 >> 16);
                            n5 += 3;
                            n2 = 0;
                            break;
                        }
                        if (n6 == -2) {
                            byArray[n5 + 1] = (byte)(n4 >> 2);
                            byArray[n5] = (byte)(n4 >> 10);
                            n5 += 2;
                            n2 = 5;
                            break;
                        }
                        if (n6 == -1) break;
                        this.state = 6;
                        return false;
                    }
                    case 4: {
                        if (n6 == -2) {
                            ++n2;
                            break;
                        }
                        if (n6 == -1) break;
                        this.state = 6;
                        return false;
                    }
                    case 5: {
                        if (n6 == -1) break;
                        this.state = 6;
                        return false;
                    }
                }
            }
            if (!finish) {
                this.state = n2;
                this.value = n4;
                this.op = n5;
                return true;
            }
            switch (n2) {
                case 0: {
                    break;
                }
                case 1: {
                    this.state = 6;
                    return false;
                }
                case 2: {
                    byArray[n5++] = (byte)(n4 >> 4);
                    break;
                }
                case 3: {
                    byArray[n5++] = (byte)(n4 >> 10);
                    byArray[n5++] = (byte)(n4 >> 2);
                    break;
                }
                case 4: {
                    this.state = 6;
                    return false;
                }
            }
            this.state = n2;
            this.op = n5;
            return true;
        }
    }

    static abstract class Coder {
        public byte[] output;
        public int op;

        Coder() {
        }

        public abstract boolean process(byte[] var1, int var2, int var3, boolean var4);

        public abstract int maxOutputSize(int var1);
    }
}

