/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.encoding;

public class Base64NoCR {
    private static final byte[] encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] decodingTable = new byte[128];

    public static byte[] encode(byte[] data) {
        int n2 = data.length % 3;
        byte[] byArray = n2 == 0 ? new byte[4 * data.length / 3] : new byte[4 * (data.length / 3 + 1)];
        int n3 = data.length - n2;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            int n6 = data[n4] & 0xFF;
            int n7 = data[n4 + 1] & 0xFF;
            int n8 = data[n4 + 2] & 0xFF;
            byArray[n5] = encodingTable[n6 >>> 2 & 0x3F];
            byArray[n5 + 1] = encodingTable[(n6 << 4 | n7 >>> 4) & 0x3F];
            byArray[n5 + 2] = encodingTable[(n7 << 2 | n8 >>> 6) & 0x3F];
            byArray[n5 + 3] = encodingTable[n8 & 0x3F];
            n4 += 3;
            n5 += 4;
        }
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                n2 = data[data.length - 1] & 0xFF;
                n4 = n2 >>> 2 & 0x3F;
                n5 = n2 << 4 & 0x3F;
                byArray[byArray.length - 4] = encodingTable[n4];
                byArray[byArray.length - 3] = encodingTable[n5];
                byArray[byArray.length - 2] = 61;
                byArray[byArray.length - 1] = 61;
                break;
            }
            case 2: {
                byte[] byArray2;
                n2 = data[data.length - 2] & 0xFF;
                int n9 = byArray2[byArray2.length - 1] & 0xFF;
                n4 = n2 >>> 2 & 0x3F;
                n5 = (n2 << 4 | n9 >>> 4) & 0x3F;
                n9 = n9 << 2 & 0x3F;
                byArray[byArray.length - 4] = encodingTable[n4];
                byArray[byArray.length - 3] = encodingTable[n5];
                byArray[byArray.length - 2] = encodingTable[n9];
                byArray[byArray.length - 1] = 61;
            }
        }
        return byArray;
    }

    public static byte[] decode(byte[] data) {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        byte[] byArray = data[data.length - 2] == 61 ? new byte[(data.length / 4 - 1) * 3 + 1] : (data[data.length - 1] == 61 ? new byte[(data.length / 4 - 1) * 3 + 2] : new byte[data.length / 4 * 3]);
        int n2 = 0;
        int n3 = 0;
        while (n2 < data.length - 4) {
            by4 = decodingTable[data[n2]];
            by3 = decodingTable[data[n2 + 1]];
            by2 = decodingTable[data[n2 + 2]];
            by = decodingTable[data[n2 + 3]];
            byArray[n3] = (byte)(by4 << 2 | by3 >> 4);
            byArray[n3 + 1] = (byte)(by3 << 4 | by2 >> 2);
            byArray[n3 + 2] = (byte)(by2 << 6 | by);
            n2 += 4;
            n3 += 3;
        }
        if (data[data.length - 2] == 61) {
            by4 = decodingTable[data[data.length - 4]];
            by3 = decodingTable[data[data.length - 3]];
            byArray[byArray.length - 1] = (byte)(by4 << 2 | by3 >> 4);
        } else if (data[data.length - 1] == 61) {
            by4 = decodingTable[data[data.length - 4]];
            by3 = decodingTable[data[data.length - 3]];
            by2 = decodingTable[data[data.length - 2]];
            byArray[byArray.length - 2] = (byte)(by4 << 2 | by3 >> 4);
            byArray[byArray.length - 1] = (byte)(by3 << 4 | by2 >> 2);
        } else {
            byte[] byArray2;
            by4 = decodingTable[data[data.length - 4]];
            by3 = decodingTable[data[data.length - 3]];
            by2 = decodingTable[data[data.length - 2]];
            by = decodingTable[byArray2[byArray2.length - 1]];
            byArray[byArray.length - 3] = (byte)(by4 << 2 | by3 >> 4);
            byArray[byArray.length - 2] = (byte)(by3 << 4 | by2 >> 2);
            byArray[byArray.length - 1] = (byte)(by2 << 6 | by);
        }
        return byArray;
    }

    public static byte[] decode(String data) {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        byte[] byArray;
        if (data == null) {
            throw new IllegalArgumentException("Base64 decode param null");
        }
        String string = data;
        if (string.charAt(string.length() - 2) == '=') {
            byArray = new byte[(data.length() / 4 - 1) * 3 + 1];
        } else {
            String string2 = data;
            byArray = string2.charAt(string2.length() - 1) == '=' ? new byte[(data.length() / 4 - 1) * 3 + 2] : new byte[data.length() / 4 * 3];
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < data.length() - 4) {
            by4 = decodingTable[data.charAt(n2)];
            by3 = decodingTable[data.charAt(n2 + 1)];
            by2 = decodingTable[data.charAt(n2 + 2)];
            by = decodingTable[data.charAt(n2 + 3)];
            byArray[n3] = (byte)(by4 << 2 | by3 >> 4);
            byArray[n3 + 1] = (byte)(by3 << 4 | by2 >> 2);
            byArray[n3 + 2] = (byte)(by2 << 6 | by);
            n2 += 4;
            n3 += 3;
        }
        String string3 = data;
        if (string3.charAt(string3.length() - 2) == '=') {
            String string4 = data;
            by4 = decodingTable[string4.charAt(string4.length() - 4)];
            String string5 = data;
            by3 = decodingTable[string5.charAt(string5.length() - 3)];
            byArray[byArray.length - 1] = (byte)(by4 << 2 | by3 >> 4);
        } else {
            String string6 = data;
            if (string6.charAt(string6.length() - 1) == '=') {
                String string7 = data;
                by4 = decodingTable[string7.charAt(string7.length() - 4)];
                String string8 = data;
                by3 = decodingTable[string8.charAt(string8.length() - 3)];
                String string9 = data;
                by2 = decodingTable[string9.charAt(string9.length() - 2)];
                byArray[byArray.length - 2] = (byte)(by4 << 2 | by3 >> 4);
                byArray[byArray.length - 1] = (byte)(by3 << 4 | by2 >> 2);
            } else {
                String string10;
                String string11 = data;
                by4 = decodingTable[string11.charAt(string11.length() - 4)];
                String string12 = data;
                by3 = decodingTable[string12.charAt(string12.length() - 3)];
                String string13 = data;
                by2 = decodingTable[string13.charAt(string13.length() - 2)];
                String string14 = string10;
                by = decodingTable[string14.charAt(string14.length() - 1)];
                byArray[byArray.length - 3] = (byte)(by4 << 2 | by3 >> 4);
                byArray[byArray.length - 2] = (byte)(by3 << 4 | by2 >> 2);
                byArray[byArray.length - 1] = (byte)(by2 << 6 | by);
            }
        }
        return byArray;
    }

    public static String encodeToStr(byte[] data) {
        try {
            byte[] byArray = Base64NoCR.encode(data);
            return new String(byArray, "UTF-8");
        }
        catch (Exception exception) {
            return "";
        }
    }

    static {
        int n2 = 65;
        while (n2 <= 90) {
            int n3 = n2++;
            Base64NoCR.decodingTable[n3] = (byte)(n3 - 65);
        }
        n2 = 97;
        while (n2 <= 122) {
            int n4 = n2++;
            Base64NoCR.decodingTable[n4] = (byte)(n4 - 97 + 26);
        }
        n2 = 48;
        while (n2 <= 57) {
            int n5 = n2++;
            Base64NoCR.decodingTable[n5] = (byte)(n5 - 48 + 52);
        }
        Base64NoCR.decodingTable[43] = 62;
        Base64NoCR.decodingTable[47] = 63;
    }
}

