/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.encoding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;

public abstract class CharacterEncoder {
    protected PrintStream pStream;

    protected abstract int bytesPerAtom();

    protected abstract int bytesPerLine();

    /*
     * WARNING - void declaration
     */
    protected void encodeBufferPrefix(OutputStream aStream) throws IOException {
        void var1_1;
        this.pStream = new PrintStream((OutputStream)var1_1);
    }

    protected void encodeBufferSuffix(OutputStream aStream) throws IOException {
    }

    protected void encodeLinePrefix(OutputStream aStream, int aLength) throws IOException {
    }

    protected void encodeLineSuffix(OutputStream aStream) throws IOException {
        this.pStream.println();
    }

    protected abstract void encodeAtom(OutputStream var1, byte[] var2, int var3, int var4) throws IOException;

    /*
     * WARNING - void declaration
     */
    protected int readFully(InputStream in, byte[] buffer) throws IOException {
        void var2_2;
        for (int i2 = 0; i2 < buffer.length; ++i2) {
            int n2 = in.read();
            if (n2 == -1) {
                return i2;
            }
            buffer[i2] = (byte)n2;
        }
        return ((void)var2_2).length;
    }

    /*
     * WARNING - void declaration
     */
    public void encode(InputStream inStream, OutputStream outStream) throws IOException {
        void var2_2;
        int n2;
        byte[] byArray = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outStream);
        while ((n2 = this.readFully(inStream, byArray)) != 0) {
            this.encodeLinePrefix(outStream, n2);
            for (int i2 = 0; i2 < n2; i2 += this.bytesPerAtom()) {
                if (i2 + this.bytesPerAtom() <= n2) {
                    this.encodeAtom(outStream, byArray, i2, this.bytesPerAtom());
                    continue;
                }
                this.encodeAtom(outStream, byArray, i2, n2 - i2);
            }
            if (n2 < this.bytesPerLine()) break;
            this.encodeLineSuffix(outStream);
        }
        this.encodeBufferSuffix((OutputStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void encode(byte[] aBuffer, OutputStream aStream) throws IOException {
        void var2_2;
        ByteArrayInputStream byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream((byte[])byteArrayInputStream);
        this.encode(byteArrayInputStream, (OutputStream)var2_2);
    }

    public String encode(byte[] aBuffer) {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        object = new ByteArrayInputStream((byte[])object);
        try {
            this.encode((InputStream)object, (OutputStream)byteArrayOutputStream);
            object = byteArrayOutputStream.toString("8859_1");
        }
        catch (Exception exception) {
            throw new Error("CharacterEncoder.encode internal error");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getBytes(ByteBuffer bb) {
        byte[] byArray;
        byte[] byArray2 = null;
        if (bb.hasArray() && (byArray = bb.array()).length == bb.capacity() && byArray.length == bb.remaining()) {
            byArray2 = byArray;
            ByteBuffer byteBuffer = bb;
            byteBuffer.position(byteBuffer.limit());
        }
        if (byArray2 == null) {
            void var1_1;
            byArray2 = new byte[bb.remaining()];
            var1_1.get(byArray2);
        }
        return byArray2;
    }

    /*
     * WARNING - void declaration
     */
    public void encode(ByteBuffer aBuffer, OutputStream aStream) throws IOException {
        void var2_2;
        byte[] byArray;
        byArray = this.getBytes((ByteBuffer)byArray);
        this.encode(byArray, (OutputStream)var2_2);
    }

    public String encode(ByteBuffer aBuffer) {
        byte[] byArray;
        byArray = this.getBytes((ByteBuffer)byArray);
        return this.encode(byArray);
    }

    /*
     * WARNING - void declaration
     */
    public void encodeBuffer(InputStream inStream, OutputStream outStream) throws IOException {
        void var2_2;
        int n2;
        byte[] byArray = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outStream);
        while ((n2 = this.readFully(inStream, byArray)) != 0) {
            this.encodeLinePrefix(outStream, n2);
            for (int i2 = 0; i2 < n2; i2 += this.bytesPerAtom()) {
                if (i2 + this.bytesPerAtom() <= n2) {
                    this.encodeAtom(outStream, byArray, i2, this.bytesPerAtom());
                    continue;
                }
                this.encodeAtom(outStream, byArray, i2, n2 - i2);
            }
            this.encodeLineSuffix(outStream);
            if (n2 >= this.bytesPerLine()) continue;
        }
        this.encodeBufferSuffix((OutputStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void encodeBuffer(byte[] aBuffer, OutputStream aStream) throws IOException {
        void var2_2;
        ByteArrayInputStream byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream((byte[])byteArrayInputStream);
        this.encodeBuffer(byteArrayInputStream, (OutputStream)var2_2);
    }

    public String encodeBuffer(byte[] aBuffer) {
        ByteArrayInputStream byteArrayInputStream;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayInputStream = new ByteArrayInputStream((byte[])byteArrayInputStream);
        try {
            this.encodeBuffer(byteArrayInputStream, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new Error("CharacterEncoder.encodeBuffer internal error");
        }
        return byteArrayOutputStream.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void encodeBuffer(ByteBuffer aBuffer, OutputStream aStream) throws IOException {
        void var2_2;
        byte[] byArray;
        byArray = this.getBytes((ByteBuffer)byArray);
        this.encodeBuffer(byArray, (OutputStream)var2_2);
    }

    public String encodeBuffer(ByteBuffer aBuffer) {
        byte[] byArray;
        byArray = this.getBytes((ByteBuffer)byArray);
        return this.encodeBuffer(byArray);
    }
}

