/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.encoding;

import java.security.SecureRandom;
import tech.simkey.dove.exception.InvalidCipherTextException;
import tech.simkey.dove.security.HexStringConvert;

public class PKCS1EncodingV1 {
    private static final int HEADER_LENGTH = 10;
    private SecureRandom random;
    private int bitSize;
    private boolean forEncryption;
    private boolean forPrivateKey;
    private int inblockSize;
    private int outblockSize;

    /*
     * WARNING - void declaration
     */
    public PKCS1EncodingV1(int modulus, boolean forEncryption, boolean forPrivateKey) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.bitSize = var1_1;
        this.random = new SecureRandom();
        this.forPrivateKey = var3_3;
        this.forEncryption = forEncryption;
        if (var2_2 != false) {
            this.inblockSize = (this.bitSize + 7) / 8 - 1;
            this.outblockSize = (this.bitSize + 7) / 8;
            return;
        }
        this.inblockSize = (this.bitSize + 7) / 8;
        this.outblockSize = (this.bitSize + 7) / 8 - 1;
    }

    public int getInputBlockSize() {
        if (this.forEncryption) {
            return this.inblockSize - 10;
        }
        return this.inblockSize;
    }

    public int getOutputBlockSize() {
        if (this.forEncryption) {
            return this.outblockSize;
        }
        return this.outblockSize - 10;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] processBlock(byte[] inData, int inOff, int inLen) throws InvalidCipherTextException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.forEncryption) {
            return this.encodeBlock(inData, inOff, inLen);
        }
        return this.decodeBlock((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] encodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (inLen > this.getInputBlockSize()) {
            throw new InvalidCipherTextException("input data too large");
        }
        byte[] byArray = new byte[this.inblockSize + 1];
        if (this.forPrivateKey) {
            byArray[0] = 0;
            byArray[1] = 1;
            for (int i2 = 2; i2 != byArray.length - inLen - 1; ++i2) {
                byArray[i2] = -1;
            }
        } else {
            this.random.nextBytes(byArray);
            byArray[0] = 0;
            byArray[1] = 2;
            for (int i3 = 2; i3 != byArray.length - inLen - 1; ++i3) {
                while (byArray[i3] == 0) {
                    byArray[i3] = (byte)this.random.nextInt();
                }
            }
        }
        byArray[byArray.length - inLen - 1] = 0;
        System.arraycopy(var1_1, (int)var2_2, byArray, byArray.length - inLen, (int)var3_3);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] decodeBlock(byte[] block, int inOff, int inLen) throws InvalidCipherTextException {
        void var1_1;
        byte by;
        int n2;
        if (block.length < this.getOutputBlockSize()) {
            throw new InvalidCipherTextException("block truncated");
        }
        byte by2 = block[1];
        if (by2 != 1 && by2 != 2) {
            throw new InvalidCipherTextException("unknown block type");
        }
        if (block.length != this.outblockSize + 1) {
            throw new InvalidCipherTextException("block incorrect size");
        }
        for (n2 = 2; n2 != block.length && (by = block[n2]) != 0; ++n2) {
            if (by2 != 1 || by == -1) continue;
            throw new InvalidCipherTextException("block padding incorrect");
        }
        if (++n2 > block.length || n2 < 10) {
            throw new InvalidCipherTextException("no data in block");
        }
        byte[] byArray = new byte[block.length - n2];
        System.arraycopy(var1_1, n2, byArray, 0, byArray.length);
        return byArray;
    }

    public static void main(String[] agrs) throws InvalidCipherTextException {
        Object object = new PKCS1EncodingV1(1024, true, false);
        Object object2 = "E585ACE992A5E8A7A3E5AF86E6B58BE8AF95";
        object2 = HexStringConvert.parseHexStr2Byte("E585ACE992A5E8A7A3E5AF86E6B58BE8AF95");
        object = object.processBlock((byte[])object2, 0, ((Object)object2).length);
        System.out.println(HexStringConvert.parseByte2HexStr((byte[])object));
    }
}

