/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.http.exe;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import tech.simkey.dove.encoding.Base64NoCR;
import tech.simkey.dove.http.exe.HttpJsonExecutor;
import tech.simkey.dove.http.exe.HttpResponse;
import tech.simkey.dove.json.JsonUtil;
import tech.simkey.dove.log.CLog;
import tech.simkey.dove.security.HexStringConvert;
import tech.simkey.dove.security.sm2.SM2UtilsC132No04;
import tech.simkey.dove.security.sm4.SM4Util;
import tech.simkey.dove.util.LocalConfig;
import tech.simkey.dove.util.Preconditions;

public class CISSExecutor {
    public static final String TAG = "CISSExecutor";
    public static final String JSON_FORMATTER = "{\"keyId\": \"%s\", \"key\": \"%s\", \"params\": \"%s\"}";
    public static final String ENCODING = "UTF-8";
    private static final int NETWORK_TIMEOUT = 500007;
    public String url;
    private Map<String, String> content;
    private String keyid;
    private String sm2Pubkey;

    /*
     * WARNING - void declaration
     */
    public CISSExecutor(String url, Map<String, String> content, String keyid, String sm2Pubkey) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.url = url;
        this.content = content;
        this.keyid = keyid;
        this.sm2Pubkey = sm2Pubkey;
        Preconditions.checkNotNull(var1_1);
        Preconditions.checkNotNull(var2_2);
        Preconditions.checkNotNull(var3_3);
        Preconditions.checkNotNull(sm2Pubkey);
    }

    public HttpResponse exe() {
        StringBuilder stringBuilder = new StringBuilder(127);
        try {
            stringBuilder.append(TAG).append(LocalConfig.CR);
            Object object = JsonUtil.toJson(this.content);
            stringBuilder.append("url:").append(this.url).append(LocalConfig.CR);
            stringBuilder.append("\u539f\u6587:").append((String)object).append(LocalConfig.CR);
            Object object2 = SM4Util.genKey();
            object = SM4Util.encryptData_CBC((String)object, (String)object2);
            stringBuilder.append("\u5bc6\u6587:").append((String)object).append(LocalConfig.CR);
            Object object3 = SM2UtilsC132No04.encrypt(HexStringConvert.parseHexStr2Byte(this.sm2Pubkey), HexStringConvert.parseHexStr2Byte((String)object2));
            object3 = Base64NoCR.encodeToStr(object3);
            object = String.format(JSON_FORMATTER, this.keyid, URLEncoder.encode((String)object3, ENCODING), URLEncoder.encode((String)object, ENCODING));
            object = new HttpJsonExecutor(this.url, (String)object).exe();
            object = JsonUtil.fromJson((String)object, HttpResponse.class);
            if (object == null) {
                object = new HttpResponse();
                new HttpResponse().statusCode = 500007;
                ((HttpResponse)object).returnObj = "\u670d\u52a1\u5668\u8d85\u65f6\u6216\u5f02\u5e38\u54cd\u5e94";
                object2 = object;
                return object2;
            }
            if (((HttpResponse)object).statusCode == 200) {
                object2 = SM4Util.decryptData_CBC(URLDecoder.decode(((HttpResponse)object).returnObj, ENCODING), (String)object2);
                stringBuilder.append("\u89e3\u5bc6:").append((String)object2).append(LocalConfig.CR);
                ((HttpResponse)object).returnObj = object2;
            }
            object2 = object;
            return object2;
        }
        catch (Exception exception) {
            stringBuilder.append(" \u53d1\u751f\u5f02\u5e38:").append(exception.getMessage());
            CLog.e(TAG, stringBuilder.toString(), exception);
        }
        finally {
            CLog.d(TAG, stringBuilder.toString());
        }
        return new HttpResponse();
    }
}

