/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.http.hurl;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import tech.simkey.dove.http.hurl.Header;
import tech.simkey.dove.http.hurl.HttpResponse;

public class FileDownloader
implements Closeable {
    private static final int HTTP_CONTINUE = 100;
    private static final String Encoding = "UTF-8";
    private static final int timeoutMs = 5000;
    private byte[] buff = new byte[1024];
    private HttpURLConnection connection = null;
    private HttpResponse httpResponse = null;
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public final boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public int getContentLength() {
        if (this.httpResponse != null) {
            return this.httpResponse.getContentLength();
        }
        return 0;
    }

    public String getFileName() {
        String string = "";
        if (this.httpResponse != null) {
            string = FileDownloader.getFileNameFromResp(this.httpResponse);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public int transferTo(OutputStream outputStream) throws IOException {
        int n2 = this.httpResponse.getContent().read(this.buff);
        if (n2 > 0) {
            void var1_1;
            var1_1.write(this.buff, 0, n2);
        }
        return n2;
    }

    @Override
    public void close() throws IOException {
        System.out.println("close");
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    /*
     * WARNING - void declaration
     */
    public FileDownloader performStreamRequest(String url, int requestMethod, Map<String, String> header, Map<String, String> body) {
        Exception exception;
        try {
            void var3_3;
            void var2_2;
            this.performSimpleRequest((String)((Object)exception), (int)var2_2, (Map<String, String>)var3_3, body);
        }
        catch (Exception exception2) {
            exception = exception2;
            FileDownloader.printErr(exception2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void performSimpleRequest(String url, int requestMethod, Map<String, String> header, Map<String, String> body) {
        Serializable serializable;
        try {
            void var3_3;
            void var2_2;
            this.removeNullValueIfExist(body);
            serializable = this.addParamsToGetUrl((String)((Object)serializable), requestMethod, body);
            byte[] byArray = this.parseBodyIfExists(requestMethod, body);
            this.performRequestWithRetry(((StringBuilder)serializable).toString(), (int)var2_2, (Map<String, String>)var3_3, byArray, null, 0);
            return;
        }
        catch (Exception exception) {
            serializable = exception;
            FileDownloader.printErr(exception);
            return;
        }
    }

    private void removeNullValueIfExist(Map<String, String> body) {
        if (body != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : body.keySet()) {
                if (body.get(string) != null) continue;
                arrayList.add(string);
            }
            for (String string : arrayList) {
                body.remove(string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder addParamsToGetUrl(String url, int requestMethod, Map<String, String> body) {
        void var2_2;
        void var1_1;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)var1_1);
        if (var2_2 == false && body != null && body.size() > 0) {
            void var3_3;
            stringBuilder.append("?");
            stringBuilder.append(this.getParameterString((Map<String, String>)var3_3, Encoding));
        }
        return stringBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private void performRequestWithRetry(String url, int requestMethod, Map<String, String> header, byte[] requestData, SSLSocketFactory mSslSocketFactory, int retryCount) {
        try {
            this.performRequest(url, requestMethod, header, requestData, mSslSocketFactory);
            return;
        }
        catch (IOException iOException) {
            if (this.isRetryAble(iOException, retryCount)) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.performRequestWithRetry((String)var1_1, (int)var2_2, (Map<String, String>)var3_3, requestData, mSslSocketFactory, retryCount + 1);
            }
            FileDownloader.printErr(iOException);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            FileDownloader.printErr(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isRetryAble(IOException exception, int executionCount) {
        void var1_1;
        if (executionCount >= 3) {
            return false;
        }
        if (exception instanceof InterruptedIOException) {
            return false;
        }
        if (exception instanceof UnknownHostException) {
            return false;
        }
        if (var1_1 instanceof SSLException) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void performRequest(String strurl, int requestMethod, Map<String, String> header, byte[] requestData, SSLSocketFactory mSslSocketFactory) throws MalformedURLException, ProtocolException, IOException {
        void var2_3;
        int n2;
        void var3_4;
        Object object;
        this.close();
        object = new URL((String)object);
        this.connection = (HttpURLConnection)((URL)object).openConnection();
        this.connection.setConnectTimeout(5000);
        this.connection.setReadTimeout(5000);
        this.connection.setUseCaches(false);
        this.connection.setDoInput(true);
        this.connection.setInstanceFollowRedirects(true);
        this.disableConnectionReuseIfNecessary();
        if ("https".equals(this.connection.getURL().getProtocol()) && mSslSocketFactory != null) {
            ((HttpsURLConnection)this.connection).setSSLSocketFactory(mSslSocketFactory);
        }
        FileDownloader fileDownloader = this;
        fileDownloader.addHeader(fileDownloader.connection, (Map<String, String>)var3_4);
        FileDownloader fileDownloader2 = this;
        fileDownloader2.addBody(fileDownloader2.connection, requestMethod);
        if (requestData != null) {
            this.connection.setDoOutput(true);
            this.connection.addRequestProperty("Content-Type", this.getBodyContentType());
            object = new DataOutputStream(this.connection.getOutputStream());
            ((FilterOutputStream)object).write(requestData);
            ((FilterOutputStream)object).close();
        }
        if ((n2 = this.connection.getResponseCode()) == -1) {
            System.out.println("Could not retrieve response code from HttpUrlConnection.");
            return;
        }
        if (!FileDownloader.hasResponseBody((int)var2_3, n2)) {
            this.httpResponse = new HttpResponse(n2, FileDownloader.convertHeaders(this.connection.getHeaderFields()));
            return;
        }
        this.httpResponse = new HttpResponse(n2, FileDownloader.convertHeaders(this.connection.getHeaderFields()), this.connection.getContentLength(), new UrlConnectionInputStream(this.connection));
    }

    /*
     * WARNING - void declaration
     */
    private void addBody(HttpURLConnection connection, int requestMethod) throws ProtocolException, IOException {
        switch (requestMethod) {
            case 0: {
                connection.setRequestMethod("GET");
                return;
            }
            case 3: {
                connection.setRequestMethod("DELETE");
                return;
            }
            case 1: {
                connection.setRequestMethod("POST");
                return;
            }
            case 2: {
                connection.setRequestMethod("PUT");
                return;
            }
            case 4: {
                connection.setRequestMethod("HEAD");
                return;
            }
            case 5: {
                connection.setRequestMethod("OPTIONS");
                return;
            }
            case 6: {
                connection.setRequestMethod("TRACE");
                return;
            }
            case 7: {
                void var1_1;
                var1_1.setRequestMethod("PATCH");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte[] parseBodyIfExists(int requestMethod, Map<String, String> body) throws IOException {
        void var1_1;
        byte[] byArray = null;
        switch (var1_1) {
            case 0: {
                break;
            }
            case 3: {
                break;
            }
            case 1: {
                byArray = this.encodeParameters(body, Encoding);
                break;
            }
            case 2: {
                byArray = this.encodeParameters(body, Encoding);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                void var2_2;
                byArray = this.encodeParameters((Map<String, String>)var2_2, Encoding);
            }
        }
        return byArray;
    }

    private String getBodyContentType() {
        return "application/json; charset=UTF-8";
    }

    private String getParameterString(Map<String, String> params, String paramsEncoding) {
        if (params != null && params.size() > 0) {
            Exception exception;
            StringBuilder stringBuilder = new StringBuilder();
            try {
                for (Map.Entry entry : exception.entrySet()) {
                    stringBuilder.append(URLEncoder.encode((String)entry.getKey(), paramsEncoding));
                    stringBuilder.append('=');
                    stringBuilder.append(URLEncoder.encode((String)entry.getValue(), paramsEncoding));
                    stringBuilder.append('&');
                }
                return stringBuilder.toString();
            }
            catch (Exception exception2) {
                exception = exception2;
                FileDownloader.printErr(exception2);
                return null;
            }
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private byte[] encodeParameters(Map<String, String> params, String paramsEncoding) {
        try {
            void var1_1;
            return this.getParameterString((Map<String, String>)var1_1, paramsEncoding).getBytes(paramsEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void var2_3;
            System.out.println("Encoding not supported: " + (String)var2_3);
            FileDownloader.printErr(unsupportedEncodingException);
            return null;
        }
    }

    private void addHeader(HttpURLConnection connection, Map<String, String> header) {
        if (header != null && header.size() > 0) {
            for (String string : header.keySet()) {
                connection.addRequestProperty(string, header.get(string));
            }
        }
    }

    private void disableConnectionReuseIfNecessary() {
    }

    private static void printErr(Exception e2) {
        e2.printStackTrace();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean hasResponseBody(int requestMethod, int responseCode) {
        void var1_1;
        return requestMethod != 4 && (100 > responseCode || responseCode >= 200) && responseCode != 204 && var1_1 != 304;
    }

    private static InputStream inputStreamFromConnection(HttpURLConnection connection) {
        InputStream inputStream;
        try {
            inputStream = connection.getInputStream();
        }
        catch (IOException iOException) {
            HttpURLConnection httpURLConnection;
            inputStream = httpURLConnection.getErrorStream();
        }
        return inputStream;
    }

    static List<Header> convertHeaders(Map<String, List<String>> responseHeaders) {
        Object object;
        ArrayList<Header> arrayList = new ArrayList<Header>(responseHeaders.size());
        for (Map.Entry entry : object.entrySet()) {
            if (entry.getKey() == null) continue;
            for (String string : (List)entry.getValue()) {
                arrayList.add(new Header((String)entry.getKey(), string));
            }
        }
        return arrayList;
    }

    private static void trustAllHosts() {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            @Override
            public final X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public final void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public final void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            FileDownloader.printErr(exception);
            return;
        }
    }

    public static String getFileNameFromResp(HttpResponse response) {
        Object object;
        try {
            object = response.getFirstHeader("Content-Disposition");
            if (object != null) {
                object = ((Header)object).getValue();
                String string = "filename=";
                Object object2 = object;
                object = URLDecoder.decode(((String)object2).substring(((String)object2).indexOf(string) + string.length()), Encoding);
                return object;
            }
        }
        catch (Exception exception) {
            object = exception;
            FileDownloader.printErr(exception);
        }
        return "";
    }

    public static void main(String[] args) throws IOException {
        Object object = "http://58.216.25.11/dd.myapp.com/16891/82AC0A1038B408BC66B537480985A039.apk?mkey=554c014d24a24841&f=a315&fsname=com.netease.newsreader.activity_4.4.4_400.apk&asr=8eff&p=.apk";
        try {
            Throwable throwable = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream("F:\\download.apk", false);){
                Throwable throwable2 = null;
                try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
                    Throwable throwable3 = null;
                    try (FileDownloader fileDownloader = new FileDownloader();){
                        int n2;
                        fileDownloader.performStreamRequest((String)object, 0, null, null);
                        int n3 = fileDownloader.getContentLength();
                        System.out.println("\u6587\u4ef6\u540d:" + fileDownloader.getFileName());
                        System.out.println("\u6587\u4ef6\u5927\u5c0f:" + n3);
                        long l2 = 0L;
                        while ((n2 = fileDownloader.transferTo(bufferedOutputStream)) > 0) {
                            System.out.println("\u5df2\u4e0b\u8f7d:" + (l2 += (long)n2) + ",\u767e\u5206\u6bd4:" + l2 * 100L / (long)n3);
                        }
                        System.out.println("\u5b8c\u6210");
                    }
                    catch (Throwable throwable4) {
                        object = throwable4;
                        throwable3 = throwable4;
                        throw object;
                    }
                }
                catch (Throwable throwable5) {
                    Throwable throwable6 = throwable5;
                    throwable2 = throwable5;
                    throw throwable6;
                }
            }
            catch (Throwable throwable7) {
                Throwable throwable8 = throwable7;
                throwable = throwable7;
                throw throwable8;
            }
        }
        catch (Exception exception) {}
        System.out.println("\u6587\u4ef6\u4fdd\u5b58\u6210\u529f");
    }

    static class UrlConnectionInputStream
    extends FilterInputStream {
        private final HttpURLConnection mConnection;

        /*
         * WARNING - void declaration
         */
        UrlConnectionInputStream(HttpURLConnection connection) {
            super(FileDownloader.inputStreamFromConnection(connection));
            void var1_1;
            this.mConnection = var1_1;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.mConnection.disconnect();
        }
    }
}

