/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.log;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import tech.simkey.dove.json.JsonUtil;
import tech.simkey.dove.security.HexStringConvert;
import tech.simkey.dove.util.LocalConfig;
import tech.simkey.dove.util.ParamsEmptyChecker;
import tech.simkey.dove.util.StringAppend;
import tech.simkey.dove.util.UUIDUtils;

public class MethodLog {
    private String methodName;
    private Map<String, Object> params;
    private Object result;
    private boolean logTime = true;
    private boolean logDetial = true;
    private long startTime;
    private long endTime;
    private String moduledName;
    private String stringParam;
    private String uuid = "";
    private String extendInfo = "";

    private MethodLog() {
        this.uuid = UUIDUtils.createUUID();
    }

    /*
     * WARNING - void declaration
     */
    private MethodLog(String moduledName) {
        this((String)var1_1, UUIDUtils.createUUID());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private MethodLog(String moduledName, String uuid) {
        void var1_1;
        void var2_2;
        this.uuid = var2_2;
        this.startTime = System.currentTimeMillis();
        this.moduledName = moduledName;
        if (ParamsEmptyChecker.isEmpty((String)var1_1)) {
            this.moduledName = "";
        }
    }

    public static MethodLog newMethodLog(String moduledName) {
        String string;
        return new MethodLog(string);
    }

    /*
     * WARNING - void declaration
     */
    public static MethodLog newMethodLog(String moduledName, String uuid) {
        void var1_1;
        String string;
        return new MethodLog(string, (String)var1_1);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.logDetial) {
            stringBuilder.append(this.moduledName).append("\u63a5\u53e3:").append(this.methodName).append("\u7ed3\u675f\u8c03\u7528<==").append(LocalConfig.CR);
            if (this.result == null) {
                stringBuilder.append("\u54cd\u5e94\u7ed3\u679c\u662f:\u65e0\u7ed3\u679c\u8fd4\u56de\u7c7b\u578b").append(LocalConfig.CR);
            } else if (this.result instanceof Collection) {
                stringBuilder.append("\u54cd\u5e94\u7ed3\u679c\u662f:").append(JsonUtil.toJson(this.result)).append(LocalConfig.CR);
            } else if (this.result instanceof byte[]) {
                stringBuilder.append("\u54cd\u5e94\u7ed3\u679c\u662f:byte[]\u5341\u516d\u8fdb\u5236\u663e\u793a:").append(HexStringConvert.parseByte2HexStr((byte[])this.result)).append(LocalConfig.CR);
            } else {
                stringBuilder.append("\u54cd\u5e94\u7ed3\u679c\u662f:").append(this.result.toString()).append(LocalConfig.CR);
            }
        }
        if (!ParamsEmptyChecker.isEmpty(this.extendInfo)) {
            stringBuilder.append("\u6269\u5c55\u4fe1\u606f:").append(this.extendInfo).append(LocalConfig.CR);
        }
        stringBuilder.append("\u7ed3\u675f\u8bf7\u6c42\u6807\u793a\u6233:").append(this.uuid).append(LocalConfig.CR);
        if (this.logTime) {
            if (this.endTime == 0L) {
                this.endTime = System.currentTimeMillis();
            }
            stringBuilder.append("\u8fd0\u884c\u8017\u65f6(ms):").append(this.endTime - this.startTime).append(LocalConfig.CR);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void appendParam(StringBuilder sb) {
        void var1_1;
        String string = "";
        if (!ParamsEmptyChecker.isEmpty(this.stringParam)) {
            string = this.stringParam;
        }
        if (this.params != null) {
            String string2 = JsonUtil.toJson(this.params);
            string = string + string2;
            string = string.replace("}{", ",");
        }
        if (ParamsEmptyChecker.isEmpty(string)) {
            sb.append("\u8bf7\u6c42\u53c2\u6570\u662f:\u65e0\u5165\u53c2\u7c7b\u578b").append(LocalConfig.CR);
            return;
        }
        var1_1.append("\u8bf7\u6c42\u53c2\u6570\u662f:").append(string).append(LocalConfig.CR);
    }

    public String startHint() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.moduledName).append("\u63a5\u53e3:").append(this.methodName).append("\u5f00\u59cb\u8c03\u7528==>").append(LocalConfig.CR);
        this.appendParam(stringBuilder);
        stringBuilder.append("\u8bf7\u6c42\u53c2\u6570\u6253\u5370\u5b8c\u6bd5").append(LocalConfig.CR);
        stringBuilder.append("\u5f00\u59cb\u8bf7\u6c42\u6807\u793a\u6233:").append(this.uuid).append(LocalConfig.CR);
        return stringBuilder.toString();
    }

    public String end() {
        String string = this.toString();
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public MethodLog methodName(String val) {
        void var1_1;
        this.methodName = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public MethodLog addParam(String paramName, Object paramValue) {
        if (this.params == null) {
            this.params = new LinkedHashMap<String, Object>();
        }
        if (paramValue instanceof byte[]) {
            this.params.put(paramName, HexStringConvert.parseByte2HexStr((byte[])paramValue));
        } else {
            void var2_2;
            void var1_1;
            this.params.put((String)var1_1, var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public MethodLog setParam(String paramValue) {
        void var1_1;
        this.stringParam = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public MethodLog result(Object val) {
        void var1_1;
        this.result = var1_1;
        this.endTime = System.currentTimeMillis();
        return this;
    }

    public MethodLog voidResult() {
        this.result = "Void\u8fd4\u56de\u503c\u7c7b\u578b";
        this.endTime = System.currentTimeMillis();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public MethodLog errorResult(Exception e2) {
        void var1_1;
        this.result = StringAppend.joinDirect("\u53d1\u751f\u5f02\u5e38:" + var1_1.getMessage());
        this.endTime = System.currentTimeMillis();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public MethodLog extendInfo(String extendInfo) {
        void var1_1;
        this.extendInfo = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public MethodLog logTime(boolean val) {
        void var1_1;
        this.logTime = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public MethodLog logDetial(boolean val) {
        void var1_1;
        this.logDetial = var1_1;
        return this;
    }
}

