/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.util.Locale;
import tech.simkey.dove.log.CLog;
import tech.simkey.dove.security.sm3.SM3Digest;

public final class HashUtil {
    private static final String TAG = "HashUtil";
    private static final String ENCODING = "UTF-8";
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA1";
    public static final String SHA256 = "SHA-256";
    public static final String SHA512 = "SHA-512";
    public static final String SM3 = "SM3";

    public static byte[] getDigestBytes(byte[] content, String algorithm) {
        try {
            byte[] byArray;
            MessageDigest messageDigest;
            if ("sm3".equalsIgnoreCase(algorithm)) {
                return SM3Digest.hash(content);
            }
            messageDigest = MessageDigest.getInstance((String)((Object)messageDigest));
            byArray = messageDigest.digest(byArray);
            return byArray;
        }
        catch (Exception exception) {
            CLog.e(TAG, exception.getMessage(), exception);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getDigest(byte[] content, String algorithm) {
        try {
            String string = HashUtil.parseByte2HexStr(HashUtil.getDigestBytes(content, algorithm));
            Object object = string;
            return string;
        }
        catch (Exception exception) {
            void var1_1;
            CLog.d(TAG, (String)var1_1 + " failure!!!");
            return "";
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getDigest(String content, String algorithm) {
        try {
            void var1_1;
            return HashUtil.getDigest(content.getBytes(ENCODING), (String)var1_1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            UnsupportedEncodingException unsupportedEncodingException2 = unsupportedEncodingException;
            unsupportedEncodingException.printStackTrace();
            return "";
        }
    }

    public static String getSHA1Digest(String content) {
        return HashUtil.getDigest(content, SHA1);
    }

    private static String parseByte2HexStr(byte[] buf) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < buf.length; ++i2) {
            String string = Integer.toHexString(buf[i2] & 0xFF);
            if (string.length() == 1) {
                string = "0" + string;
            }
            stringBuilder.append(string.toUpperCase(Locale.getDefault()));
        }
        return stringBuilder.toString();
    }

    private static byte[] getDigestBytes(InputStream is, String algorithm) {
        try {
            int n2;
            Object object;
            if ("sm3".equalsIgnoreCase(algorithm)) {
                int n3;
                object = new byte[32];
                SM3Digest sM3Digest = new SM3Digest();
                byte[] byArray = new byte[1024];
                while ((n3 = is.read(byArray)) > 0) {
                    sM3Digest.update(byArray, 0, n3);
                }
                sM3Digest.doFinal((byte[])object, 0);
                return object;
            }
            object = MessageDigest.getInstance((String)object);
            byte[] byArray = new byte[1024];
            while ((n2 = is.read(byArray)) > 0) {
                ((MessageDigest)object).update(byArray, 0, n2);
            }
            return ((MessageDigest)object).digest();
        }
        catch (Exception exception) {
            CLog.e(TAG, exception.getMessage(), exception);
            return new byte[0];
        }
    }

    public static byte[] getDigestBytes(File file, String algorithm) throws IOException {
        Object object;
        BufferedInputStream bufferedInputStream;
        bufferedInputStream = new BufferedInputStream(Files.newInputStream(((File)((Object)bufferedInputStream)).toPath(), new OpenOption[0]));
        Throwable throwable = null;
        try {
            object = HashUtil.getDigestBytes(bufferedInputStream, (String)object);
            return object;
        }
        catch (Throwable throwable2) {
            object = throwable2;
            throwable = throwable2;
            throw object;
        }
        finally {
            if (throwable != null) {
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
            } else {
                ((InputStream)bufferedInputStream).close();
            }
        }
    }
}

