/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.security.cer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import tech.simkey.dove.bc.BCProviderUtil;
import tech.simkey.dove.security.HexStringConvert;
import tech.simkey.dove.security.rsa.RSAUtils;
import tech.simkey.dove.security.sm2.SM2UtilsC132No04;
import tech.simkey.dove.util.TimestampUtil;

public class CerUtil {
    public static java.security.cert.Certificate parser2Cer(byte[] cerBytes) throws CertificateException {
        Object object;
        java.security.cert.CertificateFactory certificateFactory = java.security.cert.CertificateFactory.getInstance("X.509", (Provider)BCProviderUtil.getBCProvider());
        object = new ByteArrayInputStream((byte[])object);
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)object);
        object = x509Certificate;
        return x509Certificate;
    }

    public static java.security.cert.Certificate parser2Cer2(byte[] cerBytes) throws CertificateException {
        Object object;
        object = new ByteArrayInputStream((byte[])object);
        CertificateFactory certificateFactory = new CertificateFactory();
        java.security.cert.Certificate certificate = certificateFactory.engineGenerateCertificate((InputStream)object);
        object = certificate;
        return certificate;
    }

    public static Certificate parser2Cer3(byte[] cerBytes) throws CertificateException {
        Certificate certificate = Certificate.getInstance((Object)cerBytes);
        Object object = certificate;
        return certificate;
    }

    public static PublicKey getPublicKey(byte[] cerBytes) throws CertificateException {
        Object object = CerUtil.parser2Cer(cerBytes);
        try {
            return ((java.security.cert.Certificate)object).getPublicKey();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String getPublicKeyHex(byte[] cerBytes) throws CertificateException, IOException {
        PublicKey publicKey = CerUtil.getPublicKey(cerBytes);
        if (publicKey == null) {
            Object object;
            TBSCertificate tBSCertificate = TBSCertificate.getInstance((Object)((X509Certificate)CerUtil.parser2Cer(object)).getTBSCertificate());
            object = tBSCertificate;
            DERBitString dERBitString = tBSCertificate.getSubjectPublicKeyInfo().getPublicKeyData();
            object = dERBitString;
            return HexStringConvert.parseByte2HexStr(dERBitString.getBytes()).substring(2);
        }
        if (publicKey instanceof RSAPublicKey) {
            return RSAUtils.toHexPublicKey((RSAPublicKey)publicKey);
        }
        if (publicKey instanceof ECPublicKey) {
            return SM2UtilsC132No04.toHexPublicKey((ECPublicKey)publicKey);
        }
        return "";
    }

    public static List<X509Certificate> getCertificates(byte[] p7b) throws Exception {
        Object object;
        CMSSignedData cMSSignedData = new CMSSignedData((byte[])object);
        object = cMSSignedData;
        object = cMSSignedData.getCertificates();
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
        ArrayList arrayList2 = (ArrayList)object.getMatches(null);
        object = arrayList2;
        object = arrayList2.iterator();
        while (object.hasNext()) {
            Object object2 = (X509CertificateHolder)object.next();
            object2 = jcaX509CertificateConverter.setProvider((Provider)BCProviderUtil.getBCProvider()).getCertificate(object2);
            arrayList.add((X509Certificate)object2);
        }
        return arrayList;
    }

    public static void printCer(byte[] cerBytes) {
        Object object;
        try {
            object = new ByteArrayInputStream((byte[])object);
            Object object2 = java.security.cert.CertificateFactory.getInstance("X.509", (Provider)BCProviderUtil.getBCProvider());
            object = (X509Certificate)((java.security.cert.CertificateFactory)object2).generateCertificate((InputStream)object);
            System.out.println("getSerialNumber:" + ((X509Certificate)object).getSerialNumber());
            System.out.println("getSerialNumberHex:" + ((X509Certificate)object).getSerialNumber().toString(16));
            System.out.println("getVersion:" + ((X509Certificate)object).getVersion());
            System.out.println("getSigAlgName:" + ((X509Certificate)object).getSigAlgName());
            System.out.println("getPublicKey:" + ((java.security.cert.Certificate)object).getPublicKey());
            System.out.println("getNotBefore:" + TimestampUtil.parserDateToString(((X509Certificate)object).getNotBefore(), "yyyy-MM-dd HH:mm:ss"));
            System.out.println("getNotAfter:" + TimestampUtil.parserDateToString(((X509Certificate)object).getNotAfter(), "yyyy-MM-dd HH:mm:ss"));
            System.out.println("getSubjectDN:" + ((X509Certificate)object).getSubjectDN());
            if (((java.security.cert.Certificate)object).getPublicKey() instanceof RSAPublicKey) {
                object2 = (RSAPublicKey)((java.security.cert.Certificate)object).getPublicKey();
                System.out.println("rsaPublicKey.getPublicExponent:" + object2.getPublicExponent());
                System.out.println("rsaPublicKey_getModulus:" + object2.getModulus());
                System.out.println("rsaPublicKey_getModulus_hex:" + object2.getModulus().toString(16));
                System.out.println("rsaPublicKey.getModulus hex length:" + object2.getModulus().toString(16).length());
                System.out.println("rsaPublicKey.getModulus bit length:" + object2.getModulus().bitLength());
                System.out.println("rsaPublicKey_getEncoded:" + HexStringConvert.parseByte2HexStr(object2.getEncoded()));
                System.out.println("rsaPublicKey.getFormat:" + object2.getFormat());
                System.out.println("rsaPublicKey.getAlgorithm:" + object2.getAlgorithm());
            }
            object2 = object.getCriticalExtensionOIDs();
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (String)object.next();
                System.out.println("oid:" + (String)object2);
            }
            return;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return;
        }
    }
}

