/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.security.hmac;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import tech.simkey.dove.num.ByteUtil;
import tech.simkey.dove.security.HashUtil;
import tech.simkey.dove.security.HexStringConvert;

public class HMac {
    private static final String SM3 = "SM3";
    private static final String SHA256 = "SHA-256";
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;

    /*
     * WARNING - void declaration
     */
    private static byte[] hmac(byte[] key, byte[] message, String hashAlg, int blocksize) {
        void var2_2;
        byte[] byArray;
        byte[] byArray2;
        void var3_3;
        if (key.length > blocksize) {
            key = HMac.hash(key, hashAlg);
        }
        byte[] byArray3 = new byte[blocksize];
        if (key.length < var3_3) {
            System.arraycopy(key, 0, byArray3, 0, key.length);
        } else {
            byArray3 = byArray2;
        }
        byArray2 = HMac.xorPad(byArray3, byArray3.length, (byte)92);
        byte[] byArray4 = HMac.xorPad(byArray3, byArray3.length, (byte)54);
        byArray = ByteUtil.contact(byArray4, byArray);
        byArray = HMac.hash(byArray, hashAlg);
        byArray2 = ByteUtil.contact(byArray2, byArray);
        return HMac.hash(byArray2, (String)var2_2);
    }

    private static byte[] xorPad(byte[] key, int len, byte mask) {
        byte[] byArray = new byte[len];
        for (int i2 = 0; i2 < len; ++i2) {
            byArray[i2] = (byte)(key[i2] ^ mask);
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] hash(byte[] msg, String hashAlg) {
        void var1_1;
        if (SM3.equals(hashAlg)) {
            return HashUtil.getDigestBytes(msg, SM3);
        }
        if (SHA256.equals(var1_1)) {
            byte[] byArray;
            return HashUtil.getDigestBytes(byArray, SHA256);
        }
        return new byte[0];
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] hmacSha256(byte[] key, byte[] message) {
        void var1_1;
        return HMac.hmac(key, (byte[])var1_1, SHA256, 64);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] hmacSm3(byte[] key, byte[] message) {
        void var1_1;
        return HMac.hmac(key, (byte[])var1_1, SM3, 64);
    }

    public static void main(String[] agrs) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        Object[] objectArray = HexStringConvert.parseHexStr2Byte("11223344556677881122334455667788");
        byte[] byArray = "11223344556677881122334455667788112233445566778811223344556677881122334455667788112233445566778811223344556677881122334455667788".getBytes();
        byte[] byArray2 = HMac.hmacSha256((byte[])objectArray, byArray);
        System.out.println(HexStringConvert.parseByte2HexStr(byArray2));
        System.out.println(HexStringConvert.parseByte2HexStr(HMac.getHmacSHA256((byte[])objectArray, byArray)));
        System.out.println(HexStringConvert.parseByte2HexStr(HMac.hmacSm3((byte[])objectArray, byArray)));
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] getHmacSHA256(byte[] key, byte[] message) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException {
        void var1_1;
        Object object;
        Mac mac = Mac.getInstance("HmacSHA256");
        object = new SecretKeySpec((byte[])object, mac.getAlgorithm());
        mac.init((Key)object);
        return mac.doFinal((byte[])var1_1);
    }
}

