/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.security.mac;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class ISO9797Alg3Mac
implements Mac {
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private BlockCipher cipher;
    private BlockCipherPadding padding;
    private int macSize;
    private KeyParameter lastKey2;
    private KeyParameter lastKey3;

    /*
     * WARNING - void declaration
     */
    public ISO9797Alg3Mac(BlockCipher cipher) {
        void var1_1;
        void v0 = var1_1;
        this((BlockCipher)v0, v0.getBlockSize() << 3, null);
    }

    /*
     * WARNING - void declaration
     */
    public ISO9797Alg3Mac(BlockCipher cipher, BlockCipherPadding padding) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this((BlockCipher)v0, v0.getBlockSize() << 3, (BlockCipherPadding)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ISO9797Alg3Mac(BlockCipher cipher, int macSizeInBits) {
        this((BlockCipher)var1_1, (int)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ISO9797Alg3Mac(BlockCipher cipher, int macSizeInBits, BlockCipherPadding padding) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (macSizeInBits % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        if (!(cipher instanceof DESEngine)) {
            throw new IllegalArgumentException("cipher must be instance of DESEngine");
        }
        this.cipher = new CBCBlockCipher(cipher);
        this.padding = var3_3;
        this.macSize = var2_2 / 8;
        this.mac = new byte[cipher.getBlockSize()];
        this.buf = new byte[var1_1.getBlockSize()];
        this.bufOff = 0;
    }

    public String getAlgorithmName() {
        return "ISO9797Alg3";
    }

    /*
     * WARNING - void declaration
     */
    public void init(CipherParameters params) {
        this.reset();
        if (!(params instanceof KeyParameter) && !(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("params must be an instance of KeyParameter or ParametersWithIV");
        }
        KeyParameter keyParameter = params instanceof KeyParameter ? (KeyParameter)params : (KeyParameter)((ParametersWithIV)params).getParameters();
        byte[] byArray = keyParameter.getKey();
        if (byArray.length == 16) {
            keyParameter = new KeyParameter(byArray, 0, 8);
            this.lastKey2 = new KeyParameter(byArray, 8, 8);
            this.lastKey3 = keyParameter;
        } else if (byArray.length == 24) {
            keyParameter = new KeyParameter(byArray, 0, 8);
            this.lastKey2 = new KeyParameter(byArray, 8, 8);
            this.lastKey3 = new KeyParameter(byArray, 16, 8);
        } else {
            throw new IllegalArgumentException("Key must be either 112 or 168 bit long");
        }
        if (params instanceof ParametersWithIV) {
            void var1_1;
            this.cipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, ((ParametersWithIV)var1_1).getIV()));
            return;
        }
        this.cipher.init(true, (CipherParameters)keyParameter);
    }

    public int getMacSize() {
        return this.macSize;
    }

    /*
     * WARNING - void declaration
     */
    public void update(byte in) {
        void var1_1;
        if (this.bufOff == this.buf.length) {
            this.cipher.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void update(byte[] in, int inOff, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (len < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n2 = this.cipher.getBlockSize();
        int n3 = n2 - this.bufOff;
        if (len > n3) {
            System.arraycopy(in, inOff, this.buf, this.bufOff, n3);
            this.cipher.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
            len -= n3;
            inOff += n3;
            while (len > n2) {
                this.cipher.processBlock(in, inOff, this.mac, 0);
                len -= n2;
                inOff += n2;
            }
        }
        System.arraycopy(var1_1, (int)var2_2, this.buf, this.bufOff, len);
        this.bufOff += var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public int doFinal(byte[] out, int outOff) {
        void var2_2;
        void var1_1;
        int n2 = this.cipher.getBlockSize();
        if (this.padding == null) {
            while (this.bufOff < n2) {
                this.buf[this.bufOff] = 0;
                ++this.bufOff;
            }
        } else {
            if (this.bufOff == n2) {
                this.cipher.processBlock(this.buf, 0, this.mac, 0);
                this.bufOff = 0;
            }
            this.padding.addPadding(this.buf, this.bufOff);
        }
        this.cipher.processBlock(this.buf, 0, this.mac, 0);
        DESEngine dESEngine = new DESEngine();
        dESEngine.init(false, (CipherParameters)this.lastKey2);
        dESEngine.processBlock(this.mac, 0, this.mac, 0);
        dESEngine.init(true, (CipherParameters)this.lastKey3);
        dESEngine.processBlock(this.mac, 0, this.mac, 0);
        System.arraycopy(this.mac, 0, var1_1, (int)var2_2, this.macSize);
        this.reset();
        return this.macSize;
    }

    public void reset() {
        for (int i2 = 0; i2 < this.buf.length; ++i2) {
            this.buf[i2] = 0;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

