/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.security.rsa;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import tech.simkey.dove.security.HexStringConvert;

public class RSAUtils {
    public static final String KEY_ALGORITHM = "RSA/None/PKCS1Padding";
    private static final String PROVIDER = "BC";
    public static final String SIGNATURE_ALGORITHM = "SHA1withRSA";

    private static byte[] hex2byte(String str) {
        int n2 = str.length();
        byte[] byArray = new byte[n2 / 2];
        for (int i2 = 0; i2 < n2 / 2; ++i2) {
            String string = str.substring(i2 << 1, (i2 << 1) + 2);
            byArray[i2] = (byte)Integer.parseInt(string, 16);
        }
        return byArray;
    }

    private static String byte2hex(byte[] b2) {
        String string = "";
        for (int i2 = 0; i2 < b2.length; ++i2) {
            String string2 = Integer.toHexString(b2[i2] & 0xFF);
            string = string2.length() == 1 ? string + "0" + string2 : string + string2;
            if (i2 >= b2.length - 1) continue;
            string = string;
        }
        return string.toUpperCase();
    }

    public static KeyPair genKeypair(int keysize) throws NoSuchAlgorithmException {
        int n2;
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(n2);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    /*
     * WARNING - void declaration
     */
    public static String sign(byte[] data, RSAPrivateKey privateK) throws Exception {
        byte[] byArray;
        void var1_1;
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign((PrivateKey)var1_1);
        signature.update(byArray);
        byArray = signature.sign();
        return RSAUtils.byte2hex(byArray);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean verify(byte[] data, RSAPublicKey publicKey, String sign) throws Exception {
        void var2_2;
        byte[] byArray;
        void var1_1;
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify((PublicKey)var1_1);
        signature.update(byArray);
        return signature.verify(RSAUtils.hex2byte((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean verify(byte[] data, RSAPublicKey publicKey, String sign, String algorithm) throws Exception {
        void var2_2;
        byte[] byArray;
        void var1_1;
        Signature signature = Signature.getInstance(algorithm);
        signature.initVerify((PublicKey)var1_1);
        signature.update(byArray);
        return signature.verify(RSAUtils.hex2byte((String)var2_2));
    }

    public static byte[] decryptByPrivateKey(byte[] encryptedData, RSAPrivateKey privateKey) throws Exception {
        byte[] byArray;
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(2, privateKey);
        int n2 = encryptedData.length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        int n4 = 0;
        int n5 = RSAUtils.getmaxEncryptBlock(byArray.getModulus());
        while (n2 - n3 > 0) {
            byArray = n2 - n3 > n5 ? cipher.doFinal(encryptedData, n3, n5) : cipher.doFinal(encryptedData, n3, n2 - n3);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            n3 = ++n4 * n5;
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray2;
    }

    private static int getmaxEncryptBlock(BigInteger modulus) {
        int n2 = modulus.bitLength();
        return n2 / 8;
    }

    public static byte[] decryptByPublicKey(byte[] encryptedData, RSAPublicKey publicK) throws Exception {
        byte[] byArray;
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM, PROVIDER);
        cipher.init(2, publicK);
        int n2 = encryptedData.length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        int n4 = 0;
        int n5 = RSAUtils.getmaxEncryptBlock(byArray.getModulus());
        while (n2 - n3 > 0) {
            byArray = n2 - n3 > n5 ? cipher.doFinal(encryptedData, n3, n5) : cipher.doFinal(encryptedData, n3, n2 - n3);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            n3 = ++n4 * n5;
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray2;
    }

    public static byte[] encryptByPublicKey(byte[] data, RSAPublicKey publicK) throws Exception {
        byte[] byArray;
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(1, publicK);
        int n2 = data.length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        int n4 = 0;
        int n5 = RSAUtils.getMAX_ENCRYPT_BLOCK(byArray.getModulus());
        while (n2 - n3 > 0) {
            byArray = n2 - n3 > n5 ? cipher.doFinal(data, n3, n5) : cipher.doFinal(data, n3, n2 - n3);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            n3 = ++n4 * n5;
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray2;
    }

    private static int getMAX_ENCRYPT_BLOCK(BigInteger modulus) {
        int n2 = RSAUtils.getmaxEncryptBlock(modulus);
        return n2 - 11;
    }

    private static KeyFactory getKeyFactory() throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyFactory.getInstance("RSA");
    }

    public static byte[] encryptByPrivateKey(byte[] data, RSAPrivateKey privateK) throws Exception {
        byte[] byArray;
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(1, privateK);
        int n2 = data.length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        int n4 = 0;
        int n5 = RSAUtils.getmaxEncryptBlock(byArray.getModulus());
        while (n2 - n3 > 0) {
            byArray = n2 - n3 > n5 ? cipher.doFinal(data, n3, n5) : cipher.doFinal(data, n3, n2 - n3);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            n3 = ++n4 * n5;
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray2;
    }

    public static RSAPublicKey toPublicKey(String hexPublicKey) throws Exception {
        Object object;
        object = new BigInteger((String)object, 16);
        Object object2 = new BigInteger("65537");
        object = new RSAPublicKeySpec((BigInteger)object, (BigInteger)object2);
        object2 = KeyFactory.getInstance("RSA");
        object = ((KeyFactory)object2).generatePublic((KeySpec)object);
        return (RSAPublicKey)object;
    }

    public static RSAPrivateKey toPrivateKey(String hexMululs, String hexPrivateKey) throws Exception {
        Object object;
        Object object2;
        object2 = new BigInteger((String)object2, 16);
        object = new BigInteger((String)object, 16);
        object2 = new RSAPrivateKeySpec((BigInteger)object2, (BigInteger)object);
        object = KeyFactory.getInstance("RSA");
        object2 = ((KeyFactory)object).generatePrivate((KeySpec)object2);
        return (RSAPrivateKey)object2;
    }

    public static String toHexPublicKey(RSAPublicKey publicKey) {
        Object object = HexStringConvert.parseByte2HexStr(publicKey.getModulus().toByteArray());
        int n2 = ((String)object).length() / 256;
        Object object2 = object;
        object = ((String)object2).substring(((String)object2).length() - n2 * 256);
        return object;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

