/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.security.sm2;

import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;
import tech.simkey.dove.security.sm2.SM2;
import tech.simkey.dove.security.sm2.Util;
import tech.simkey.dove.security.sm3.SM3Digest;

public class Cipher {
    private int ct = 1;
    private ECPoint p2;
    private SM3Digest sm3keybase;
    private SM3Digest sm3c3;
    private byte[] key = new byte[32];
    private byte keyOff = 0;

    private void Reset() {
        this.sm3keybase = new SM3Digest();
        this.sm3c3 = new SM3Digest();
        byte[] byArray = Util.byteConvert32Bytes(this.p2.normalize().getXCoord().toBigInteger());
        this.sm3keybase.update(byArray, 0, byArray.length);
        this.sm3c3.update(byArray, 0, byArray.length);
        byArray = Util.byteConvert32Bytes(this.p2.normalize().getYCoord().toBigInteger());
        this.sm3keybase.update(byArray, 0, byArray.length);
        this.ct = 1;
        this.NextKey();
    }

    private void NextKey() {
        SM3Digest sM3Digest = new SM3Digest(this.sm3keybase);
        sM3Digest.update((byte)(this.ct >>> 24));
        sM3Digest.update((byte)(this.ct >> 16));
        sM3Digest.update((byte)(this.ct >> 8));
        sM3Digest.update((byte)this.ct);
        sM3Digest.doFinal(this.key, 0);
        this.keyOff = 0;
        ++this.ct;
    }

    /*
     * WARNING - void declaration
     */
    public ECPoint Init_enc(SM2 sm2, ECPoint userKey) {
        void var2_2;
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = sm2.ecc_key_pair_generator.generateKeyPair();
        Object object = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        asymmetricCipherKeyPair = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        object = object.getD();
        asymmetricCipherKeyPair = asymmetricCipherKeyPair.getQ();
        this.p2 = var2_2.multiply((BigInteger)object);
        this.Reset();
        return asymmetricCipherKeyPair;
    }

    public void Encrypt(byte[] data) {
        this.sm3c3.update(data, 0, data.length);
        int n2 = 0;
        while (n2 < data.length) {
            if (this.keyOff == this.key.length) {
                this.NextKey();
            }
            int n3 = n2++;
            byte by = this.keyOff;
            this.keyOff = (byte)(by + 1);
            data[n3] = (byte)(data[n3] ^ this.key[by]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void Init_dec(BigInteger userD, ECPoint c1) {
        void var1_1;
        void var2_2;
        this.p2 = var2_2.multiply((BigInteger)var1_1);
        this.Reset();
    }

    /*
     * WARNING - void declaration
     */
    public void Decrypt(byte[] data) {
        void var1_1;
        int n2 = 0;
        while (n2 < data.length) {
            if (this.keyOff == this.key.length) {
                this.NextKey();
            }
            int n3 = n2++;
            byte by = this.keyOff;
            this.keyOff = (byte)(by + 1);
            data[n3] = (byte)(data[n3] ^ this.key[by]);
        }
        this.sm3c3.update(data, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public void Dofinal(byte[] c3) {
        void var1_1;
        byte[] byArray = Util.byteConvert32Bytes(this.p2.normalize().getYCoord().toBigInteger());
        this.sm3c3.update(byArray, 0, byArray.length);
        this.sm3c3.doFinal((byte[])var1_1, 0);
        this.Reset();
    }
}

