/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.security.sm2;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.spec.SM2ParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import tech.simkey.dove.bc.BCProviderUtil;

public class GmUtil2 {
    public static final String CURVES_NAME = "sm2p256v1";
    private static final X9ECParameters x9ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
    private static final ECParameterSpec ecParameterSpec = new ECParameterSpec(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
    public static final String SIGN_ID = "1234567812345678";
    private static final int RS_LEN = 32;

    /*
     * WARNING - void declaration
     */
    public static byte[] signSm3WithSm2(byte[] msg, byte[] userId, PrivateKey privateKey) {
        void var2_2;
        void var1_1;
        return GmUtil2.rsAsn1ToPlainByteArray(GmUtil2.signSm3WithSm2Asn1Rs(msg, (byte[])var1_1, (PrivateKey)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] signSm3WithSm2Asn1Rs(byte[] msg, byte[] userId, PrivateKey privateKey) {
        try {
            byte[] byArray;
            void var2_3;
            SM2ParameterSpec sM2ParameterSpec;
            sM2ParameterSpec = new SM2ParameterSpec((byte[])sM2ParameterSpec);
            Signature signature = Signature.getInstance("SM3withSM2", BCProviderUtil.getBCProviderName());
            signature.setParameter((AlgorithmParameterSpec)sM2ParameterSpec);
            signature.initSign((PrivateKey)var2_3, new SecureRandom());
            signature.update(msg, 0, byArray.length);
            byArray = signature.sign();
            return byArray;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean verifySm3WithSm2(byte[] msg, byte[] userId, byte[] rs, PublicKey publicKey) {
        void var3_3;
        void var2_2;
        void var1_1;
        return GmUtil2.verifySm3WithSm2Asn1Rs(msg, (byte[])var1_1, GmUtil2.rsPlainByteArrayToAsn1((byte[])var2_2), (PublicKey)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean verifySm3WithSm2Asn1Rs(byte[] data, byte[] userId, byte[] asn1Signature, PublicKey publicKey) {
        try {
            void var2_3;
            byte[] byArray;
            void var3_4;
            SM2ParameterSpec sM2ParameterSpec;
            sM2ParameterSpec = new SM2ParameterSpec((byte[])sM2ParameterSpec);
            Signature signature = Signature.getInstance("SM3withSM2", BCProviderUtil.getBCProviderName());
            signature.setParameter((AlgorithmParameterSpec)sM2ParameterSpec);
            signature.initVerify((PublicKey)var3_4);
            signature.update(data, 0, byArray.length);
            return signature.verify((byte[])var2_3);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean verifySha256WithSm2Asn1Rs(byte[] data, byte[] asn1Signature, PublicKey publicKey) {
        try {
            void var1_1;
            byte[] byArray;
            void var2_2;
            Signature signature = Signature.getInstance("SHA256withSM2", BCProviderUtil.getBCProviderName());
            SM2ParameterSpec sM2ParameterSpec = new SM2ParameterSpec(SIGN_ID.getBytes());
            signature.setParameter((AlgorithmParameterSpec)sM2ParameterSpec);
            signature.initVerify((PublicKey)var2_2);
            signature.update(data, 0, byArray.length);
            return signature.verify((byte[])var1_1);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean verifySha256WithECDSAAsn1Rs(byte[] data, byte[] asn1Signature, PublicKey publicKey) {
        try {
            void var1_1;
            byte[] byArray;
            void var2_2;
            Signature signature = Signature.getInstance("SHA256withECDSA", BCProviderUtil.getBCProviderName());
            signature.initVerify((PublicKey)var2_2);
            signature.update(data, 0, byArray.length);
            return signature.verify((byte[])var1_1);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static byte[] bigIntToFixexLengthBytes(BigInteger rOrS) {
        byte[] byArray = rOrS.toByteArray();
        Object object = byArray;
        if (byArray.length == 32) {
            return object;
        }
        if (((Object)object).length == 33 && object[0] == false) {
            return Arrays.copyOfRange((byte[])object, 1, 33);
        }
        if (((Object)object).length < 32) {
            byte[] byArray2 = new byte[32];
            Arrays.fill(byArray2, (byte)0);
            System.arraycopy(object, 0, byArray2, 32 - ((Object)object).length, ((Object)object).length);
            return byArray2;
        }
        throw new RuntimeException("err rs: " + Hex.toHexString((byte[])object));
    }

    public static byte[] rsAsn1ToPlainByteArray(byte[] rsDer) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)rsDer);
        Object object = aSN1Sequence;
        byte[] byArray = GmUtil2.bigIntToFixexLengthBytes(ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(0)).getValue());
        object = GmUtil2.bigIntToFixexLengthBytes(ASN1Integer.getInstance((Object)object.getObjectAt(1)).getValue());
        byte[] byArray2 = new byte[64];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        System.arraycopy(object, 0, byArray2, 32, ((byte[])object).length);
        return byArray2;
    }

    public static byte[] rsPlainByteArrayToAsn1(byte[] sign) {
        Object object;
        if (sign.length != 64) {
            throw new RuntimeException("err rs. ");
        }
        BigInteger bigInteger = new BigInteger(1, Arrays.copyOfRange(sign, 0, 32));
        object = new BigInteger(1, Arrays.copyOfRange(object, 32, 64));
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(bigInteger));
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer((BigInteger)object));
        try {
            return new DERSequence(aSN1EncodableVector).getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static KeyPair generateKeyPair() {
        try {
            Object object = KeyPairGenerator.getInstance("EC", (Provider)BCProviderUtil.getBCProvider());
            ((KeyPairGenerator)object).initialize((AlgorithmParameterSpec)ecParameterSpec, new SecureRandom());
            object = ((KeyPairGenerator)object).generateKeyPair();
            return object;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static ECPrivateKey getPrivatekeyFromD(BigInteger d2) {
        BigInteger bigInteger;
        bigInteger = new ECPrivateKeySpec(bigInteger, ecParameterSpec);
        return new BCECPrivateKey("EC", (ECPrivateKeySpec)bigInteger, BouncyCastleProvider.CONFIGURATION);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPublicKey getPublickeyFromXY(BigInteger x2, BigInteger y2) {
        void var1_1;
        BigInteger bigInteger;
        bigInteger = new ECPublicKeySpec(x9ECParameters.getCurve().createPoint(bigInteger, (BigInteger)var1_1), ecParameterSpec);
        return new BCECPublicKey("EC", (ECPublicKeySpec)bigInteger, BouncyCastleProvider.CONFIGURATION);
    }

    public static ECPoint getPublickeyFromPrivatekey(ECPrivateKey ecPrivateKey) {
        ECPrivateKey eCPrivateKey;
        eCPrivateKey = ecParameterSpec.getG().multiply(eCPrivateKey.getS());
        return eCPrivateKey;
    }

    public static PublicKey getPublickeyFromX509File(File file) {
        try {
            Object object;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", (Provider)BCProviderUtil.getBCProvider());
            object = new FileInputStream((File)object);
            object = (X509Certificate)certificateFactory.generateCertificate((InputStream)object);
            return ((Certificate)object).getPublicKey();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    static {
        if (Security.getProvider(BCProviderUtil.getBCProviderName()) == null) {
            Security.addProvider((Provider)BCProviderUtil.getBCProvider());
        }
    }
}

