/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.security.sm2;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import tech.simkey.dove.security.sm2.SM2Result;
import tech.simkey.dove.security.sm2.Util;
import tech.simkey.dove.security.sm3.SM3Digest;
import tech.simkey.dove.util.SecureRandomSingleton;

public class SM2 {
    private static final String TAG = "SM2";
    public static String[] ecc_param = new String[]{"FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0"};
    public final BigInteger ecc_p = new BigInteger(ecc_param[0], 16);
    public final BigInteger ecc_a = new BigInteger(ecc_param[1], 16);
    public final BigInteger ecc_b = new BigInteger(ecc_param[2], 16);
    public final BigInteger ecc_n = new BigInteger(ecc_param[3], 16);
    public final BigInteger ecc_gx = new BigInteger(ecc_param[4], 16);
    public final BigInteger ecc_gy = new BigInteger(ecc_param[5], 16);
    public final ECCurve ecc_curve = new ECCurve.Fp(this.ecc_p, this.ecc_a, this.ecc_b, null, null);
    public final ECPoint ecc_point_g;
    public final ECDomainParameters ecc_bc_spec;
    public final ECKeyPairGenerator ecc_key_pair_generator;
    public final ECFieldElement ecc_gx_fieldelement = this.ecc_curve.fromBigInteger(this.ecc_gx);
    public final ECFieldElement ecc_gy_fieldelement = this.ecc_curve.fromBigInteger(this.ecc_gy);

    public static SM2 Instance() {
        return new SM2();
    }

    public SM2() {
        this.ecc_point_g = this.ecc_curve.createPoint(this.ecc_gx, this.ecc_gy);
        this.ecc_bc_spec = new ECDomainParameters(this.ecc_curve, this.ecc_point_g, this.ecc_n);
        ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(this.ecc_bc_spec, new SecureRandom());
        this.ecc_key_pair_generator = new ECKeyPairGenerator();
        this.ecc_key_pair_generator.init((KeyGenerationParameters)eCKeyGenerationParameters);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] sm2GetZ(byte[] userId, ECPoint userKey) {
        void var2_2;
        byte[] byArray;
        SM3Digest sM3Digest = new SM3Digest();
        int n2 = userId.length << 3;
        sM3Digest.update((byte)(n2 >> 8));
        sM3Digest.update((byte)n2);
        sM3Digest.update(userId, 0, byArray.length);
        byArray = Util.byteConvert32Bytes(this.ecc_a);
        sM3Digest.update(byArray, 0, byArray.length);
        byArray = Util.byteConvert32Bytes(this.ecc_b);
        sM3Digest.update(byArray, 0, byArray.length);
        byArray = Util.byteConvert32Bytes(this.ecc_gx);
        sM3Digest.update(byArray, 0, byArray.length);
        byArray = Util.byteConvert32Bytes(this.ecc_gy);
        sM3Digest.update(byArray, 0, byArray.length);
        byArray = Util.byteConvert32Bytes(userKey.normalize().getXCoord().toBigInteger());
        sM3Digest.update(byArray, 0, byArray.length);
        byArray = Util.byteConvert32Bytes(var2_2.normalize().getYCoord().toBigInteger());
        sM3Digest.update(byArray, 0, byArray.length);
        byArray = new byte[sM3Digest.getDigestSize()];
        sM3Digest.doFinal(byArray, 0);
        return byArray;
    }

    public void sm2Sign(byte[] md, BigInteger userD, ECPoint userKey, SM2Result sm2Result) {
        BigInteger bigInteger;
        Object object;
        BigInteger bigInteger2;
        bigInteger2 = new BigInteger(1, (byte[])bigInteger2);
        SecureRandom secureRandom = SecureRandomSingleton.getInstance();
        while (true) {
            Object object2 = new byte[32];
            ((Random)secureRandom).nextBytes((byte[])object2);
            BigInteger bigInteger3 = new BigInteger((byte[])object2);
            object = this.ecc_point_g.multiply(bigInteger3);
            SM2.Logd(TAG, "\u8ba1\u7b97\u66f2\u7ebf\u70b9X1: " + object.normalize().getXCoord().toBigInteger().toString(16));
            SM2.Logd(TAG, "\u8ba1\u7b97\u66f2\u7ebf\u70b9Y1: " + object.normalize().getYCoord().toBigInteger().toString(16));
            object = bigInteger2.add(object.normalize().getXCoord().toBigInteger());
            if (((BigInteger)(object = ((BigInteger)object).mod(this.ecc_n))).equals(BigInteger.ZERO) || ((BigInteger)object).add(bigInteger3).equals(this.ecc_n)) continue;
            BigInteger bigInteger4 = userD.add(BigInteger.ONE);
            object2 = bigInteger4;
            object2 = bigInteger4.modInverse(this.ecc_n);
            bigInteger = ((BigInteger)object).multiply(userD);
            bigInteger = bigInteger3.subtract(bigInteger).mod(this.ecc_n);
            if (!(bigInteger = ((BigInteger)object2).multiply(bigInteger).mod(this.ecc_n)).equals(BigInteger.ZERO)) break;
        }
        sm2Result.r = object;
        sm2Result.s = bigInteger;
    }

    /*
     * WARNING - void declaration
     */
    public void sm2Verify(byte[] md, ECPoint userKey, BigInteger r2, BigInteger s2, SM2Result sm2Result) {
        void var2_2;
        BigInteger bigInteger;
        BigInteger bigInteger2;
        sm2Result.R = null;
        bigInteger2 = new BigInteger(1, (byte[])bigInteger2);
        if ((bigInteger = bigInteger.add(s2).mod(this.ecc_n)).equals(BigInteger.ZERO)) {
            return;
        }
        ECPoint eCPoint = this.ecc_point_g.multiply(sm2Result.s);
        SM2.Logd(TAG, "\u8ba1\u7b97\u66f2\u7ebf\u70b9X0: " + eCPoint.normalize().getXCoord().toBigInteger().toString(16));
        SM2.Logd(TAG, "\u8ba1\u7b97\u66f2\u7ebf\u70b9Y0: " + eCPoint.normalize().getYCoord().toBigInteger().toString(16));
        eCPoint = eCPoint.add(var2_2.multiply(bigInteger));
        SM2.Logd(TAG, "\u8ba1\u7b97\u66f2\u7ebf\u70b9X1: " + eCPoint.normalize().getXCoord().toBigInteger().toString(16));
        SM2.Logd(TAG, "\u8ba1\u7b97\u66f2\u7ebf\u70b9Y1: " + eCPoint.normalize().getYCoord().toBigInteger().toString(16));
        sm2Result.R = bigInteger2.add(eCPoint.normalize().getXCoord().toBigInteger()).mod(this.ecc_n);
        SM2.Logd(TAG, "R: " + sm2Result.R.toString(16));
    }

    private static void Logd(String tag, String msg) {
    }
}

