/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.security.sm2;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import tech.simkey.dove.bc.BCProviderUtil;
import tech.simkey.dove.security.HexStringConvert;
import tech.simkey.dove.security.sm2.SM2;
import tech.simkey.dove.security.sm2.SM2UtilsC132No04;

public class SM2KeypairConverter {
    public static PublicKey getPubkey(String hexSMPubkey) {
        try {
            Object object;
            Object object2 = SM2.Instance();
            ECCurve.Fp fp = new ECCurve.Fp(((SM2)object2).ecc_p, ((SM2)object2).ecc_a, ((SM2)object2).ecc_b, null, null);
            fp = new ECNamedCurveParameterSpec("1.2.156.10197.1.301", (ECCurve)fp, ((SM2)object2).ecc_point_g, ((SM2)object2).ecc_n);
            String string = hexSMPubkey;
            if (hexSMPubkey.length() == 128) {
                string = "04" + (String)object;
            }
            object = ((SM2)object2).ecc_curve.decodePoint(HexStringConvert.parseHexStr2Byte(string));
            object = new ECPublicKeySpec((ECPoint)object, (ECParameterSpec)fp);
            object2 = KeyFactory.getInstance("EC", (Provider)BCProviderUtil.getBCProvider());
            object = ((KeyFactory)object2).generatePublic((KeySpec)object);
            return object;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public static String toHexPublicKey(ECPublicKey ecPublicKey) {
        return HexStringConvert.parseByte2HexStr(ecPublicKey.getQ().getEncoded(false)).substring(2);
    }

    public static PrivateKey getPrivateKey(String hexSMPrikey) {
        try {
            Object object;
            Object object2 = SM2.Instance();
            ECCurve.Fp fp = new ECCurve.Fp(((SM2)object2).ecc_p, ((SM2)object2).ecc_a, ((SM2)object2).ecc_b);
            object2 = new ECParameterSpec((ECCurve)fp, ((SM2)object2).ecc_point_g, ((SM2)object2).ecc_n);
            object = new BigInteger(1, HexStringConvert.parseHexStr2Byte((String)object));
            object = new ECPrivateKeySpec((BigInteger)object, (ECParameterSpec)object2);
            object2 = KeyFactory.getInstance("ECDSA", (Provider)BCProviderUtil.getBCProvider());
            object = ((KeyFactory)object2).generatePrivate((KeySpec)object);
            return object;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public static String toHexPrivateKey(ECPrivateKey ecPrivateKey) {
        Object object = ecPrivateKey.getD();
        return HexStringConvert.parseByte2HexStr(object.toByteArray());
    }

    public static KeyPair toKeyPair(SM2UtilsC132No04.SM2Keypair sm2Keypair) {
        PrivateKey privateKey;
        PublicKey publicKey = SM2KeypairConverter.getPubkey(sm2Keypair.pubKey);
        privateKey = SM2KeypairConverter.getPrivateKey(((SM2UtilsC132No04.SM2Keypair)((Object)privateKey)).privKey);
        return new KeyPair(publicKey, privateKey);
    }

    public static AsymmetricKeyParameter toAsymmetricKeyParameter(ECPublicKey ecPublicKey) {
        ECPublicKey eCPublicKey = ecPublicKey;
        ECParameterSpec eCParameterSpec = eCPublicKey.getParameters();
        return new ECPublicKeyParameters(eCPublicKey.getQ(), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN()));
    }
}

