/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.security.sm2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import tech.simkey.dove.security.HexStringConvert;
import tech.simkey.dove.security.sm2.Cipher;
import tech.simkey.dove.security.sm2.SM2;
import tech.simkey.dove.security.sm2.SM2Result;
import tech.simkey.dove.security.sm2.Util;
import tech.simkey.dove.security.sm3.SM3Digest;

public class SM2UtilsC132No04 {
    public static final String SM2_DEFUALT_USERID = "1234567812345678";
    private static final int strLenOfROrS = 64;
    private static final int RS_LEN = 32;

    public static SM2Keypair generateKeyPair() {
        SM2Keypair sM2Keypair = new SM2Keypair();
        SM2 sM2 = SM2.Instance();
        sM2 = sM2.ecc_key_pair_generator.generateKeyPair();
        Object object = (ECPrivateKeyParameters)sM2.getPrivate();
        sM2 = (ECPublicKeyParameters)sM2.getPublic();
        object = object.getD();
        sM2 = sM2.getQ();
        sM2Keypair.privKey = Util.byteToHex(((BigInteger)object).toByteArray());
        sM2Keypair.pubKey = Util.byteToHex(sM2.getEncoded(false)).substring(2);
        return sM2Keypair;
    }

    public static PublicKey getPubkey(String hexSMPubkey) {
        try {
            Object object;
            Object object2 = SM2.Instance();
            ECCurve.Fp fp = new ECCurve.Fp(((SM2)object2).ecc_p, ((SM2)object2).ecc_a, ((SM2)object2).ecc_b);
            fp = new ECParameterSpec((ECCurve)fp, ((SM2)object2).ecc_point_g, ((SM2)object2).ecc_n);
            if (hexSMPubkey.length() == 128) {
                hexSMPubkey = "04" + hexSMPubkey;
            }
            object = ((SM2)object2).ecc_curve.decodePoint(HexStringConvert.parseHexStr2Byte((String)object));
            object = new ECPublicKeySpec((ECPoint)object, (ECParameterSpec)fp);
            object2 = KeyFactory.getInstance("ECDSA", (Provider)new BouncyCastleProvider());
            object = ((KeyFactory)object2).generatePublic((KeySpec)object);
            return object;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public PrivateKey getPrivateKey(String hexSMPrikey) {
        try {
            Serializable serializable;
            Object object = SM2.Instance();
            ECCurve.Fp fp = new ECCurve.Fp(((SM2)object).ecc_p, ((SM2)object).ecc_a, ((SM2)object).ecc_b);
            object = new ECParameterSpec((ECCurve)fp, ((SM2)object).ecc_point_g, ((SM2)object).ecc_n);
            serializable = new BigInteger(1, HexStringConvert.parseHexStr2Byte((String)((Object)serializable)));
            serializable = new ECPrivateKeySpec(serializable, (ECParameterSpec)object);
            object = KeyFactory.getInstance("ECDSA", "BC");
            serializable = ((KeyFactory)object).generatePrivate((KeySpec)((Object)serializable));
            return serializable;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public static byte[] encrypt(byte[] publicKey, byte[] data) throws IOException {
        Object object;
        Object object2;
        if (publicKey == null || publicKey.length == 0) {
            return null;
        }
        if (data == null || data.length == 0) {
            return null;
        }
        byte[] byArray = new byte[data.length];
        System.arraycopy(data, 0, byArray, 0, ((void)object2).length);
        object2 = new Cipher();
        object = Util.hexToByte("04" + Util.byteToHex(object));
        Object object3 = SM2.Instance();
        object = ((SM2)object3).ecc_curve.decodePoint(object);
        object = ((Cipher)object2).Init_enc((SM2)object3, (ECPoint)object);
        ((Cipher)object2).Encrypt(byArray);
        object3 = new byte[32];
        ((Cipher)object2).Dofinal((byte[])object3);
        SM2UtilsC132No04.log("C1 " + Util.byteToHex(object.getEncoded(false)));
        SM2UtilsC132No04.log("C2 " + Util.byteToHex(byArray));
        SM2UtilsC132No04.log("C3 " + Util.byteToHex((byte[])object3));
        object2 = new StringBuilder();
        ((StringBuilder)object2).append(Util.byteToHex(object.getEncoded(false))).append(Util.byteToHex((byte[])object3)).append(Util.byteToHex(byArray));
        return Util.hexToByte(((StringBuilder)object2).toString().substring(2));
    }

    public static byte[] decrypt(byte[] privateKey, byte[] encryptedData) throws IOException {
        Object object;
        Object object2;
        if (privateKey == null || privateKey.length == 0) {
            return null;
        }
        if (encryptedData == null || encryptedData.length == 0) {
            return null;
        }
        object2 = Util.byteToHex((byte[])object2);
        object2 = "04" + (String)object2;
        Object object3 = Util.hexToByte(((String)object2).substring(0, 130));
        byte[] byArray = Util.hexToByte(((String)object2).substring(130, 194));
        object2 = Util.hexToByte(((String)object2).substring(194));
        Object object4 = SM2.Instance();
        object = new BigInteger(1, (byte[])object);
        object3 = ((SM2)object4).ecc_curve.decodePoint(object3);
        object4 = new Cipher();
        ((Cipher)object4).Init_dec((BigInteger)object, (ECPoint)object3);
        ((Cipher)object4).Decrypt((byte[])object2);
        ((Cipher)object4).Dofinal(byArray);
        return object2;
    }

    public static byte[] sign(byte[] userId, byte[] privateKey, byte[] sourceData) throws IOException {
        Object object;
        Object object2;
        Object object3;
        if (privateKey == null || privateKey.length == 0) {
            return null;
        }
        if (sourceData == null || sourceData.length == 0) {
            return null;
        }
        SM2 sM2 = SM2.Instance();
        object3 = new BigInteger((byte[])object3);
        SM2UtilsC132No04.log("userD: " + HexStringConvert.parseByte2HexStr(((BigInteger)object3).toByteArray()));
        SM2UtilsC132No04.log("");
        ECPoint eCPoint = sM2.ecc_point_g.multiply((BigInteger)object3);
        SM2UtilsC132No04.log("\u692d\u5706\u66f2\u7ebf\u70b9X: " + eCPoint.normalize().getXCoord().toBigInteger().toString(16));
        SM2UtilsC132No04.log("\u692d\u5706\u66f2\u7ebf\u70b9Y: " + eCPoint.normalize().getYCoord().toBigInteger().toString(16));
        SM2UtilsC132No04.log("");
        SM3Digest sM3Digest = new SM3Digest();
        object2 = sM2.sm2GetZ((byte[])object2, eCPoint);
        SM2UtilsC132No04.log("SM3\u6458\u8981Z: " + Util.getHexString((byte[])object2));
        SM2UtilsC132No04.log("");
        SM2UtilsC132No04.log("M: " + Util.getHexString(sourceData));
        SM2UtilsC132No04.log("");
        sM3Digest.update((byte[])object2, 0, ((byte[])object2).length);
        sM3Digest.update(sourceData, 0, ((void)object).length);
        object2 = new byte[32];
        sM3Digest.doFinal((byte[])object2, 0);
        SM2UtilsC132No04.log("SM3\u6458\u8981\u503c: " + Util.getHexString((byte[])object2));
        SM2UtilsC132No04.log("");
        object = new SM2Result();
        sM2.sm2Sign((byte[])object2, (BigInteger)object3, eCPoint, (SM2Result)object);
        object2 = HexStringConvert.parseByte2HexStr(((SM2Result)object).r.toByteArray());
        object3 = HexStringConvert.parseByte2HexStr(((SM2Result)object).s.toByteArray());
        SM2UtilsC132No04.log("r: " + (String)object2);
        SM2UtilsC132No04.log("s: " + (String)object3);
        SM2UtilsC132No04.log("");
        object = new StringBuilder();
        if (((String)object2).length() < 64) {
            for (int i2 = 0; i2 < 64 - -((String)object2).length(); ++i2) {
                ((StringBuilder)object).append("0");
            }
            ((StringBuilder)object).append((String)object2);
        } else {
            Object object4 = object2;
            ((StringBuilder)object).append(((String)object4).substring(((String)object4).length() - 64));
        }
        if (((String)object3).length() < 64) {
            for (int i3 = 0; i3 < 64 - ((String)object3).length(); ++i3) {
                ((StringBuilder)object).append("0");
            }
            ((StringBuilder)object).append((String)object3);
        } else {
            Object object5 = object3;
            ((StringBuilder)object).append(((String)object5).substring(((String)object5).length() - 64));
        }
        return HexStringConvert.parseHexStr2Byte(((StringBuilder)object).toString());
    }

    public static byte[] signHash(byte[] privateKey, byte[] sm3Hash) throws IOException {
        String string;
        Object object;
        if (privateKey == null || privateKey.length == 0) {
            return null;
        }
        if (sm3Hash == null || sm3Hash.length != 32) {
            return null;
        }
        SM2UtilsC132No04.log("SM3\u6458\u8981\u503c: " + Util.getHexString(sm3Hash));
        SM2UtilsC132No04.log("");
        Object object2 = SM2.Instance();
        object = new BigInteger((byte[])object);
        SM2UtilsC132No04.log("userD: " + HexStringConvert.parseByte2HexStr(((BigInteger)object).toByteArray()));
        SM2UtilsC132No04.log("");
        ECPoint eCPoint = ((SM2)object2).ecc_point_g.multiply((BigInteger)object);
        SM2Result sM2Result = new SM2Result();
        ((SM2)object2).sm2Sign((byte[])string, (BigInteger)object, eCPoint, sM2Result);
        object = HexStringConvert.parseByte2HexStr(sM2Result.r.toByteArray());
        string = HexStringConvert.parseByte2HexStr(sM2Result.s.toByteArray());
        SM2UtilsC132No04.log("r: " + (String)object);
        SM2UtilsC132No04.log("s: " + string);
        SM2UtilsC132No04.log("");
        object2 = new StringBuilder();
        if (((String)object).length() < 64) {
            for (int i2 = 0; i2 < ((String)object).length() - 64; ++i2) {
                ((StringBuilder)object2).append("0");
            }
            ((StringBuilder)object2).append((String)object);
        } else {
            Object object3 = object;
            ((StringBuilder)object2).append(((String)object3).substring(((String)object3).length() - 64));
        }
        if (string.length() < 64) {
            for (int i3 = 0; i3 < string.length() - 64; ++i3) {
                ((StringBuilder)object2).append("0");
            }
            ((StringBuilder)object2).append(string);
        } else {
            String string2 = string;
            ((StringBuilder)object2).append(string2.substring(string2.length() - 64));
        }
        return HexStringConvert.parseHexStr2Byte(((StringBuilder)object2).toString());
    }

    public static boolean verifySign(byte[] userId, byte[] publicKey, byte[] sourceData, byte[] signData) throws IOException {
        BigInteger bigInteger;
        Object object;
        byte[] byArray;
        Object object2;
        if (publicKey == null || publicKey.length == 0) {
            return false;
        }
        if (sourceData == null || sourceData.length == 0) {
            return false;
        }
        object2 = Util.hexToByte("04" + Util.byteToHex(object2));
        SM2 sM2 = SM2.Instance();
        object2 = sM2.ecc_curve.decodePoint(object2);
        Object object3 = new SM3Digest();
        byArray = sM2.sm2GetZ(byArray, (ECPoint)object2);
        ((SM3Digest)object3).update(byArray, 0, byArray.length);
        ((SM3Digest)object3).update(sourceData, 0, ((void)object).length);
        byArray = new byte[32];
        ((SM3Digest)object3).doFinal(byArray, 0);
        SM2UtilsC132No04.log("SM3\u6458\u8981\u503c: " + Util.getHexString(byArray));
        SM2UtilsC132No04.log("");
        object = HexStringConvert.parseByte2HexStr((byte[])bigInteger);
        bigInteger = new BigInteger(((String)object).substring(0, 64), 16);
        object = new BigInteger(((String)object).substring(64, 128), 16);
        object3 = new SM2Result();
        new SM2Result().r = bigInteger;
        ((SM2Result)object3).s = object;
        SM2UtilsC132No04.log("r: " + ((SM2Result)object3).r.toString(16));
        SM2UtilsC132No04.log("s: " + ((SM2Result)object3).s.toString(16));
        SM2UtilsC132No04.log("");
        sM2.sm2Verify(byArray, (ECPoint)object2, ((SM2Result)object3).r, ((SM2Result)object3).s, (SM2Result)object3);
        return ((SM2Result)object3).r.equals(((SM2Result)object3).R);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean verifySignHashNotZ(byte[] publicKey, byte[] sm3Hash, byte[] signData) throws IOException {
        void var1_1;
        Object object;
        Object object2;
        if (publicKey == null || publicKey.length == 0) {
            return false;
        }
        if (sm3Hash == null || sm3Hash.length == 0) {
            return false;
        }
        object2 = Util.hexToByte("04" + Util.byteToHex(object2));
        SM2 sM2 = SM2.Instance();
        object2 = sM2.ecc_curve.decodePoint(object2);
        SM2UtilsC132No04.log("SM3\u6458\u8981\u503c: " + Util.getHexString(sm3Hash));
        SM2UtilsC132No04.log("");
        object = HexStringConvert.parseByte2HexStr((byte[])object);
        BigInteger bigInteger = new BigInteger(((String)object).substring(0, 64), 16);
        object = new BigInteger(((String)object).substring(64, 128), 16);
        SM2Result sM2Result = new SM2Result();
        new SM2Result().r = bigInteger;
        sM2Result.s = object;
        SM2UtilsC132No04.log("r: " + sM2Result.r.toString(16));
        SM2UtilsC132No04.log("s: " + sM2Result.s.toString(16));
        SM2UtilsC132No04.log("");
        sM2.sm2Verify((byte[])var1_1, (ECPoint)object2, sM2Result.r, sM2Result.s, sM2Result);
        return sM2Result.r.equals(sM2Result.R);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean verifySigHashnAsn1(byte[] publicKey, byte[] sm3, byte[] asn1SignData) throws IOException {
        void var1_1;
        Object object;
        Object object2;
        object2 = Util.hexToByte("04" + Util.byteToHex(object2));
        SM2 sM2 = SM2.Instance();
        object2 = sM2.ecc_curve.decodePoint(object2);
        object = new ByteArrayInputStream((byte[])object);
        object = new ASN1InputStream((InputStream)object);
        object = object.readObject();
        object = ((ASN1Sequence)object).getObjects();
        BigInteger bigInteger = ((ASN1Integer)object.nextElement()).getValue();
        object = ((ASN1Integer)object.nextElement()).getValue();
        SM2Result sM2Result = new SM2Result();
        new SM2Result().r = bigInteger;
        sM2Result.s = object;
        SM2UtilsC132No04.log("r: " + sM2Result.r.toString(16));
        SM2UtilsC132No04.log("s: " + sM2Result.s.toString(16));
        SM2UtilsC132No04.log("");
        sM2.sm2Verify((byte[])var1_1, (ECPoint)object2, sM2Result.r, sM2Result.s, sM2Result);
        return sM2Result.r.equals(sM2Result.R);
    }

    private static void log(String message) {
    }

    public static void main(String[] args) throws Exception {
    }

    /*
     * WARNING - void declaration
     */
    private static boolean verify(PublicKey publicKey, byte[] source, byte[] sign) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        void var2_2;
        void var1_1;
        PublicKey publicKey2;
        Signature signature = Signature.getInstance("SM3WithSM2", (Provider)new BouncyCastleProvider());
        signature.initVerify(publicKey2);
        signature.update((byte[])var1_1);
        return signature.verify((byte[])var2_2);
    }

    public static byte[] rsAsn1ToPlainByteArray(byte[] rsDer) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)rsDer);
        Object object = aSN1Sequence;
        byte[] byArray = SM2UtilsC132No04.bigIntToFixexLengthBytes(ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(0)).getValue());
        object = SM2UtilsC132No04.bigIntToFixexLengthBytes(ASN1Integer.getInstance((Object)object.getObjectAt(1)).getValue());
        byte[] byArray2 = new byte[64];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        System.arraycopy(object, 0, byArray2, 32, ((byte[])object).length);
        return byArray2;
    }

    private static byte[] bigIntToFixexLengthBytes(BigInteger rOrS) {
        byte[] byArray = rOrS.toByteArray();
        Object object = byArray;
        if (byArray.length == 32) {
            return object;
        }
        if (((Object)object).length == 33 && object[0] == false) {
            return Arrays.copyOfRange((byte[])object, 1, 33);
        }
        if (((Object)object).length < 32) {
            byte[] byArray2 = new byte[32];
            Arrays.fill(byArray2, (byte)0);
            System.arraycopy(object, 0, byArray2, 32 - ((Object)object).length, ((Object)object).length);
            return byArray2;
        }
        throw new RuntimeException("err rs: " + Hex.toHexString((byte[])object));
    }

    public static byte[] rsPlainByteArrayToAsn1(byte[] sign) {
        Object object;
        if (sign.length != 64) {
            throw new RuntimeException("err rs. ");
        }
        BigInteger bigInteger = new BigInteger(1, Arrays.copyOfRange(sign, 0, 32));
        object = new BigInteger(1, Arrays.copyOfRange(object, 32, 64));
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(bigInteger));
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer((BigInteger)object));
        try {
            return new DERSequence(aSN1EncodableVector).getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String toHexPublicKey(ECPublicKey ecPublicKey) {
        return HexStringConvert.parseByte2HexStr(ecPublicKey.getQ().getEncoded(false)).substring(2);
    }

    public static final class SM2Keypair {
        public String pubKey;
        public String privKey;
    }
}

