/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.security.sm3;

import tech.simkey.dove.security.sm3.Util;

public class SM3 {
    public static final byte[] iv;
    public static int[] Tj;

    public static byte[] CF(byte[] V2, byte[] B2) {
        int[] nArray;
        Object[] objectArray = SM3.convert(V2);
        nArray = SM3.convert((byte[])nArray);
        return SM3.convert(SM3.CF((int[])objectArray, nArray));
    }

    private static int[] convert(byte[] arr) {
        int[] nArray = new int[arr.length / 4];
        byte[] byArray = new byte[4];
        for (int i2 = 0; i2 < arr.length; i2 += 4) {
            System.arraycopy(arr, i2, byArray, 0, 4);
            nArray[i2 / 4] = SM3.bigEndianByteToInt(byArray);
        }
        return nArray;
    }

    private static byte[] convert(int[] arr) {
        byte[] byArray = new byte[arr.length << 2];
        for (int i2 = 0; i2 < arr.length; ++i2) {
            byte[] byArray2 = SM3.bigEndianIntToByte(arr[i2]);
            System.arraycopy(byArray2, 0, byArray, i2 << 2, 4);
        }
        return byArray;
    }

    public static int[] CF(int[] V2, int[] B2) {
        int[] nArray;
        int[][] nArray2;
        int n2 = V2[0];
        int n3 = V2[1];
        int n4 = V2[2];
        int n5 = V2[3];
        int n6 = V2[4];
        int n7 = V2[5];
        int n8 = V2[6];
        int n9 = V2[7];
        nArray2 = SM3.expand((int[])nArray2);
        int[] nArray3 = nArray2[0];
        int[] nArray4 = nArray2[1];
        for (int i2 = 0; i2 < 64; ++i2) {
            int n10 = SM3.bitCycleLeft(n2, 12) + n6 + SM3.bitCycleLeft(Tj[i2], i2);
            n10 = SM3.bitCycleLeft(n10, 7);
            int n11 = n10 ^ SM3.bitCycleLeft(n2, 12);
            n11 = SM3.FFj(n2, n3, n4, i2) + n5 + n11 + nArray4[i2];
            n10 = SM3.GGj(n6, n7, n8, i2) + n9 + n10 + nArray3[i2];
            n5 = n4;
            n4 = SM3.bitCycleLeft(n3, 9);
            n3 = n2;
            n2 = n11;
            n9 = n8;
            n8 = SM3.bitCycleLeft(n7, 19);
            n7 = n6;
            n6 = SM3.P0(n10);
        }
        int[] nArray5 = new int[8];
        int[] nArray6 = nArray5;
        nArray5[0] = n2 ^ V2[0];
        nArray6[1] = n3 ^ V2[1];
        nArray6[2] = n4 ^ V2[2];
        nArray6[3] = n5 ^ V2[3];
        nArray6[4] = n6 ^ V2[4];
        nArray6[5] = n7 ^ V2[5];
        nArray6[6] = n8 ^ V2[6];
        nArray6[7] = n9 ^ nArray[7];
        return nArray6;
    }

    private static int[][] expand(int[] B2) {
        int n2;
        int[] nArray = new int[68];
        int[] nArray2 = new int[64];
        for (n2 = 0; n2 < B2.length; ++n2) {
            nArray[n2] = B2[n2];
        }
        for (n2 = 16; n2 < 68; ++n2) {
            nArray[n2] = SM3.P1(nArray[n2 - 16] ^ nArray[n2 - 9] ^ SM3.bitCycleLeft(nArray[n2 - 3], 15)) ^ SM3.bitCycleLeft(nArray[n2 - 13], 7) ^ nArray[n2 - 6];
        }
        for (n2 = 0; n2 < 64; ++n2) {
            nArray2[n2] = nArray[n2] ^ nArray[n2 + 4];
        }
        int[][] nArrayArray = new int[][]{nArray, nArray2};
        return nArrayArray;
    }

    private static byte[] bigEndianIntToByte(int num) {
        return SM3.back(Util.intToBytes(num));
    }

    private static int bigEndianByteToInt(byte[] bytes) {
        return Util.byteToInt(SM3.back(bytes));
    }

    /*
     * WARNING - void declaration
     */
    private static int FFj(int X2, int Y2, int Z2, int j2) {
        void var2_2;
        void var1_1;
        int n2;
        void var3_3;
        if (j2 >= 0 && var3_3 <= 15) {
            return SM3.FF1j(X2, Y2, Z2);
        }
        return SM3.FF2j(n2, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static int GGj(int X2, int Y2, int Z2, int j2) {
        void var2_2;
        void var1_1;
        int n2;
        void var3_3;
        if (j2 >= 0 && var3_3 <= 15) {
            return SM3.GG1j(X2, Y2, Z2);
        }
        return SM3.GG2j(n2, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static int FF1j(int X2, int Y2, int Z2) {
        void var2_2;
        void var1_1;
        int n2 = X2 ^ var1_1 ^ var2_2;
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    private static int FF2j(int X2, int Y2, int Z2) {
        void var2_2;
        void var1_1;
        int n2;
        n2 = X2 & Y2 | n2 & Z2 | var1_1 & var2_2;
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    private static int GG1j(int X2, int Y2, int Z2) {
        void var2_2;
        void var1_1;
        int n2 = X2 ^ var1_1 ^ var2_2;
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    private static int GG2j(int X2, int Y2, int Z2) {
        void var2_2;
        int n2;
        void var1_1;
        n2 = X2 & var1_1 | ~n2 & var2_2;
        return n2;
    }

    private static int P0(int X2) {
        int n2;
        SM3.rotateLeft(X2, 9);
        int n3 = SM3.bitCycleLeft(X2, 9);
        SM3.rotateLeft(X2, 17);
        int n4 = SM3.bitCycleLeft(X2, 17);
        n2 = n2 ^ n3 ^ n4;
        return n2;
    }

    private static int P1(int X2) {
        int n2;
        int n3 = X2;
        n2 = n3 ^ SM3.bitCycleLeft(n3, 15) ^ SM3.bitCycleLeft(n2, 23);
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] padding(byte[] in, int bLen) {
        byte[] byArray;
        void var1_2;
        int n2 = 448 - (8 * in.length + 1) % 512;
        if (n2 < 0) {
            n2 = 960 - (8 * in.length + 1) % 512;
        }
        byte[] byArray2 = new byte[++n2 / 8];
        byte[] byArray3 = byArray2;
        byArray2[0] = -128;
        long l2 = (in.length << 3) + (var1_2 << 9);
        byte[] byArray4 = new byte[in.length + n2 / 8 + 8];
        System.arraycopy(in, 0, byArray4, 0, in.length);
        int n3 = 0 + byArray.length;
        System.arraycopy(byArray3, 0, byArray4, n3, byArray3.length);
        byte[] byArray5 = SM3.back(Util.longToBytes(l2));
        System.arraycopy(byArray5, 0, byArray4, n3 += byArray3.length, byArray5.length);
        return byArray4;
    }

    private static byte[] back(byte[] in) {
        byte[] byArray = new byte[in.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = in[byArray.length - i2 - 1];
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public static int rotateLeft(int x2, int n2) {
        void var1_1;
        int n3;
        return x2 << n2 | n3 >> 32 - var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int bitCycleLeft(int n2, int bitLen) {
        void var1_2;
        int n3;
        byte[] byArray = SM3.bigEndianIntToByte(n3);
        int n4 = (bitLen %= 32) / 8;
        var1_2 %= 8;
        if (n4 > 0) {
            byArray = SM3.byteCycleLeft(byArray, n4);
        }
        if (var1_2 > 0) {
            byArray = SM3.bitSmall8CycleLeft(byArray, (int)var1_2);
        }
        return SM3.bigEndianByteToInt(byArray);
    }

    private static byte[] bitSmall8CycleLeft(byte[] in, int len) {
        byte[] byArray = new byte[in.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by = (byte)((in[i2] & 0xFF) << len);
            byte by2 = (byte)((in[(i2 + 1) % byArray.length] & 0xFF) >> 8 - len);
            by = (byte)(by | by2);
            byArray[i2] = by;
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] byteCycleLeft(byte[] in, int byteLen) {
        void var1_1;
        byte[] byArray;
        byte[] byArray2 = new byte[in.length];
        System.arraycopy(in, byteLen, byArray2, 0, in.length - byteLen);
        System.arraycopy(in, 0, byArray2, byArray.length - byteLen, (int)var1_1);
        return byArray2;
    }

    static {
        int n2;
        iv = new byte[]{115, -128, 22, 111, 73, 20, -78, -71, 23, 36, 66, -41, -38, -118, 6, 0, -87, 111, 48, -68, 22, 49, 56, -86, -29, -115, -18, 77, -80, -5, 14, 78};
        Tj = new int[64];
        for (n2 = 0; n2 < 16; ++n2) {
            SM3.Tj[n2] = 2043430169;
        }
        for (n2 = 16; n2 < 64; ++n2) {
            SM3.Tj[n2] = 2055708042;
        }
    }
}

