/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.security.sm3;

import tech.simkey.dove.security.HexStringConvert;
import tech.simkey.dove.security.sm3.SM3;

public class SM3Digest {
    private static final int BYTE_LENGTH = 32;
    private static final int BLOCK_LENGTH = 64;
    private static final int BUFFER_LENGTH = 64;
    private byte[] xBuf = new byte[64];
    private int xBufOff;
    private byte[] V = (byte[])SM3.iv.clone();
    private int cntBlock = 0;

    public SM3Digest() {
    }

    /*
     * WARNING - void declaration
     */
    public SM3Digest(SM3Digest t2) {
        void var1_1;
        System.arraycopy(t2.xBuf, 0, this.xBuf, 0, t2.xBuf.length);
        this.xBufOff = t2.xBufOff;
        System.arraycopy(t2.V, 0, this.V, 0, var1_1.V.length);
    }

    /*
     * WARNING - void declaration
     */
    public int doFinal(byte[] out, int outOff) {
        void var2_2;
        void var1_1;
        byte[] byArray = this.doFinal();
        System.arraycopy(byArray, 0, var1_1, (int)var2_2, byArray.length);
        return 32;
    }

    public void reset() {
        this.xBufOff = 0;
        this.cntBlock = 0;
        this.V = (byte[])SM3.iv.clone();
    }

    /*
     * WARNING - void declaration
     */
    public void update(byte[] in, int inOff, int len) {
        void var1_1;
        int n2 = 64 - this.xBufOff;
        int n3 = len;
        int n4 = inOff;
        if (n2 < len) {
            void var2_2;
            void var3_3;
            System.arraycopy(in, inOff, this.xBuf, this.xBufOff, n2);
            n3 = var3_3 - n2;
            n4 = var2_2 + n2;
            this.doUpdate();
            while (n3 > 64) {
                System.arraycopy(in, n4, this.xBuf, 0, 64);
                n3 -= 64;
                n4 += 64;
                this.doUpdate();
            }
        }
        System.arraycopy(var1_1, n4, this.xBuf, this.xBufOff, n3);
        this.xBufOff += n3;
    }

    private void doUpdate() {
        byte[] byArray = new byte[64];
        for (int i2 = 0; i2 < 64; i2 += 64) {
            System.arraycopy(this.xBuf, 0, byArray, 0, byArray.length);
            this.doHash(byArray);
        }
        this.xBufOff = 0;
    }

    private void doHash(byte[] B2) {
        byte[] byArray;
        byArray = SM3.CF(this.V, byArray);
        System.arraycopy(byArray, 0, this.V, 0, this.V.length);
        ++this.cntBlock;
    }

    private byte[] doFinal() {
        byte[] byArray = new byte[64];
        byte[] byArray2 = new byte[this.xBufOff];
        System.arraycopy(this.xBuf, 0, byArray2, 0, byArray2.length);
        byArray2 = SM3.padding(byArray2, this.cntBlock);
        for (int i2 = 0; i2 < byArray2.length; i2 += 64) {
            System.arraycopy(byArray2, i2, byArray, 0, byArray.length);
            this.doHash(byArray);
        }
        return this.V;
    }

    /*
     * WARNING - void declaration
     */
    public void update(byte in) {
        void var1_1;
        byte[] byArray = new byte[]{var1_1};
        this.update(byArray, 0, 1);
    }

    public int getDigestSize() {
        return 32;
    }

    public static byte[] hash(byte[] data) {
        byte[] byArray;
        byte[] byArray2 = new byte[32];
        SM3Digest sM3Digest = new SM3Digest();
        sM3Digest.update(byArray, 0, byArray.length);
        sM3Digest.doFinal(byArray2, 0);
        return byArray2;
    }

    public static void main(String[] args) {
        Object object = "616263";
        object = SM3Digest.hash(HexStringConvert.parseHexStr2Byte("616263"));
        System.out.println(HexStringConvert.parseByte2HexStr((byte[])object));
    }
}

