/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.security.sm3;

import java.math.BigInteger;
import tech.simkey.dove.log.CLog;

public class Util {
    private static final String TAG = "Util";
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static byte[] intToBytes(int num) {
        int n2;
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)(0xFF & num);
        byArray2[1] = (byte)(0xFF & num >> 8);
        byArray2[2] = (byte)(0xFF & num >> 16);
        byArray2[3] = (byte)(0xFF & n2 >> 24);
        return byArray2;
    }

    public static int byteToInt(byte[] bytes) {
        byte[] byArray;
        int n2 = 0xFF & bytes[0];
        int n3 = 0 | n2;
        n2 = (0xFF & bytes[1]) << 8;
        n3 |= n2;
        n2 = (0xFF & bytes[2]) << 16;
        n3 |= n2;
        n2 = (0xFF & byArray[3]) << 24;
        return n3 |= n2;
    }

    public static byte[] longToBytes(long num) {
        byte[] byArray = new byte[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            byArray[i2] = (byte)(0xFFL & num >> (i2 << 3));
        }
        return byArray;
    }

    public static byte[] byteConvert32Bytes(BigInteger n2) {
        byte[] byArray;
        if (n2 == null) {
            return null;
        }
        if (n2.toByteArray().length == 33) {
            byArray = new byte[32];
            System.arraycopy(n2.toByteArray(), 1, byArray, 0, 32);
        } else if (n2.toByteArray().length == 32) {
            byArray = n2.toByteArray();
        } else {
            BigInteger bigInteger;
            byArray = new byte[32];
            for (int i2 = 0; i2 < 32 - n2.toByteArray().length; ++i2) {
                byArray[i2] = 0;
            }
            System.arraycopy(n2.toByteArray(), 0, byArray, 32 - n2.toByteArray().length, bigInteger.toByteArray().length);
        }
        return byArray;
    }

    public static BigInteger byteConvertInteger(byte[] b2) {
        byte[] byArray;
        if (b2[0] < 0) {
            byte[] byArray2 = new byte[b2.length + 1];
            byte[] byArray3 = byArray2;
            byArray2[0] = 0;
            System.arraycopy(b2, 0, byArray3, 1, b2.length);
            return new BigInteger(byArray3);
        }
        return new BigInteger(byArray);
    }

    public static String getHexString(byte[] bytes) {
        return Util.getHexString(bytes, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String getHexString(byte[] bytes, boolean upperCase) {
        void var1_1;
        String string = "";
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            string = string + Integer.toString((bytes[i2] & 0xFF) + 256, 16).substring(1);
        }
        if (var1_1 != false) {
            return string.toUpperCase();
        }
        return string;
    }

    public static void printHexString(byte[] bytes) {
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            String string = Integer.toHexString(bytes[i2] & 0xFF);
            if (string.length() == 1) {
                string = "0" + string;
            }
            CLog.d(TAG, "0x" + string.toUpperCase() + ",");
        }
    }

    public static byte[] hexStringToBytes(String hexString) {
        Object object;
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int n2 = hexString.length() / 2;
        object = ((String)object).toCharArray();
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2 << 1;
            byArray[i2] = (byte)(Util.charToByte((char)object[n3]) << 4 | Util.charToByte((char)object[n3 + 1]));
        }
        return byArray;
    }

    public static byte charToByte(char c2) {
        char c3;
        return (byte)"0123456789ABCDEF".indexOf(c3);
    }

    public static char[] encodeHex(byte[] data) {
        return Util.encodeHex(data, true);
    }

    /*
     * WARNING - void declaration
     */
    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        void var1_1;
        return Util.encodeHex(data, var1_1 != false ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int n2 = data.length;
        char[] cArray = new char[n2 << 1];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[n3++] = toDigits[(0xF0 & data[i2]) >>> 4];
            cArray[n3++] = toDigits[0xF & data[i2]];
        }
        return cArray;
    }

    public static String encodeHexString(byte[] data) {
        return Util.encodeHexString(data, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String encodeHexString(byte[] data, boolean toLowerCase) {
        void var1_1;
        return Util.encodeHexString(data, var1_1 != false ? DIGITS_LOWER : DIGITS_UPPER);
    }

    /*
     * WARNING - void declaration
     */
    protected static String encodeHexString(byte[] data, char[] toDigits) {
        void var1_1;
        byte[] byArray;
        return new String(Util.encodeHex(byArray, (char[])var1_1));
    }

    public static byte[] decodeHex(char[] data) {
        int n2 = data.length;
        if ((n2 & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] byArray = new byte[n2 >> 1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = Util.toDigit(data[n4], n4) << 4;
            n5 |= Util.toDigit(data[++n4], n4);
            ++n4;
            byArray[n3] = (byte)n5;
            ++n3;
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    protected static int toDigit(char ch, int index) {
        int n2 = Character.digit(ch, 16);
        if (n2 == -1) {
            void var1_1;
            char c2;
            throw new RuntimeException("Illegal hexadecimal character " + c2 + " at index " + (int)var1_1);
        }
        return n2;
    }

    public static String StringToAsciiString(String content) {
        String string = "";
        int n2 = content.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = content.charAt(i2);
            String string2 = Integer.toHexString(c2);
            string = string + string2;
        }
        return string;
    }

    public static String hexStringToString(String hexString, int encodeType) {
        String string = "";
        int n2 = hexString.length() / encodeType;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = (char)Util.hexStringToAlgorism(hexString.substring(i2 * encodeType, (i2 + 1) * encodeType));
            string = string + c2;
        }
        return string;
    }

    public static int hexStringToAlgorism(String hex) {
        hex = hex.toUpperCase();
        int n2 = hex.length();
        int n3 = 0;
        for (int i2 = n2; i2 > 0; --i2) {
            int n4 = hex.charAt(i2 - 1);
            n4 = n4 >= 48 && n4 <= 57 ? (n4 -= 48) : (n4 -= 55);
            n3 = (int)((double)n3 + Math.pow(16.0, n2 - i2) * (double)n4);
        }
        return n3;
    }

    public static String hexStringToBinary(String hex) {
        hex = hex.toUpperCase();
        String string = "";
        int n2 = hex.length();
        block18: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = hex.charAt(i2);
            switch (c2) {
                case '0': {
                    string = string + "0000";
                    continue block18;
                }
                case '1': {
                    string = string + "0001";
                    continue block18;
                }
                case '2': {
                    string = string + "0010";
                    continue block18;
                }
                case '3': {
                    string = string + "0011";
                    continue block18;
                }
                case '4': {
                    string = string + "0100";
                    continue block18;
                }
                case '5': {
                    string = string + "0101";
                    continue block18;
                }
                case '6': {
                    string = string + "0110";
                    continue block18;
                }
                case '7': {
                    string = string + "0111";
                    continue block18;
                }
                case '8': {
                    string = string + "1000";
                    continue block18;
                }
                case '9': {
                    string = string + "1001";
                    continue block18;
                }
                case 'A': {
                    string = string + "1010";
                    continue block18;
                }
                case 'B': {
                    string = string + "1011";
                    continue block18;
                }
                case 'C': {
                    string = string + "1100";
                    continue block18;
                }
                case 'D': {
                    string = string + "1101";
                    continue block18;
                }
                case 'E': {
                    string = string + "1110";
                    continue block18;
                }
                case 'F': {
                    string = string + "1111";
                }
            }
        }
        return string;
    }

    public static String AsciiStringToString(String content) {
        String string = "";
        int n2 = content.length() / 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = content.substring(i2 << 1, (i2 << 1) + 2);
            int n3 = Util.hexStringToAlgorism(string2);
            char c2 = (char)n3;
            n3 = c2;
            string2 = String.valueOf(c2);
            string = string + string2;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String algorismToHexString(int algorism, int maxLength) {
        void var1_2;
        String string = Integer.toHexString(algorism);
        if (string.length() % 2 == 1) {
            string = "0" + string;
        }
        return Util.patchHexString(string.toUpperCase(), (int)var1_2);
    }

    public static String byteToString(byte[] bytearray) {
        String string = "";
        int n2 = bytearray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = (char)bytearray[i2];
            string = string + c2;
        }
        return string;
    }

    public static int binaryToAlgorism(String binary) {
        int n2 = binary.length();
        int n3 = 0;
        for (int i2 = n2; i2 > 0; --i2) {
            int n4 = binary.charAt(i2 - 1);
            n3 = (int)((double)n3 + Math.pow(2.0, n2 - i2) * (double)(n4 -= 48));
        }
        return n3;
    }

    public static String algorismToHEXString(int algorism) {
        String string = Integer.toHexString(algorism);
        if (string.length() % 2 == 1) {
            string = "0" + string;
        }
        string = string.toUpperCase();
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String patchHexString(String str, int maxLength) {
        void var1_1;
        String string;
        String string2 = "";
        for (int i2 = 0; i2 < maxLength - str.length(); ++i2) {
            string2 = "0" + string2;
        }
        string = (string2 + string).substring(0, (int)var1_1);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static int parseToInt(String s2, int defaultInt, int radix) {
        int n2;
        try {
            void var2_3;
            n2 = Integer.parseInt(s2, (int)var2_3);
        }
        catch (NumberFormatException numberFormatException) {
            void var1_2;
            n2 = var1_2;
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public static int parseToInt(String s2, int defaultInt) {
        int n2;
        try {
            n2 = Integer.parseInt(s2);
        }
        catch (NumberFormatException numberFormatException) {
            void var1_2;
            n2 = var1_2;
        }
        return n2;
    }

    public static byte[] hexToByte(String hex) throws IllegalArgumentException {
        String string;
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        char[] cArray = hex.toCharArray();
        byte[] byArray = new byte[hex.length() / 2];
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        while (n2 < n4) {
            String string2 = "" + cArray[n2++] + cArray[n2];
            int n5 = Integer.parseInt(string2, 16) & 0xFF;
            byArray[n3] = (byte)n5;
            ++n2;
            ++n3;
        }
        return byArray;
    }

    public static String byteToHex(byte[] b2) {
        if (b2 == null) {
            throw new IllegalArgumentException("Argument b ( byte array ) is null! ");
        }
        String string = "";
        for (int i2 = 0; i2 < b2.length; ++i2) {
            String string2 = Integer.toHexString(b2[i2] & 0xFF);
            string = string2.length() == 1 ? string + "0" + string2 : string + string2;
        }
        return string.toUpperCase();
    }

    public static byte[] subByte(byte[] input, int startIndex, int length) {
        byte[] byArray = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            byArray[i2] = input[i2 + startIndex];
        }
        return byArray;
    }
}

