/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.security.sm4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import tech.simkey.dove.security.sm4.SM4Context;

public class SM4 {
    public static final int SM4_ENCRYPT = 1;
    public static final int SM4_DECRYPT = 0;
    public static final byte[] SboxTable = new byte[]{-42, -112, -23, -2, -52, -31, 61, -73, 22, -74, 20, -62, 40, -5, 44, 5, 43, 103, -102, 118, 42, -66, 4, -61, -86, 68, 19, 38, 73, -122, 6, -103, -100, 66, 80, -12, -111, -17, -104, 122, 51, 84, 11, 67, -19, -49, -84, 98, -28, -77, 28, -87, -55, 8, -24, -107, -128, -33, -108, -6, 117, -113, 63, -90, 71, 7, -89, -4, -13, 115, 23, -70, -125, 89, 60, 25, -26, -123, 79, -88, 104, 107, -127, -78, 113, 100, -38, -117, -8, -21, 15, 75, 112, 86, -99, 53, 30, 36, 14, 94, 99, 88, -47, -94, 37, 34, 124, 59, 1, 33, 120, -121, -44, 0, 70, 87, -97, -45, 39, 82, 76, 54, 2, -25, -96, -60, -56, -98, -22, -65, -118, -46, 64, -57, 56, -75, -93, -9, -14, -50, -7, 97, 21, -95, -32, -82, 93, -92, -101, 52, 26, 85, -83, -109, 50, 48, -11, -116, -79, -29, 29, -10, -30, 46, -126, 102, -54, 96, -64, 41, 35, -85, 13, 83, 78, 111, -43, -37, 55, 69, -34, -3, -114, 47, 3, -1, 106, 114, 109, 108, 91, 81, -115, 27, -81, -110, -69, -35, -68, 127, 17, -39, 92, 65, 31, 16, 90, -40, 10, -63, 49, -120, -91, -51, 123, -67, 45, 116, -48, 18, -72, -27, -76, -80, -119, 105, -105, 74, 12, -106, 119, 126, 101, -71, -15, 9, -59, 110, -58, -124, 24, -16, 125, -20, 58, -36, 77, 32, 121, -18, 95, 62, -41, -53, 57, 72};
    public static final int[] FK = new int[]{-1548633402, 1453994832, 1736282519, -1301273892};
    public static final int[] CK = new int[]{462357, 472066609, 943670861, 1415275113, 1886879365, -1936483679, -1464879427, -993275175, -521670923, -66909679, 404694573, 876298825, 1347903077, 1819507329, -2003855715, -1532251463, -1060647211, -589042959, -117504499, 337322537, 808926789, 1280531041, 1752135293, -2071227751, -1599623499, -1128019247, -656414995, -184876535, 269950501, 741554753, 1213159005, 1684763257};

    /*
     * WARNING - void declaration
     */
    private long GET_ULONG_BE(byte[] b2, int i2) {
        void var2_2;
        void var1_1;
        long l2 = (long)(b2[i2] & 0xFF) << 24 | (long)((b2[i2 + 1] & 0xFF) << 16) | (long)((b2[i2 + 2] & 0xFF) << 8) | (long)(var1_1[var2_2 + 3] & 0xFF) & 0xFFFFFFFFL;
        return l2;
    }

    /*
     * WARNING - void declaration
     */
    private void PUT_ULONG_BE(long n2, byte[] b2, int i2) {
        void var1_1;
        b2[i2] = (byte)(0xFFL & n2 >> 24);
        b2[i2 + 1] = (byte)(0xFFL & n2 >> 16);
        b2[i2 + 2] = (byte)(0xFFL & n2 >> 8);
        var3_2[i2 + 3] = (byte)(0xFFL & var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private long SHL(long x2, int n2) {
        void var3_2;
        return x2 << var3_2;
    }

    /*
     * WARNING - void declaration
     */
    private long ROTL(long x2, int n2) {
        void var3_2;
        void var1_1;
        return this.SHL(x2, n2) | var1_1 >> 32 - var3_2;
    }

    private void SWAP(long[] sk, int i2) {
        long l2 = sk[i2];
        sk[i2] = sk[31 - i2];
        var1_1[31 - var2_2] = l2;
    }

    private byte sm4Sbox(byte inch) {
        int n2 = inch & 0xFF;
        byte by = SboxTable[n2];
        return by;
    }

    /*
     * WARNING - void declaration
     */
    private long sm4Lt(long ka) {
        void var1_1;
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[4];
        this.PUT_ULONG_BE((long)var1_1, byArray, 0);
        byArray2[0] = this.sm4Sbox(byArray[0]);
        byArray2[1] = this.sm4Sbox(byArray[1]);
        byArray2[2] = this.sm4Sbox(byArray[2]);
        byArray2[3] = this.sm4Sbox(byArray[3]);
        long l2 = this.GET_ULONG_BE(byArray2, 0);
        long l3 = l2 ^ this.ROTL(l2, 2) ^ this.ROTL(l2, 10) ^ this.ROTL(l2, 18) ^ this.ROTL(l2, 24);
        return l3;
    }

    /*
     * WARNING - void declaration
     */
    private long sm4F(long x0, long x1, long x2, long x3, long rk) {
        void var3_3;
        return x0 ^ this.sm4Lt((long)(var3_3 ^ x2 ^ x3 ^ rk));
    }

    /*
     * WARNING - void declaration
     */
    private long sm4CalciRK(long ka) {
        void var1_1;
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[4];
        this.PUT_ULONG_BE((long)var1_1, byArray, 0);
        byArray2[0] = this.sm4Sbox(byArray[0]);
        byArray2[1] = this.sm4Sbox(byArray[1]);
        byArray2[2] = this.sm4Sbox(byArray[2]);
        byArray2[3] = this.sm4Sbox(byArray[3]);
        long l2 = this.GET_ULONG_BE(byArray2, 0);
        long l3 = l2 ^ this.ROTL(l2, 13) ^ this.ROTL(l2, 23);
        return l3;
    }

    /*
     * WARNING - void declaration
     */
    private void sm4_setkey(long[] SK, byte[] key) {
        void var2_2;
        long[] lArray = new long[4];
        long[] lArray2 = new long[36];
        lArray[0] = this.GET_ULONG_BE(key, 0);
        lArray[1] = this.GET_ULONG_BE(key, 4);
        lArray[2] = this.GET_ULONG_BE(key, 8);
        lArray[3] = this.GET_ULONG_BE((byte[])var2_2, 12);
        lArray2[0] = lArray[0] ^ (long)FK[0];
        lArray2[1] = lArray[1] ^ (long)FK[1];
        lArray2[2] = lArray[2] ^ (long)FK[2];
        lArray2[3] = lArray[3] ^ (long)FK[3];
        for (int i2 = 0; i2 < 32; ++i2) {
            lArray2[i2 + 4] = lArray2[i2] ^ this.sm4CalciRK(lArray2[i2 + 1] ^ lArray2[i2 + 2] ^ lArray2[i2 + 3] ^ (long)CK[i2]);
            SK[i2] = lArray2[i2 + 4];
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sm4_one_round(long[] sk, byte[] input, byte[] output) {
        void var3_3;
        void var2_2;
        long[] lArray = new long[36];
        long[] lArray2 = lArray;
        lArray[0] = this.GET_ULONG_BE(input, 0);
        lArray2[1] = this.GET_ULONG_BE(input, 4);
        lArray2[2] = this.GET_ULONG_BE(input, 8);
        lArray2[3] = this.GET_ULONG_BE((byte[])var2_2, 12);
        for (int i2 = 0; i2 < 32; ++i2) {
            lArray2[i2 + 4] = this.sm4F(lArray2[i2], lArray2[i2 + 1], lArray2[i2 + 2], lArray2[i2 + 3], sk[i2]);
        }
        this.PUT_ULONG_BE(lArray2[35], output, 0);
        this.PUT_ULONG_BE(lArray2[34], output, 4);
        this.PUT_ULONG_BE(lArray2[33], output, 8);
        this.PUT_ULONG_BE(lArray2[32], (byte[])var3_3, 12);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] padding(byte[] input, int mode) {
        byte[] byArray;
        void var2_2;
        if (input == null) {
            return null;
        }
        if (var2_2 == true) {
            int n2 = 16 - input.length % 16;
            byArray = new byte[input.length + n2];
            System.arraycopy(input, 0, byArray, 0, input.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray[input.length + i2] = (byte)n2;
            }
        } else {
            void var1_1;
            byte by = input[input.length - 1];
            byArray = new byte[input.length - by];
            System.arraycopy(input, 0, byArray, 0, ((void)var1_1).length - by);
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public void sm4_setkey_enc(SM4Context ctx, byte[] key) throws Exception {
        void var2_2;
        void var1_1;
        if (ctx == null) {
            throw new Exception("ctx is null!");
        }
        if (key == null || key.length != 16) {
            throw new Exception("key error!");
        }
        ctx.mode = 1;
        this.sm4_setkey(var1_1.sk, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void sm4_setkey_dec(SM4Context ctx, byte[] key) throws Exception {
        void var2_2;
        if (ctx == null) {
            throw new Exception("ctx is null!");
        }
        if (key == null || key.length != 16) {
            throw new Exception("key error!");
        }
        ctx.mode = 0;
        this.sm4_setkey(ctx.sk, (byte[])var2_2);
        for (int i2 = 0; i2 < 16; ++i2) {
            this.SWAP(ctx.sk, i2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] sm4_crypt_ecb(SM4Context ctx, byte[] input) throws Exception {
        void var1_1;
        byte[] byArray;
        ByteArrayInputStream byteArrayInputStream;
        if (input == null) {
            throw new Exception("input is null!");
        }
        if (ctx.isPadding && ctx.mode == 1) {
            input = this.padding(input, 1);
        }
        byteArrayInputStream = new ByteArrayInputStream((byte[])byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = input.length; i2 > 0; i2 -= 16) {
            byArray = new byte[16];
            byte[] byArray2 = new byte[16];
            byteArrayInputStream.read(byArray);
            this.sm4_one_round(ctx.sk, byArray, byArray2);
            byteArrayOutputStream.write(byArray2);
        }
        byArray = byteArrayOutputStream.toByteArray();
        if (ctx.isPadding && var1_1.mode == 0) {
            byArray = this.padding(byArray, 0);
        }
        byteArrayInputStream.close();
        byteArrayOutputStream.close();
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] sm4_crypt_cbc(SM4Context ctx, byte[] iv, byte[] input) throws Exception {
        void var1_1;
        byte[] byArray;
        int n2;
        void var3_3;
        if (iv == null || iv.length != 16) {
            throw new Exception("iv error!");
        }
        if (input == null) {
            throw new Exception("input is null!");
        }
        if (ctx.isPadding && ctx.mode == 1) {
            input = this.padding(input, 1);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])var3_3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (ctx.mode == 1) {
            for (n2 = input.length; n2 > 0; n2 -= 16) {
                byArray = new byte[16];
                byte[] byArray2 = new byte[16];
                byte[] byArray3 = new byte[16];
                byteArrayInputStream.read(byArray);
                for (int i2 = 0; i2 < 16; ++i2) {
                    byArray2[i2] = (byte)(byArray[i2] ^ iv[i2]);
                }
                this.sm4_one_round(ctx.sk, byArray2, byArray3);
                System.arraycopy(byArray3, 0, iv, 0, 16);
                byteArrayOutputStream.write(byArray3);
            }
        } else {
            byArray = new byte[16];
            while (n2 > 0) {
                byte[] byArray4 = new byte[16];
                byte[] byArray5 = new byte[16];
                byte[] byArray6 = new byte[16];
                byteArrayInputStream.read(byArray4);
                System.arraycopy(byArray4, 0, byArray, 0, 16);
                this.sm4_one_round(ctx.sk, byArray4, byArray5);
                for (int i3 = 0; i3 < 16; ++i3) {
                    byArray6[i3] = (byte)(byArray5[i3] ^ iv[i3]);
                }
                System.arraycopy(byArray, 0, iv, 0, 16);
                byteArrayOutputStream.write(byArray6);
                n2 -= 16;
            }
        }
        byArray = byteArrayOutputStream.toByteArray();
        if (ctx.isPadding && var1_1.mode == 0) {
            byArray = this.padding(byArray, 0);
        }
        byteArrayInputStream.close();
        byteArrayOutputStream.close();
        return byArray;
    }
}

