/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.security.sm4;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tech.simkey.dove.encoding.BASE64Decoder;
import tech.simkey.dove.encoding.BASE64Encoder;
import tech.simkey.dove.encoding.Base64NoCR;
import tech.simkey.dove.security.HashUtil;
import tech.simkey.dove.security.HexStringConvert;
import tech.simkey.dove.security.sm4.SM4;
import tech.simkey.dove.security.sm4.SM4Context;
import tech.simkey.dove.util.SecureRandomSingleton;

public class SM4Util {
    private static final String ENCODING = "UTF-8";
    private static final String CBC_IV = "92F326B9F1DDB7F55BB29460E4AD27DA";

    /*
     * WARNING - void declaration
     */
    public static String encryptECBHexStrHexStr(String hexData, String hexKey) {
        void var1_1;
        byte[] byArray = HexStringConvert.parseHexStr2Byte(hexData);
        Object object = byArray;
        byte[] byArray2 = SM4Util.encryptData_ECB(byArray, (String)var1_1);
        object = byArray2;
        if (byArray2 == null) {
            return "";
        }
        return HexStringConvert.parseByte2HexStr((byte[])object);
    }

    public static byte[] encryptData_ECB(byte[] data, String hexKey) {
        try {
            byte[] byArray;
            byte[] byArray2;
            SM4Context sM4Context = new SM4Context();
            new SM4Context().isPadding = true;
            sM4Context.mode = 1;
            byArray2 = HexStringConvert.parseHexStr2Byte((String)byArray2);
            SM4 sM4 = new SM4();
            sM4.sm4_setkey_enc(sM4Context, byArray2);
            byArray = sM4.sm4_crypt_ecb(sM4Context, byArray);
            return byArray;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] encryptData_ECB(byte[] data, String hexKey, boolean isPadding) {
        try {
            byte[] byArray;
            byte[] byArray2;
            void var2_2;
            SM4Context sM4Context = new SM4Context();
            new SM4Context().isPadding = var2_2;
            sM4Context.mode = 1;
            byArray2 = HexStringConvert.parseHexStr2Byte((String)byArray2);
            SM4 sM4 = new SM4();
            sM4.sm4_setkey_enc(sM4Context, byArray2);
            byArray = sM4.sm4_crypt_ecb(sM4Context, byArray);
            return byArray;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String decryptECBHexStr(String hexData, String hexKey) {
        void var1_1;
        byte[] byArray = HexStringConvert.parseHexStr2Byte(hexData);
        Object object = byArray;
        byte[] byArray2 = SM4Util.decryptData_ECB(byArray, (String)var1_1);
        object = byArray2;
        if (byArray2 == null) {
            return "";
        }
        return HexStringConvert.parseByte2HexStr((byte[])object);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decryptData_ECB(byte[] data, String hexKey) {
        void var1_1;
        return SM4Util.decryptData_ECB(data, (String)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decryptData_ECB(byte[] data, String hexKey, boolean isPadding) {
        try {
            byte[] byArray;
            byte[] byArray2;
            void var2_2;
            SM4Context sM4Context = new SM4Context();
            new SM4Context().isPadding = var2_2;
            sM4Context.mode = 0;
            byArray2 = HexStringConvert.parseHexStr2Byte((String)byArray2);
            SM4 sM4 = new SM4();
            sM4.sm4_setkey_dec(sM4Context, byArray2);
            byArray = sM4.sm4_crypt_ecb(sM4Context, byArray);
            return byArray;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public static String encryptData_CBC(String plainText, String key) {
        try {
            Object object;
            Object object2;
            SM4Context sM4Context = new SM4Context();
            new SM4Context().isPadding = true;
            sM4Context.mode = 1;
            object2 = HexStringConvert.parseHexStr2Byte((String)object2);
            byte[] byArray = HexStringConvert.parseHexStr2Byte(CBC_IV);
            SM4 sM4 = new SM4();
            sM4.sm4_setkey_enc(sM4Context, (byte[])object2);
            object = sM4.sm4_crypt_cbc(sM4Context, byArray, ((String)object).getBytes(ENCODING));
            object = new BASE64Encoder().encode((byte[])object);
            if (object != null && ((String)object).trim().length() > 0) {
                Pattern pattern = Pattern.compile("\\s*|\t|\r|\n");
                object2 = pattern;
                object = pattern.matcher((CharSequence)object);
                object = ((Matcher)object).replaceAll("");
            }
            return object;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public static String decryptData_CBC(String cipherText, String key) {
        try {
            Object object;
            byte[] byArray;
            SM4Context sM4Context = new SM4Context();
            new SM4Context().isPadding = true;
            sM4Context.mode = 0;
            byArray = HexStringConvert.parseHexStr2Byte((String)byArray);
            byte[] byArray2 = HexStringConvert.parseHexStr2Byte(CBC_IV);
            SM4 sM4 = new SM4();
            sM4.sm4_setkey_dec(sM4Context, byArray);
            object = sM4.sm4_crypt_cbc(sM4Context, byArray2, new BASE64Decoder().decodeBuffer((String)object));
            return new String((byte[])object, ENCODING);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] encryptData_CBC(byte[] data, String key, boolean padding, byte[] iv) {
        void var3_3;
        void var2_2;
        void var1_1;
        return SM4Util.encryptData_CBC(data, (String)var1_1, (boolean)var2_2, (byte[])var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] encryptData_CBC(byte[] data, String key, boolean padding, byte[] iv, boolean innerCopyIV) {
        try {
            byte[] byArray;
            SM4 sM4;
            byte[] byArray2;
            void var2_2;
            SM4Context sM4Context = new SM4Context();
            new SM4Context().isPadding = var2_2;
            sM4Context.mode = 1;
            byArray2 = HexStringConvert.parseHexStr2Byte((String)byArray2);
            byte[] byArray3 = iv;
            if (innerCopyIV) {
                void v0 = sM4;
                byArray3 = Arrays.copyOf((byte[])v0, ((void)v0).length);
            }
            sM4 = new SM4();
            sM4.sm4_setkey_enc(sM4Context, byArray2);
            byArray = sM4.sm4_crypt_cbc(sM4Context, byArray3, byArray);
            return byArray;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decryptData_CBC(byte[] data, String key, boolean padding, byte[] iv) {
        void var3_3;
        void var2_2;
        void var1_1;
        return SM4Util.decryptData_CBC(data, (String)var1_1, (boolean)var2_2, (byte[])var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decryptData_CBC(byte[] data, String key, boolean padding, byte[] iv, boolean innerCopyIV) {
        try {
            byte[] byArray;
            SM4 sM4;
            byte[] byArray2;
            void var2_2;
            SM4Context sM4Context = new SM4Context();
            new SM4Context().isPadding = var2_2;
            sM4Context.mode = 0;
            byArray2 = HexStringConvert.parseHexStr2Byte((String)byArray2);
            byte[] byArray3 = iv;
            if (innerCopyIV) {
                void v0 = sM4;
                byArray3 = Arrays.copyOf((byte[])v0, ((void)v0).length);
            }
            sM4 = new SM4();
            sM4.sm4_setkey_dec(sM4Context, byArray2);
            byArray = sM4.sm4_crypt_cbc(sM4Context, byArray3, byArray);
            return byArray;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public static String getSm3WithSM4Base64(String data, String key) {
        Object object;
        try {
            byte[] byArray;
            byte[] byArray2 = data.getBytes(ENCODING);
            object = byArray2;
            object = HashUtil.getDigestBytes(byArray2, "sm3");
            SM4Context sM4Context = new SM4Context();
            new SM4Context().isPadding = true;
            sM4Context.mode = 1;
            byArray = HexStringConvert.parseHexStr2Byte((String)byArray);
            byte[] byArray3 = HexStringConvert.parseHexStr2Byte(CBC_IV);
            SM4 sM4 = new SM4();
            sM4.sm4_setkey_enc(sM4Context, byArray);
            byte[] byArray4 = sM4.sm4_crypt_cbc(sM4Context, byArray3, (byte[])object);
            object = byArray4;
            return Base64NoCR.encodeToStr(byArray4);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return "";
        }
    }

    public static String genKey() {
        SecureRandom secureRandom = SecureRandomSingleton.getInstance();
        byte[] byArray = new byte[16];
        secureRandom.nextBytes(byArray);
        return HexStringConvert.parseByte2HexStr(byArray);
    }
}

