/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.security.standard;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import tech.simkey.dove.encoding.Base64FromAndroid;
import tech.simkey.dove.encoding.Base64NoCR;
import tech.simkey.dove.security.HexStringConvert;
import tech.simkey.dove.util.ParamsEmptyChecker;

public class ByteCodec {
    private byte[] bytes;

    public static ByteCodec EMPTY() {
        return new ByteCodec(new byte[0]);
    }

    public static ByteCodec fromBytes(byte[] bytes) {
        byte[] byArray;
        return new ByteCodec(byArray);
    }

    public static ByteCodec fromHexString(String hexString) {
        String string;
        return new ByteCodec(HexStringConvert.parseHexStr2Byte(string));
    }

    public static ByteCodec fromUTFString(String str) {
        String string;
        return new ByteCodec(string.getBytes(StandardCharsets.UTF_8));
    }

    public static ByteCodec fromBase64String(String base64) {
        String string;
        return new ByteCodec(Base64FromAndroid.decode(string, 0));
    }

    /*
     * WARNING - void declaration
     */
    public ByteCodec(byte[] bytes) {
        void var1_1;
        this.bytes = var1_1;
    }

    public byte[] toBytes() {
        return this.bytes;
    }

    public String toHexString() {
        if (ParamsEmptyChecker.isEmpty(this.bytes)) {
            return "";
        }
        return HexStringConvert.parseByte2HexStr(this.bytes);
    }

    public String toUTF8String() {
        if (ParamsEmptyChecker.isEmpty(this.bytes)) {
            return "";
        }
        return new String(this.bytes, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public String toUTFString(String charsetName) throws UnsupportedEncodingException {
        void var1_1;
        if (ParamsEmptyChecker.isEmpty(this.bytes)) {
            return "";
        }
        return new String(this.bytes, (String)var1_1);
    }

    public String toBase64() {
        return this.toBase64NoCR();
    }

    public String toBase64NoCR() {
        if (ParamsEmptyChecker.isEmpty(this.bytes)) {
            return "";
        }
        return Base64NoCR.encodeToStr(this.bytes);
    }

    public String toBase64WithCR() {
        if (ParamsEmptyChecker.isEmpty(this.bytes)) {
            return "";
        }
        return Base64FromAndroid.encodeToString(this.bytes);
    }

    public String toString() {
        return this.toHexString();
    }
}

