/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.dove.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import tech.simkey.dove.num.ByteUtil;
import tech.simkey.dove.security.HexStringConvert;
import tech.simkey.dove.util.Ints;

public class ASN1SeqBlockReader
implements Closeable {
    private final File file;
    private int pos = 0;
    private final RandomAccessFile reader;

    /*
     * WARNING - void declaration
     */
    public ASN1SeqBlockReader(File file) throws FileNotFoundException {
        void var1_1;
        this.file = file;
        this.reader = new RandomAccessFile((File)var1_1, "r");
    }

    public byte[] readABlock() throws IOException {
        int n2;
        byte[] byArray;
        if ((long)(this.pos + 1) > this.reader.length()) {
            return new byte[0];
        }
        int n3 = (int)Math.min(10L, this.reader.length() - (long)this.pos);
        byte[] byArray2 = new byte[n3];
        this.reader.seek(this.pos);
        this.reader.read(byArray2, 0, n3);
        n3 = 0;
        if ((byArray2[1] & 0x80) > 0) {
            n3 = byArray2[1] & 0x7F;
            byArray = ByteUtil.subBytes(byArray2, 2, n3);
            n2 = Ints.toInt(HexStringConvert.parseByte2HexStr(byArray), 16);
        } else {
            n2 = byArray2[1];
        }
        byArray = new byte[n3 + 2 + n2];
        this.reader.seek(this.pos);
        this.reader.read(byArray, 0, n3 + 2 + n2);
        this.pos = this.pos + 2 + n3 + n2;
        return byArray;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

