/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.otp;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.simkey.dove.util.HexStringConvert;
import tech.simkey.dove.util.Ints;

public abstract class OTPHelper {
    private static final Logger logger = LoggerFactory.getLogger(OTPHelper.class);

    protected abstract byte[] encryptData_CBC(byte[] var1, SecretKey var2, boolean var3, byte[] var4);

    protected abstract byte[] sm4_encrypt_ECB(byte[] var1, SecretKey var2, boolean var3);

    /*
     * WARNING - void declaration
     */
    public byte[] getKsForOTP(SecretKey masterKey, byte[] x2) {
        if (x2 == null) {
            return null;
        }
        try {
            byte[] byArray;
            byte[] byArray2 = new byte[16];
            if (x2.length > 16) {
                System.arraycopy(x2, 0, byArray2, 0, 16);
            } else {
                void var2_2;
                System.arraycopy(x2, 0, byArray2, 0, ((void)var2_2).length);
            }
            byArray = this.sm4_encrypt_ECB(byArray2, (SecretKey)byArray, false);
            return byArray;
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getOTP(SecretKey otpKey, byte[] T2, byte[] C2, String Q2, int N2) throws Exception {
        Object object;
        byte[] byArray;
        int n2 = 0;
        if (T2 != null) {
            if (T2.length != 8) {
                throw new IllegalArgumentException("T\u957f\u5ea6\u9519\u8bef\uff01");
            }
            n2 += 8;
        }
        if (C2 != null) {
            if (C2.length != 4) {
                throw new IllegalArgumentException("C\u957f\u5ea6\u9519\u8bef\uff01");
            }
            n2 += 4;
        }
        if (Q2 != null) {
            if (Q2.length() < 4) {
                throw new IllegalArgumentException("Q\u957f\u5ea6\u9519\u8bef\uff01");
            }
            n2 += Q2.length();
        }
        if (N2 < 6) {
            throw new IllegalArgumentException("N\u957f\u5ea6\u4e0d\u5f97\u5c0f\u4e8e6");
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef\uff01");
        }
        n2 = (n2 - 1) / 16 + 1 << 4;
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        if (T2 != null) {
            System.arraycopy(byArray, 0, byArray2, 0, 8);
            n3 += 8;
        }
        if (C2 != null) {
            void var3_7;
            System.arraycopy(var3_7, 0, byArray2, n3, 4);
            n3 += 4;
        }
        if (Q2 != null) {
            System.arraycopy(Q2.getBytes(StandardCharsets.UTF_8), 0, byArray2, n3, Q2.length());
        }
        byArray = HexStringConvert.parseHexStr2Byte("00000000000000000000000000000000");
        object = HexStringConvert.parseByte2HexStr(this.encryptData_CBC(byArray2, (SecretKey)object, false, byArray));
        byte[] byArray3 = HexStringConvert.parseHexStr2Byte(((String)object).substring(((String)object).length() - 32));
        object = byArray3;
        int n4 = ((byArray3[0] & 0xFF) << 24) + ((object[1] & 0xFF) << 16) + ((object[2] & 0xFF) << 8) + (object[3] & 0xFF);
        int n5 = ((object[4] & 0xFF) << 24) + ((object[5] & 0xFF) << 16) + ((object[6] & 0xFF) << 8) + (object[7] & 0xFF);
        int n6 = ((object[8] & 0xFF) << 24) + ((object[9] & 0xFF) << 16) + ((object[10] & 0xFF) << 8) + (object[11] & 0xFF);
        int n7 = ((object[12] & 0xFF) << 24) + ((object[13] & 0xFF) << 16) + ((object[14] & 0xFF) << 8) + (object[15] & 0xFF);
        long l2 = (long)(n4 + n5 + n6 + n7) % 0x100000000L;
        long l3 = l2 >= 0L ? l2 : l2 + 0x100000000L;
        long l4 = l3 % (long)Math.pow(10.0, N2);
        String string = Long.toString(l4);
        StringBuilder stringBuilder = new StringBuilder();
        for (n5 = string.length(); n5 < N2; ++n5) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public boolean checkOTPCode(SecretKey otpKey, String otpCode, long otpTime, int otpPeriod, int incidentDivisor, String challengeCode, int otpLength) {
        try {
            byte[] byArray = Ints.toByteArrays(incidentDivisor);
            boolean bl = false;
            for (int i2 = -2; i2 <= 2; ++i2) {
                long l2 = otpTime + (long)(otpPeriod * i2);
                Object object = ByteBuffer.allocate(8).putLong(l2 / (long)otpPeriod).array();
                if (!otpCode.equals(object = (Object)this.getOTP(otpKey, (byte[])object, byArray, challengeCode, otpLength))) continue;
                bl = true;
                break;
            }
            return bl;
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }
}

