/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.pkcs.gmt0010;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import tech.simkey.pkcs.gmt0010.EncryptedContentInfo;
import tech.simkey.pkcs.gmt0010.RecipientInfo;

public class EnvelopedData
extends ASN1Object {
    private final long version = 1L;
    private RecipientInfo[] recipientInfos;
    private EncryptedContentInfo encryptedContentInfo;

    public static EnvelopedData getInstance(Object obj) {
        if (obj instanceof EnvelopedData) {
            return (EnvelopedData)((Object)obj);
        }
        if (obj != null) {
            Object object;
            return new EnvelopedData(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public EnvelopedData(RecipientInfo[] recipientInfos, EncryptedContentInfo encryptedContentInfo) {
        void var2_2;
        void var1_1;
        this.recipientInfos = var1_1;
        this.encryptedContentInfo = var2_2;
    }

    private EnvelopedData(ASN1Sequence seq) {
        Enumeration enumeration;
        if (seq.size() != 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        enumeration = enumeration.getObjects();
        ASN1Integer.getInstance(enumeration.nextElement());
        ASN1Set aSN1Set = ASN1Set.getInstance(enumeration.nextElement());
        this.recipientInfos = new RecipientInfo[aSN1Set.size()];
        for (int i2 = 0; i2 < aSN1Set.size(); ++i2) {
            ASN1Encodable aSN1Encodable = aSN1Set.getObjectAt(i2);
            aSN1Encodable = RecipientInfo.getInstance(aSN1Encodable);
            this.recipientInfos[i2] = aSN1Encodable;
        }
        this.encryptedContentInfo = EncryptedContentInfo.getInstance(enumeration.nextElement());
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(1L));
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        RecipientInfo[] recipientInfoArray = this.recipientInfos;
        int n2 = this.recipientInfos.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            RecipientInfo recipientInfo = recipientInfoArray[i2];
            aSN1EncodableVector2.add((ASN1Encodable)recipientInfo);
        }
        aSN1EncodableVector.add((ASN1Encodable)new DERSet(aSN1EncodableVector2));
        aSN1EncodableVector.add((ASN1Encodable)this.encryptedContentInfo);
        return new DERSequence(aSN1EncodableVector);
    }

    public RecipientInfo[] getRecipientInfos() {
        return this.recipientInfos;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }
}

