/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.pkcs.gmt0010;

import java.io.IOException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import tech.simkey.pkcs.gmt0009.SM2Cipher;
import tech.simkey.pkcs.gmt0010.KeyEncryptionAlgorithmIdentifier;

public class RecipientInfo
implements ASN1Encodable {
    private final long version = 1L;
    private IssuerAndSerialNumber issuerAndSerialNumber;
    private KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithmIdentifier;
    private SM2Cipher encryptedKey;

    public static RecipientInfo getInstance(Object obj) {
        if (obj instanceof RecipientInfo) {
            return (RecipientInfo)obj;
        }
        if (obj != null) {
            Object object;
            return new RecipientInfo(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public RecipientInfo(IssuerAndSerialNumber issuerAndSerialNumber, KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithmIdentifier, SM2Cipher encryptedKey) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.issuerAndSerialNumber = var1_1;
        this.keyEncryptionAlgorithmIdentifier = var2_2;
        this.encryptedKey = var3_3;
    }

    private RecipientInfo(ASN1Sequence seq) {
        Enumeration enumeration;
        if (seq.size() != 4) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        enumeration = enumeration.getObjects();
        ASN1Integer.getInstance(enumeration.nextElement());
        this.issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(enumeration.nextElement());
        this.keyEncryptionAlgorithmIdentifier = KeyEncryptionAlgorithmIdentifier.getInstance(enumeration.nextElement());
        this.encryptedKey = SM2Cipher.getInstance(DEROctetString.getInstance(enumeration.nextElement()).getOctets());
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(1L));
        aSN1EncodableVector.add((ASN1Encodable)this.issuerAndSerialNumber);
        aSN1EncodableVector.add((ASN1Encodable)this.keyEncryptionAlgorithmIdentifier);
        try {
            aSN1EncodableVector.add((ASN1Encodable)new DEROctetString((ASN1Encodable)this.encryptedKey));
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public KeyEncryptionAlgorithmIdentifier getKeyEncryptionAlgorithmIdentifier() {
        return this.keyEncryptionAlgorithmIdentifier;
    }

    public SM2Cipher getEncryptedKey() {
        return this.encryptedKey;
    }
}

