/*
 * Decompiled with CFR 0.152.
 */
package tech.simkey.pkcs.gmt0010.p7envelope;

import java.security.SecureRandom;
import java.util.Random;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import tech.simkey.dove.security.HexStringConvert;
import tech.simkey.dove.security.cer.CerUtil;
import tech.simkey.dove.security.sm2.SM2UtilsC132No04;
import tech.simkey.dove.security.sm4.SM4Util;
import tech.simkey.pkcs.gmt0009.SM2Cipher;
import tech.simkey.pkcs.gmt0010.ContentEncryptionAlgorithmIdentifier;
import tech.simkey.pkcs.gmt0010.EncryptedContent;
import tech.simkey.pkcs.gmt0010.EncryptedContentInfo;
import tech.simkey.pkcs.gmt0010.Enveloped;
import tech.simkey.pkcs.gmt0010.EnvelopedData;
import tech.simkey.pkcs.gmt0010.KeyEncryptionAlgorithmIdentifier;
import tech.simkey.pkcs.gmt0010.RecipientInfo;

public class P7Envelope {
    public byte[] encodeP7EnvelopedData(byte[] cert, byte[] data) throws Exception {
        Object object;
        Object object2 = CerUtil.parser2Cer3(cert);
        Object object3 = object2.getIssuer();
        Object object4 = object2.getSerialNumber().getValue();
        byte[] byArray = object2.getSubjectPublicKeyInfo().getPublicKeyData().getEncoded();
        object2 = byArray;
        object2 = HexStringConvert.parseByte2HexStr(DERBitString.getInstance((Object)byArray).getBytes());
        object2 = object2.substring(object2.length() - 128);
        byte[] byArray2 = this.getSm4Key();
        byte[] byArray3 = this.getIV();
        String string = HexStringConvert.parseByte2HexStr(byArray3);
        object = SM4Util.encryptData_CBC(object, HexStringConvert.parseByte2HexStr(byArray2), true, byArray3);
        object2 = SM2UtilsC132No04.encrypt(HexStringConvert.parseHexStr2Byte((String)object2), byArray2);
        object3 = new IssuerAndSerialNumber(object3, object4);
        object4 = new ASN1ObjectIdentifier("1.2.156.10197.1.301.3");
        object4 = new KeyEncryptionAlgorithmIdentifier((ASN1ObjectIdentifier)object4);
        object2 = new SM2Cipher((byte[])object2, false);
        object2 = new RecipientInfo((IssuerAndSerialNumber)object3, (KeyEncryptionAlgorithmIdentifier)((Object)object4), (SM2Cipher)object2);
        object2 = new RecipientInfo[]{object2};
        byArray3 = HexStringConvert.parseHexStr2Byte(string);
        object3 = new ContentEncryptionAlgorithmIdentifier(byArray3);
        object = new EncryptedContent((byte[])object);
        object = new EncryptedContentInfo((ContentEncryptionAlgorithmIdentifier)object3, (EncryptedContent)object);
        object2 = new EnvelopedData((RecipientInfo[])object2, (EncryptedContentInfo)object);
        object2 = new Enveloped((EnvelopedData)((Object)object2));
        return object2.toASN1Primitive().getEncoded("DER");
    }

    public byte[] decodeP7EnvelopedData(byte[] sm2PrivKey, byte[] envelope) throws Exception {
        byte[] byArray;
        Object object = Enveloped.getInstance(envelope);
        object = ((Enveloped)object).getEnvelopedData();
        Object object2 = ((EnvelopedData)((Object)object)).getRecipientInfos()[0];
        object2 = ((RecipientInfo)object2).getEncryptedKey().getCipherC132No04();
        byte[] byArray2 = ((EnvelopedData)((Object)object)).getEncryptedContentInfo().getEncryptedContent().getEncryptedContent();
        byte[] byArray3 = ((EnvelopedData)((Object)object)).getEncryptedContentInfo().getContentEncryptionAlgorithmIdentifier().getIv();
        object = ((EnvelopedData)((Object)object)).getEncryptedContentInfo().getContentEncryptionAlgorithmIdentifier().getOid();
        byArray = this.sm2PrivDecrypt(byArray, (byte[])object2);
        if (!"1.2.156.10197.1.104.1.4".equals(object) && !"1.2.156.10197.1.104.2".equals(object)) {
            throw new IllegalArgumentException("unsupport sym oid:" + (String)object);
        }
        return SM4Util.decryptData_CBC(byArray2, HexStringConvert.parseByte2HexStr(byArray), true, byArray3);
    }

    protected byte[] getSm4Key() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[16];
        ((Random)secureRandom).nextBytes(byArray);
        return byArray;
    }

    protected byte[] getIV() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[16];
        ((Random)secureRandom).nextBytes(byArray);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] sm2PrivDecrypt(byte[] sm2PrivKey, byte[] encryptedSm4Key) throws Exception {
        void var2_2;
        return SM2UtilsC132No04.decrypt(sm2PrivKey, (byte[])var2_2);
    }
}

