//package com.example.kmssdkdemo.service.impl;
//
//import com.example.kmssdkdemo.service.TestService;
//import com.sec.xincipher.simkey.kms.exception.KMSException;
//import com.sec.xincipher.simkey.kms.kmssdk.ClientAsymmetricEncryption;
//import com.sec.xincipher.simkey.kms.kmssdk.entity.KMSAsymBizKey;
//import com.sec.xincipher.simkey.kms.kmssdk.entity.SignResult;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.stereotype.Service;
//
//import java.nio.charset.StandardCharsets;
//import java.util.Base64;
//
//@Service
//public class AsymBizKeyTestServiceImpl extends TestService {
//
//    private static Logger logger = LoggerFactory.getLogger(AsymBizKeyTestServiceImpl.class);
//
//    @Override
//    public void test() throws KMSException {
//
//        System.out.println(this.getClass().toString());
//
//        /*
//        非对称业务密钥，主要作用：
//        1、对系统数据进行加解密，例如，可用于系统在使用使用别的组件或配置时，让组件或配置的开发者使用自己的公钥进行加密，业务系统使用对应的私钥进行
//        解密的此类场景中；
//        2、对系统数据进行签名验签，例如，可用于系统对外证明自己身份时的业务场景中，系统使用自己的私钥进行签名，周边系统使用对应的公钥进行验签的此类场景中
//        因此，一个业务系统只能有少量的非对称业务密钥，业务系统在调用SDK API生成非对称业务密钥后，会得到业务密钥ID，且需要保存，
//        可使用业务密钥ID调用SDK API接口进行加解密或签名系统级别的数据，不建议使用业务密钥进行用户级别的数据加解密
//         */
//
//        //若已存在非对称业务密钥，可直接使用，无需再次生成
//        //KMSAsymBizKey asymBizKey = kmsClient.genSM2BizKey();
//        //String bizEncKeyId = asymBizKey.getEncKeyId();//非对称业务加解密密钥ID
//        //String bizSignKeyId = asymBizKey.getSignKeyId();//非对称业务签名密钥ID
//        String bizEncKeyId = "47F843CF07864873";
//        String bizSignKeyId = "3789D88448C9776E";
//        ClientAsymmetricEncryption cae = kmsClient.useSM2BizkeyRemoteEncryption(bizEncKeyId, bizSignKeyId);
//
//        //读取公钥
//        byte[] publickey = cae.readPublicKey();
//        System.out.println("非对称业务密钥 导出公钥：" + Base64.getEncoder().encodeToString(publickey));
//
//        //加密
//        byte[] data = "这是一个系统级别的数据".getBytes(StandardCharsets.UTF_8);
//        byte[] data_en = cae.encryptBytes(data);
//        System.out.println("非对称业务密钥 加密：" + Base64.getEncoder().encodeToString(data_en));
//        //解密
//        data = cae.decryptBytes(data_en);
//        System.out.println("非对称业务密钥 解密：" + new String(data, StandardCharsets.UTF_8));
//        //签名
//        SignResult sign = cae.sign(data);
//        String info = String.format("SignData:%s\nSignKeyId:%s\nSignKeyVersion:%s"
//                , Base64.getEncoder().encodeToString(sign.getSignData())
//                , sign.getSignKeyId()
//                , sign.getSignKeyVersion()
//        );
//        System.out.println("非对称业务密钥 签名：" + info);
//        //验签
//        boolean verifyResult = cae.verify(sign.getSignKeyId(), sign.getSignKeyVersion(), data, sign.getSignData());
//        System.out.println("非对称业务密钥 验签：" + verifyResult);
//
//    }
//}
