package com.example.kmssdkdemo.service.impl;

import com.example.kmssdkdemo.service.TestService;
import com.sec.xincipher.simkey.kms.exception.KMSException;
import com.sec.xincipher.simkey.kms.kmssdk.ClientLegacyEncryption;
import com.sec.xincipher.simkey.kms.kmssdk.constant.LegacyAlgorithm;
import com.sec.xincipher.simkey.kms.kmssdk.constant.LegacyKeytype;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

import tech.simkey.dove.util.HexStringConvert;

public class BizKeyLegacyTestServiceImpl extends TestService {
    
    
    @Override
    public void test() throws KMSException {
        
        System.out.println(this.getClass().toString());

        /*
        "遗留算法业务密钥"有两层含义：
        1、业务系统在接入KMS系统之前，已产生了历史密钥，这类密钥可以通过导入到KMS系统的方式继续使用；
        2、KMS系统主要使用的是国标密码算法，但也支持国际算法，如果业务系统必须使用国际算法，可以通过导入或生成相应的国际算法业务密钥
        的方式使用KMS。
        总体来说，国际算法的密钥和历史密钥均可称之为“遗留算法业务密钥”
         */
        
        ////生成遗留算法业务密钥，通常用在业务系统必须使用国际算法的场景下。若已有业务密钥，则可直接使用，无需再次生成，密钥ID需要业务系统存储
        ////KMSBizKey kmsBizKey = kmsClient.genBizKeyLegacy(LegacyKeytype.AES_256);
        ////String bizEncKeyId =kmsBizKey.getEncKeyId();//业务加解密密钥ID
        ////String bizHmacKeyId =kmsBizKey.getHmacKeyId();//业务HMAC密钥ID
        //
        //String bizEncKeyId = kmsClient.importEncBizKeyLegacy(HexStringConvert.parseHexStr2Byte("11223344556677881122334455667788"), LegacyKeytype.AES_128);
        //System.out.println("已导入遗留业务密钥, 其 密钥id是:" + bizEncKeyId);
        //
        //ClientLegacyEncryption cle = kmsClient.useBizkeyRemoteLegacyEncryption(bizEncKeyId, null);
        //
        //byte[] iv = new byte[]{0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x0};
        //byte[] data = "这是一个系统配置信息".getBytes(StandardCharsets.UTF_8);
        //byte[] data_en = cle.encryptBytesLegacy(LegacyAlgorithm.AES_ECB_PKCS5PADDING, iv, data);
        //System.out.println("遗留算法业务密钥的加密结果：" + Base64.getEncoder().encodeToString(data_en));
        //data = cle.decryptBytesLegacy(LegacyAlgorithm.AES_ECB_PKCS5PADDING, iv, data_en);
        //System.out.println("遗留算法业务密钥的解密结果：" + new String(data, StandardCharsets.UTF_8));
        //
        ////导入历史密钥
        //byte[] key = new byte[]{0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x0};
        //String enc_BizKeyId = kmsClient.importEncBizKeyLegacy(key, LegacyKeytype.AES_256);
        //cle = kmsClient.useBizkeyRemoteLegacyEncryption(enc_BizKeyId, "");
        //data_en = cle.encryptBytesLegacy(LegacyAlgorithm.AES_ECB_PKCS5PADDING, iv, data);
        //System.out.println("遗留算法业务密钥的加密结果：" + Base64.getEncoder().encodeToString(data_en));
        //data = cle.decryptBytesLegacy(LegacyAlgorithm.AES_ECB_PKCS5PADDING, iv, data_en);
        //System.out.println("遗留算法业务密钥的解密结果：" + new String(data, StandardCharsets.UTF_8));
    }
}
