package com.example.kmssdkdemo.service.impl;

import com.example.kmssdkdemo.config.KMSConfigura;
import com.example.kmssdkdemo.service.TestService;
import com.sec.xincipher.simkey.kms.exception.KMSException;
import com.sec.xincipher.simkey.kms.kmssdk.ClientRemoteEncryption;
import com.sec.xincipher.simkey.kms.kmssdk.OutputFormat;
import com.sec.xincipher.simkey.kms.kmssdk.constant.SimkeyFpeAlphabet;

import tech.simkey.dove.encoding.Base64NoCR;
import tech.simkey.dove.util.HexStringConvert;
import tech.simkey.dove.util.TextUtils;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BizKeyTestServiceImpl extends TestService {
    
    
    @Override
    public void test() throws KMSException {
        
        System.out.println(this.getClass().toString());
        OutputFormat outputFormat = KMSConfigura.OUTPUT_FORMAT;

        /*
        业务密钥是系统级别的密钥，主要作用有两个：
        1、用于保护系统级别的数据，加解密系统级别的数据
        2、用于保护生成用户密钥（数据密钥）
        因此一个业务系统只能有少量的业务密钥，业务系统在调用SDK API生成业务密钥后，会得到业务密钥ID，且需要保存，
        可使用业务密钥ID调用SDK API接口进行加解密系统级别的数据，不建议使用业务密钥进行用户级别的数据加解密。
         */
        /*
        1、加解密相关操作
         */
        ////生成业务密钥，若已有业务密钥，则可直接使用，无需再次生成
        //KMSBizKey bizKey = kmsClient.genBizKey();
        //String bizEncKeyId = bizKey.getEncKeyId();//业务加解密密钥ID
        //String bizHmacKeyId = bizKey.getHmacKeyId();//业务HMAC密钥ID
        String bizEncKeyId = KMSConfigura.bizEncKeyId;
        String bizHmacKeyId = KMSConfigura.bizHmacKeyId;
        System.out.println("bizEncKeyId：" + bizEncKeyId);
        System.out.println("bizHmacKeyId：" + bizHmacKeyId);
        //使用业务密钥ID实例化一个ClientRemoteEncryption对象，可使用该对象进行加解密
        ClientRemoteEncryption cre = kmsClient.useBizkeyRemoteEncryption(bizEncKeyId, bizHmacKeyId);
        byte[] data = "这是一个系统级别的数据".getBytes(Charset.forName("utf-8"));
        //加密
        String output = cre.encryptBytes2Str(data, outputFormat);
        System.out.println("加密结果：" + output);
        //解密
        data = cre.decryptStr2Bytes(output);
        System.out.println("解密结果：" + HexStringConvert.parseByte2HexStr(data));
        //对一行数据进行加密，如对一张系统级别的配置表中的某一行数据进行加密，加密后存储到表中，达到保护数据的机密性
        Map<String, String> rawData = new HashMap<>();
        rawData.put("id", "10293838");
        rawData.put("configname", "loggerSwitch");
        rawData.put("configvalue", "off");
        rawData.put("desc", "日志开关");
        Map<String, String> result_encryptMap = cre.encryptMap(rawData, outputFormat);
        System.out.println("encryptMap 加密结果：");
        result_encryptMap.forEach((key, value) -> {
            System.out.println("key：" + key + " value：" + value);
        });
        //对一行数据进行解密，如对一张系统级别的配置表中的某一行密文数据进行解密
        Map<String, String> result_decryptMap = cre.decryptMap(result_encryptMap);
        System.out.println("decryptMap 解密结果：");
        result_decryptMap.forEach((key, value) -> {
            System.out.println("key：" + key + " value：" + value);
        });
        //对一行数据进行加密的同时，生成一个名称为“sm3hmac”的HMAC，用于保证整行数据的完整性，需要把它保存到该行的“sm3hmac”列中
        Map<String, String> result_encryptMapWithSm3hmac = cre.encryptMapWithSm3hmac(rawData, outputFormat);
        System.out.println("encryptMapWithSm3hmac 加密结果：");
        result_encryptMapWithSm3hmac.forEach((key, value) -> {
            System.out.println("key：" + key + " value：" + value);
        });
        //对一行数据进行解密的同时，验证整行数据的完整性
        try {
            //当视图改变“sm3hmac”列的值时，将导致整个解密过程异常
            //result_encryptMapWithSm3hmac.put("sm3hmac", "试图篡改该值，将导致整个解密过程发生异常");
            Map<String, String> result_decryptMapAndVerifySm3hmac = cre.decryptMapAndVerifySm3hmac(result_encryptMapWithSm3hmac);
            System.out.println("decryptMapAndVerifySm3hmac 解密结果：");
            result_decryptMapAndVerifySm3hmac.forEach((key, value) -> {
                System.out.println("key：" + key + " value：" + value);
            });
        } catch (KMSException ex) {
            System.out.println(ex.getMessage());
        }
        
        //对一个数据计算HMAC，通常用于只保证数据完整性，不需要保证机密性的场景
        data = "数据库的连接地址是：xxx".getBytes(StandardCharsets.UTF_8);
        System.out.println(cre.sm3HMAC(data, outputFormat));
        //对一组数据或表中一行数据计算HMAC，通常用于只保证数据完整性，不需要保证机密性的场景
        Map<String, String> rawData_new = new HashMap<>();
        rawData_new.put("id", Base64NoCR.encodeToStr("10293838".getBytes(StandardCharsets.UTF_8)));
        rawData_new.put("configname", Base64NoCR.encodeToStr("loggerSwitch".getBytes(StandardCharsets.UTF_8)));
        rawData_new.put("configvalue", Base64NoCR.encodeToStr("off0".getBytes(StandardCharsets.UTF_8)));
        rawData_new.put("desc", Base64NoCR.encodeToStr("日志开关".getBytes(StandardCharsets.UTF_8)));
        System.out.println(cre.sm3HMAC(rawData_new, outputFormat));
        
        //fpedemo, 对手机号码的中间4位进行格式保留加密
        System.out.println("fpe加密测试");
        String mobile = "18012344321";
        List<SimkeyFpeAlphabet> simkeyFpeAlphabets = new ArrayList<>();
        simkeyFpeAlphabets.add(SimkeyFpeAlphabet.Numeric);
        String fpePlain = mobile.substring(3, 7);
        byte[] tweak = mobile.substring(7).getBytes(StandardCharsets.UTF_8);
        String fpeEnc = cre.fpeEncrypt(simkeyFpeAlphabets, tweak, fpePlain);
        System.out.println(fpePlain + " fpe加密结果:" + fpeEnc);//1234 fpe加密结果:3757
        String mobileEnc = mobile.substring(0, 3) + fpeEnc + mobile.substring(7);
        //手机号码: 18012344321 fpe加密后重组为:18037574321
        System.out.println("手机号码: " + mobile + " fpe加密后重组为:" + mobileEnc);
        
        String fpeDec = cre.fpeDecrypt(simkeyFpeAlphabets, tweak, fpeEnc);
        System.out.println(fpeEnc + " fpe解密结果:" + fpeDec);//3757 fpe解密结果:1234
        //手机号码: 18037574321 fpe解密后重组为:18012344321
        System.out.println("手机号码: " + mobileEnc + " fpe解密后重组为:" + mobile.substring(0, 3) + fpeDec + mobile.substring(7));
        if (!TextUtils.equals(fpePlain, fpeDec)) {
            System.err.println("FPE 解密结果不正确!!!!!!!!!!!");
        } else {
            System.out.println("fpe测试成功");
        }
        
        
        //测试 sm4 gcm 加解密, 适用于数据加密传输
        System.out.println("测试SM4 GCM加解密功能");
        byte[] sm4gcmTestData = "1234567812345678123456781234567812345678123456781234567812".getBytes();
        byte[] iv = HexStringConvert.parseHexStr2Byte("11223344556677881122334455667788");//16字节iv
        byte[] aad = "simkey".getBytes();
        String sm4gcmEnc = cre.sm4GcmEncrypt(sm4gcmTestData, iv, aad);
        System.out.println("SM4 GCM 原文.Hex:" + HexStringConvert.parseByte2HexStr(sm4gcmTestData));
        System.out.println("SM4 GCM 密文.BASE64:" + sm4gcmEnc);
        System.out.println("SM4 GCM 密文.Hex:" + HexStringConvert.parseByte2HexStr(Base64NoCR.decode(sm4gcmEnc)));
        byte[] sm4gcmDec = cre.sm4GcmDecrypt(sm4gcmEnc, iv, aad);
        System.out.println("SM4 GCM 解密.Hex:" + HexStringConvert.parseByte2HexStr(sm4gcmDec));
        if (!Arrays.equals(sm4gcmTestData, sm4gcmDec)) {
            System.err.println("SM4 GCM解密结果不正确!!!!!!!!!!!");
        } else {
            System.out.println("SM4 GCM解密结果正确");
        }
    }
}
