package com.example.kmssdkdemo.service.impl;

import com.example.kmssdkdemo.config.KMSConfigura;
import com.example.kmssdkdemo.service.TestService;
import com.example.kmssdkdemo.utils.ApplicationUtil;
import com.sec.xincipher.simkey.kms.exception.KMSException;
import com.sec.xincipher.simkey.kms.kmssdk.ClientLocalEncryption;
import com.sec.xincipher.simkey.kms.kmssdk.ClientRemoteEncryption;
import com.sec.xincipher.simkey.kms.kmssdk.OutputFormat;
import com.sec.xincipher.simkey.kms.kmssdk.constant.SimkeyFpeAlphabet;
import com.sec.xincipher.simkey.kms.kmssdk.entity.KMSBizKey;
import com.sec.xincipher.simkey.kms.kmssdk.entity.KMSUserKey;

import tech.simkey.dove.encoding.Base64NoCR;
import tech.simkey.dove.util.HexStringConvert;
import tech.simkey.dove.util.OSUtil;
import tech.simkey.dove.util.TextUtils;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserKeyTestServiceImpl extends TestService {
    
    @Override
    public void test() throws KMSException {
        
        System.out.println(this.getClass().toString());
        
        OutputFormat outputFormat = KMSConfigura.OUTPUT_FORMAT;
        /*
        用户密钥是用户级别的密钥，主要作用：
        1、用于保护用户级别的数据，加解密用户级别的数据。
        因此建议为每个用户生成属于该用户的用户密钥，根据业务设计需要，每个用户可以有多个用户密钥，用于保护不同业务数据，
        如可以为每个用户生成一个用于保护用户信息的用户密钥，也可以为每个用户生成一个用于保护订单信息的用户密钥，但业务系统要维护用户的密文数据
        和密钥的对应关系。
         */
        
        String bizEncKeyId = KMSConfigura.bizEncKeyId;
        String bizHmacKeyId = KMSConfigura.bizHmacKeyId;
        //使用业务密钥ID实例化一个ClientRemoteEncryption对象，可使用该对象生成用户密钥
        ClientRemoteEncryption cre = kmsClient.useBizkeyRemoteEncryption(bizEncKeyId, bizHmacKeyId);
        
        //生成用户密钥
        KMSUserKey userKey = cre.genUserKey();
        //用户密钥包括用户加解密密钥和用户HMAC密钥，会得到用户密钥密文和用户密钥ID，需要业务系统存储起来
        System.out.println("userEncKey：" + userKey.getEncKey() + " userEncKeyId：" + userKey.getEncKeyId());
        System.out.println("userHmacKey：" + userKey.getHmacKey() + " userHmacKeyId：" + userKey.getHmacKeyId());
        
        ClientLocalEncryption clr = kmsClient.useUserkeyLocalSoftEncryption(userKey.getEncKeyId(), userKey.getEncKey(), userKey.getHmacKeyId(), userKey.getHmacKey());
        try {
            byte[] data = "张三的家庭成员信息是：目前单身".getBytes(StandardCharsets.UTF_8);
            //加密，业务系统应维护加密后得到得密文和所使用的用户密钥的对应关系
            String output = clr.encryptBytes2Str(data, outputFormat);
            System.out.println("加密结果：" + output);
            //解密
            data = clr.decryptStr2Bytes(output);
            System.out.println("解密结果：" + new String(data, StandardCharsets.UTF_8));
            
            //从密文中提取密钥ID，可通过此方式简化查找计算密文数据所需要的密钥的过程，
            String temp_userEncKeyId = kmsClient.getKeyId(output);
            System.out.println("从数据密文中提取密钥ID：" + temp_userEncKeyId);
            //            userKey = cre.genUserKey();
            //            ClientLocalEncryption clr1 = kmsClient.useUserkeyLocalSoftEncryption(temp_userEncKeyId, userKey.getEncKey(), userKey.getHmacKeyId(), userKey.getHmacKey());
            //            output = clr1.encryptBytes(data);
            //            System.out.println("加密结果：" + HexStringConvert.parseByte2HexStr(output));
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        
        //对一行数据进行加密，如对一张订单信息表中的某一行数据进行加密，加密后存储到表中，达到保护数据的机密性
        Map<String, String> rawData = new HashMap<>();
        rawData.put("id", "10293838");
        rawData.put("userid", "98374653654");
        rawData.put("amount", "237.00");
        rawData.put("desc", "这是一行订单信息");
        Map<String, String> result_encryptMap = clr.encryptMap(rawData, outputFormat);
        System.out.println("encryptMap 加密结果：");
        result_encryptMap.forEach((key, value) -> {
            System.out.println("key：" + key + " value：" + value);
        });
        //对一行数据进行解密，如对一张订单信息表中的某一行密文数据进行解密
        Map<String, String> result_decryptMap = clr.decryptMap(result_encryptMap);
        System.out.println("decryptMap 解密结果：");
        result_decryptMap.forEach((key, value) -> {
            System.out.println("key：" + key + " value：" + value);
        });
        
        
        //对一行数据进行加密的同时，生成一个名称为“sm3hmac”的HMAC，用于保证整行数据的完整性，需要把它保存到该行的“sm3hmac”列中
        Map<String, String> result_encryptMapWithSm3hmac = clr.encryptMapWithSm3hmac(rawData, outputFormat);
        System.out.println("encryptMapWithSm3hmac 加密结果：");
        result_encryptMapWithSm3hmac.forEach((key, value) -> {
            System.out.println("key：" + key + " value：" + value);
        });
        //对一行数据进行解密的同时，验证整行数据的完整性
        try {
            //当视图改变“sm3hmac”列的值时，将导致整个解密过程异常
            //result_encryptMapWithSm3hmac.put("sm3hmac", "试图篡改该值，将导致整个解密过程发生异常");
            Map<String, String> result_decryptMapAndVerifySm3hmac = clr.decryptMapAndVerifySm3hmac(result_encryptMapWithSm3hmac);
            System.out.println("decryptMapAndVerifySm3hmac 解密结果：");
            result_decryptMapAndVerifySm3hmac.forEach((key, value) -> {
                System.out.println("key：" + key + " value：" + value);
            });
        } catch (KMSException ex) {
            System.out.println(ex.getMessage());
        }
        //对一个数据计算HMAC，通常用于只保证数据完整性，不需要保证机密性的场景
        byte[] data = "张三昨天消费了200元".getBytes(StandardCharsets.UTF_8);
        System.out.println("对信息计算sm3hmac：" + clr.sm3HMAC(data, outputFormat));
        //对一组数据或表中一行数据计算HMAC，通常用于只保证数据完整性，不需要保证机密性的场景
        Map<String, String> rawData_new = new HashMap<>();
        rawData_new.put("id", Base64NoCR.encodeToStr("10293838".getBytes(StandardCharsets.UTF_8)));
        rawData_new.put("userid", Base64NoCR.encodeToStr("98374653654".getBytes(StandardCharsets.UTF_8)));
        rawData_new.put("amount", Base64NoCR.encodeToStr("237.00".getBytes(StandardCharsets.UTF_8)));
        rawData_new.put("desc", Base64NoCR.encodeToStr("这是一行订单信息".getBytes(StandardCharsets.UTF_8)));
        System.out.println("对Map计算sm3hmac：" + clr.sm3HMAC(rawData_new, outputFormat));
    
        //fpedemo, 对手机号码的中间4位进行格式保留加密
        System.out.println("fpe加密测试");
        String mobile = "18012344321";
        List<SimkeyFpeAlphabet> simkeyFpeAlphabets = new ArrayList<>();
        simkeyFpeAlphabets.add(SimkeyFpeAlphabet.Numeric);
        String fpePlain = mobile.substring(3, 7);
        byte[] tweak = mobile.substring(7).getBytes(StandardCharsets.UTF_8);
        String fpeEnc = clr.fpeEncrypt(simkeyFpeAlphabets, tweak, fpePlain);
        System.out.println(fpePlain + " fpe加密结果:" + fpeEnc);//1234 fpe加密结果:3757
        String mobileEnc = mobile.substring(0, 3) + fpeEnc + mobile.substring(7);
        //手机号码: 18012344321 fpe加密后重组为:18037574321
        System.out.println("手机号码: " + mobile + " fpe加密后重组为:" + mobileEnc);
    
        String fpeDec = clr.fpeDecrypt(simkeyFpeAlphabets, tweak, fpeEnc);
        System.out.println(fpeEnc + " fpe解密结果:" + fpeDec);//3757 fpe解密结果:1234
        //手机号码: 18037574321 fpe解密后重组为:18012344321
        System.out.println("手机号码: " + mobileEnc + " fpe解密后重组为:" + mobile.substring(0, 3) + fpeDec + mobile.substring(7));
        if (!TextUtils.equals(fpePlain, fpeDec)) {
            System.err.println("FPE 解密结果不正确!!!!!!!!!!!");
        } else {
            System.out.println("fpe测试成功");
        }
        //FPE测试结束
    
        //测试 sm4 gcm 加解密, 适用于数据加密传输
        System.out.println("测试SM4 GCM加解密功能");
        byte[] sm4gcmTestData = "1234567812345678123456781234567812345678123456781234567812".getBytes();
        byte[] iv = HexStringConvert.parseHexStr2Byte("11223344556677881122334455667788");//16字节iv
        byte[] aad = "simkey".getBytes();
        String sm4gcmEnc = clr.sm4GcmEncrypt(sm4gcmTestData, iv, aad);
        System.out.println("SM4 GCM 原文.Hex:" + HexStringConvert.parseByte2HexStr(sm4gcmTestData));
        System.out.println("SM4 GCM 密文.BASE64:" + sm4gcmEnc);
        System.out.println("SM4 GCM 密文.Hex:" + HexStringConvert.parseByte2HexStr(Base64NoCR.decode(sm4gcmEnc)));
        byte[] sm4gcmDec = clr.sm4GcmDecrypt(sm4gcmEnc, iv, aad);
        System.out.println("SM4 GCM 解密.Hex:" + HexStringConvert.parseByte2HexStr(sm4gcmDec));
        if (!Arrays.equals(sm4gcmTestData, sm4gcmDec)) {
            System.err.println("SM4 GCM解密结果不正确!!!!!!!!!!!");
        } else {
            System.out.println("SM4 GCM解密结果正确");
        }
        
        //文件加解密
        try {
            System.out.println("使用用户密钥加密文件");
            String prefix = ".dll";
            if (OSUtil.isLinux()) {
                prefix = ".so";
            }
            //对一个文件进行加密
            File file = new File(ApplicationUtil.getJarFilePath() + File.separator + "libSimkeySDFClient" + prefix);
            System.out.println("被加密的原始文件→" + file.getPath());
            File file_En = new File(file.getParent() + File.separator + "libSimkeySDFClient" + prefix + ".encrypted");
            clr.encryptFile(file, file_En);
            System.out.println("被加密后的文件→" + file_En.getPath());
            //对一个文件进行解密
            File file_De = new File(file.getParent() + File.separator + "libSimkeySDFClient" + prefix + ".decrypted");
            System.out.println("被解密后的文件→" + file_De.getPath());
            clr.decryptFile(file_En, file_De);
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        
        /**
         * 重新保护用户密钥
         * 用户密钥受到业务密钥的保护，所以业务系统得到的用户密钥是被业务密钥加密过的密文，“重新保护用户密钥”是指把一个密文的用户密钥使用另一个业务密钥重新加密保护，
         * 通常使用在定期更换业务密钥的场景下，如，出于安全考虑，通过生成新的业务密钥来完成业务密钥更新时，就需要把使用旧业务密钥保护过的用户密钥重新使用新业务密钥
         * 重新保护，但用户密钥的实质并没有变化，只是更换了保护的外壳，且用户密钥ID也保持不变。
         */
        KMSBizKey kmsBizKey = kmsClient.genBizKey();
        System.out.println("重新申请了业务密钥, EncKeyId:" + kmsBizKey.getEncKeyId() + " HmacKeyId:" + kmsBizKey.getHmacKeyId() + " , 下面对用户密钥进行重新保护");
        ClientRemoteEncryption cre_new = kmsClient.useBizkeyRemoteEncryption(kmsBizKey.getEncKeyId(), kmsBizKey.getHmacKeyId());
        String new_userEncKey = cre_new.reProtectUserKey(userKey.getEncKey());
        //验证旧用户密钥加密的内容，新用户密钥能否解开
        data = "张三的家庭成员信息是：目前单身".getBytes(StandardCharsets.UTF_8);
        //加密，业务系统应维护加密后得到得密文和所使用的用户密钥的对应关系
        String output = clr.encryptBytes2Str(data, outputFormat);
        System.out.println("加密结果：" + output);
        //解密
        clr = kmsClient.useUserkeyLocalSoftEncryption(userKey.getEncKeyId(), new_userEncKey, null, null);
        data = clr.decryptStr2Bytes(output);
        System.out.println("解密结果：" + new String(data, StandardCharsets.UTF_8));
    }
}
