package com.ai.ble.base.encrypt;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Base64Utils {
    private static final String ENCODING = "UTF-8";

    public static String getBASE64(String s) throws UnsupportedEncodingException {
        if (s == null)
            return null;
        return getBase64NoCR(s.getBytes(ENCODING));

    }
    public static String getBASE64(byte[] s) {
        if (s == null)
            return null;
        return getBase64NoCR(s);
    }

    /*
     * base64,去掉换行符等空字符
     */
    public static String getBase64NoCR(byte[] s) {
        if (s == null)
            return null;
        String cipherText = new String(Base64.encode(s));
        if (cipherText != null && cipherText.trim().length() > 0) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(cipherText);
            cipherText = m.replaceAll("");
        }
        return cipherText;
    }

    /**
     * base64 字符串转byte[]
     * @param s
     * @return
     */
    public static byte[] getByteArrFromBase64(String s){
        if (s == null || s.trim().length() == 0)
            return null;
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(s);
        s = m.replaceAll("");
        return Base64.decode(s);
    }


}
