package com.ai.ble.base.encrypt;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

/**
 * 摘要算法的实现
 *
 * @author zouning
 * @time 2014-11-19 下午5:31:46
 */

public final class HashUtils {
    /** 记录日志 */

    private static final String ENCODING = "UTF-8";

    public static byte[] getDigestBytes(byte[] content, String algorithm) throws NoSuchAlgorithmException {
        if ("sm3".equalsIgnoreCase(algorithm)) {
            SM3Digest sm3Digest = new SM3Digest();
            return sm3Digest.hash(content);
        } else {
            MessageDigest md5 = MessageDigest.getInstance(algorithm);
            return md5.digest(content);
        }


    }

    /**
     * 获取hash值
     *
     * @param content
     * @return md5摘要信息 返回空字符串""如果发生异常
     */
    public static String getDigest(byte[] content, String algorithm) throws NoSuchAlgorithmException {
        return parseByte2HexStr(getDigestBytes(content, algorithm));

    }

    public static String getDigest(String content, String algorithm) throws UnsupportedEncodingException,
            NoSuchAlgorithmException {
        return getDigest(content.getBytes(ENCODING), algorithm);

    }

    public static String getSHA1Digest(String content) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return getDigest(content, "SHA1");
    }

    private static String parseByte2HexStr(byte buf[]) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buf.length; i++) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase(Locale.getDefault()));
        }
        return sb.toString();
    }

    // public static void main(String[] args) throws Exception {
    // String hashString = "3031300d060960864801650304020105000420";
    // String hashString = "abc";
    //
    // getDigest(hashString, "MD2");
    // getDigest(hashString, "MD5");
    // getDigest(hashString, "SHA");
    // getDigest(hashString, "SHA1");
    // getDigest(hashString, "SHA-224");
    // getDigest(hashString, "SHA-256");
    // getDigest(hashString, "SHA-384");
    // getDigest(hashString, "SHA-512");
    // getDigest(hashString, "SHA-512/224");
    // getDigest(hashString, "SHA-512/256");
    // getDigest(hashString, "SHA-512_256");

    // System.out.println(getSHA1Digest("中文123@"));
    //
    // }
}
