package com.ai.ble.base.encrypt;

import com.ai.ble.base.util.HexStringConvert;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * @author zouning
 * @time 2016-4-7 下午3:16:50
 *
 */

public class SM4Utils {
    private static final String ENCODING = "UTF-8";
    private static final String CBC_IV = "92F326B9F1DDB7F55BB29460E4AD27DA";
//    private static final String CBC_BLE_IV = "00000000000000000000000000000000";

//**************************CBC模式*********************************
    /**
     * sm4 cbc 字符串加密
     *
     * @param plainText  汉字或者ascii 格式
     * @param key hexString
     * @return 返回 base64密文
     */
    public static String encryptData_CBC(String plainText, String key) throws Exception {
        SM4Context ctx = new SM4Context();
        ctx.isPadding = true;
        ctx.mode = SM4.SM4_ENCRYPT;

        byte[] keyBytes = HexStringConvert.parseHexStr2Byte(key);
        byte[] ivBytes = HexStringConvert.parseHexStr2Byte(CBC_IV);

        SM4 sm4 = new SM4();
        sm4.sm4_setkey_enc(ctx, keyBytes);
        byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes,
                plainText.getBytes(ENCODING));
        String cipherText =  Base64Utils.getBASE64(encrypted);
        if (cipherText != null && cipherText.trim().length() > 0) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(cipherText);
            cipherText = m.replaceAll("");
        }
        return cipherText;

    }

    /**
     * sm4 cbc 字符串解密
     *
     * @param cipherText base64密文
     * @param key  hexString
     * @return 汉字或者ascii 格式
     */
    public static String decryptData_CBC(String cipherText, String key) throws Exception {
        SM4Context ctx = new SM4Context();
        ctx.isPadding = true;
        ctx.mode = SM4.SM4_DECRYPT;

        byte[] keyBytes = HexStringConvert.parseHexStr2Byte(key);
        byte[] ivBytes = HexStringConvert.parseHexStr2Byte(CBC_IV);

        SM4 sm4 = new SM4();
        sm4.sm4_setkey_dec(ctx, keyBytes);
        byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes,
                Base64Utils.getByteArrFromBase64(cipherText));
        return new String(decrypted, ENCODING);

    }
    /**
     * sm4 cbc 字符串解密
     *
     * @param cipherText
     * @param keyBytes
     * @return
     */
    public static byte[] decryptData_CBC(byte[] cipherText, byte[] keyBytes) throws Exception{
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = SM4.SM4_DECRYPT;

            byte[] ivBytes = HexStringConvert.parseHexStr2Byte(CBC_IV);
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            return sm4.sm4_crypt_cbc(ctx, ivBytes, cipherText);
    }
    /**
     * sm4 cbc 字符串加密
     *
     * @param plainText
     * @param keyBytes
     * @return
     */
    public static byte[] encryptData_CBC(byte[] plainText, byte[] keyBytes) throws Exception {
        SM4Context ctx = new SM4Context();
        ctx.isPadding = true;
        ctx.mode = SM4.SM4_ENCRYPT;
        byte[] ivBytes = HexStringConvert.parseHexStr2Byte(CBC_IV);

        SM4 sm4 = new SM4();
        sm4.sm4_setkey_enc(ctx, keyBytes);
        return sm4.sm4_crypt_cbc(ctx, ivBytes, plainText);

    }

    /**
     * sm4 cbc 字符串加密
     * 返回URLencode编码加密数据
     * @param plainText
     * @param key
     * @return
     */
    public static String encryptData_CBC_ENCODE(String plainText, String key) throws Exception {
        SM4Context ctx = new SM4Context();
        ctx.isPadding = true;
        ctx.mode = SM4.SM4_ENCRYPT;

        byte[] keyBytes = HexStringConvert.parseHexStr2Byte(key);
        byte[] ivBytes = HexStringConvert.parseHexStr2Byte(CBC_IV);

        SM4 sm4 = new SM4();
        sm4.sm4_setkey_enc(ctx, keyBytes);
        byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes,
                plainText.getBytes(ENCODING));
        String cipherText =  Base64Utils.getBASE64(encrypted);
        if (cipherText != null && cipherText.trim().length() > 0) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(cipherText);
            cipherText = m.replaceAll("");
        }
        return URLEncoder.encode(cipherText, ENCODING);

    }
    /**
     * sm4 cbc 字符串解密
     *
     * @param cipherText
     * @param key
     * @return
     */
    public static String decryptData_CBC_DECODE(String cipherText, String key) throws Exception {
        cipherText = URLDecoder.decode(cipherText, ENCODING);
        SM4Context ctx = new SM4Context();
        ctx.isPadding = true;
        ctx.mode = SM4.SM4_DECRYPT;

        byte[] keyBytes = HexStringConvert.parseHexStr2Byte(key);
        byte[] ivBytes = HexStringConvert.parseHexStr2Byte(CBC_IV);

        SM4 sm4 = new SM4();
        sm4.sm4_setkey_dec(ctx, keyBytes);
        byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes,
                Base64Utils.getByteArrFromBase64(cipherText));
        return new String(decrypted, ENCODING);
    }

//**************************CBC模式*********************************

    /*
     * 国密算法计算签名值,sm3之后做sm4,然后base64返回 .base64(sm4(sm3(data)))
     *
     * @param data
     *
     * @param key
     *
     * @return
     */
    public static String getSm3WithSM4Base64(String data, String key) throws Exception {

        byte[] dataBytes = data.getBytes(ENCODING);
        byte[] hash = HashUtils.getDigestBytes(dataBytes, "sm3");
        // 计算sm4,cbc
        SM4Context ctx = new SM4Context();
        ctx.isPadding = true;
        ctx.mode = SM4.SM4_ENCRYPT;
        byte[] keyBytes = HexStringConvert.parseHexStr2Byte(key);
        byte[] ivBytes = HexStringConvert.parseHexStr2Byte(CBC_IV);
        SM4 sm4 = new SM4();
        sm4.sm4_setkey_enc(ctx, keyBytes);
        byte[] sm3WithSM4 = sm4.sm4_crypt_cbc(ctx, ivBytes, hash);
        return Base64Utils.getBase64NoCR(sm3WithSM4);

    }
    /*
     * ctpass  算法计算签名值,sha1之后做sm4,然后base64返回 .base64(sm4(sha1(data)))
     *
     * @param data
     *
     * @param key
     *
     * @return
     */
    public static String getSha1WithSM4Base64(String data, String key) throws Exception {
            byte[] dataBytes = data.getBytes(ENCODING);
            byte[] sha1 = HashUtils.getDigestBytes(dataBytes, "SHA1");
            // 计算sm4,cbc
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = SM4.SM4_ENCRYPT;
            byte[] keyBytes = HexStringConvert.parseHexStr2Byte(key);
            byte[] ivBytes = HexStringConvert.parseHexStr2Byte(CBC_IV);
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] sha1WithSM4 = sm4.sm4_crypt_cbc(ctx, ivBytes, sha1);
            return Base64Utils.getBase64NoCR(sha1WithSM4);

    }

//**************************ECB模式*********************************

    /**
     * sm4 ECB 字符串加密
     *
     * @param plainText
     * @param keyBytes
     * @return
     */
    public static byte[] encryptData_ECB(byte[] plainText, byte[] keyBytes,boolean isPadding) throws Exception {
            SM4Context ctx = new SM4Context();
            ctx.isPadding = isPadding;
            ctx.mode = SM4.SM4_ENCRYPT;

            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            return sm4.sm4_crypt_ecb(ctx, plainText);

    }

    /***sm4 ECB 字符串解密
     *
     * @param cipherText
     * @param key
     * @return
     */
    public static byte[] decryptData_ECB(byte[] cipherText, byte[] key,boolean isPadding) throws Exception {
        SM4Context ctx = new SM4Context();
        ctx.isPadding = isPadding;
        ctx.mode = SM4.SM4_DECRYPT;

        byte[] keyBytes = key;

        SM4 sm4 = new SM4();
        sm4.sm4_setkey_dec(ctx, keyBytes);
        byte[] decrypted = sm4.sm4_crypt_ecb(ctx,cipherText);
        return decrypted;

    }
    /**
     * sm4 ECB 字符串加密
     *
     * @param plainText
     * @param keyBytes
     * @return
     */
    public static String encryptData_ECB(String plainText, String keyBytes,boolean isPadding) throws Exception {
        SM4Context ctx = new SM4Context();
        ctx.isPadding = isPadding;
        ctx.mode = SM4.SM4_ENCRYPT;
        byte[] key = HexStringConvert.parseHexStr2Byte(keyBytes);
        SM4 sm4 = new SM4();
        sm4.sm4_setkey_enc(ctx, key);
        byte[] encrypted = sm4.sm4_crypt_ecb(ctx, plainText.getBytes(ENCODING));
        String cipherText =  Base64Utils.getBASE64(encrypted);

        if (cipherText != null && cipherText.trim().length() > 0) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(cipherText);
            cipherText = m.replaceAll("");
        }
        return cipherText;

    }


    /***sm4 ECB 字符串解密
     *
     * @param cipherText
     * @param key
     * @return
     */
    public static String decryptData_ECB(String cipherText, String key,boolean isPadding) throws Exception {
        SM4Context ctx = new SM4Context();
        ctx.isPadding = isPadding;
        ctx.mode = SM4.SM4_DECRYPT;

        byte[] keyBytes = HexStringConvert.parseHexStr2Byte(key);

        SM4 sm4 = new SM4();
        sm4.sm4_setkey_dec(ctx, keyBytes);
        byte[] decrypted = sm4.sm4_crypt_ecb(ctx,Base64Utils.getByteArrFromBase64(cipherText));
        return new String(decrypted, ENCODING);

    }




    /**
     * sm4 ECB 字符串加密 得到 URLEncode后的
     *
     * @param plainText
     * @param key
     * @return
     */
    public static String encryptData_ECB_ENCODE(String plainText, String key,boolean isPadding) throws Exception {
        SM4Context ctx = new SM4Context();
        ctx.isPadding = isPadding;
        ctx.mode = SM4.SM4_ENCRYPT;
        SM4 sm4 = new SM4();
        byte[] keyBytes = HexStringConvert.parseHexStr2Byte(key);
        sm4.sm4_setkey_enc(ctx, keyBytes);

        byte[] encrypted = sm4.sm4_crypt_ecb(ctx, plainText.getBytes(ENCODING));
        String cipherText =  Base64Utils.getBASE64(encrypted);

        if (cipherText != null && cipherText.trim().length() > 0) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(cipherText);
            cipherText = m.replaceAll("");
        }
        return URLEncoder.encode(cipherText, ENCODING);

    }


    /***sm4 ECB 字符串解密 传入 URLEncode后的数据
     *
     * @param cipherText
     * @param key
     * @return
     */
    public static String decryptData_ECB_DECODE(String cipherText, String key,boolean isPadding) throws Exception {
        cipherText = URLDecoder.decode(cipherText,ENCODING);
        byte[] keyBytes = HexStringConvert.parseHexStr2Byte(key);

        SM4Context ctx = new SM4Context();
        ctx.isPadding = isPadding;
        ctx.mode = SM4.SM4_DECRYPT;

        SM4 sm4 = new SM4();
        sm4.sm4_setkey_dec(ctx, keyBytes);
        byte[] decrypted = sm4.sm4_crypt_ecb(ctx,Base64Utils.getByteArrFromBase64(cipherText));
        return new String(decrypted, ENCODING);

    }


//*************************ECB模式********************************8

    public static String genSM4Key() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] key = new byte[16];
        secureRandom.nextBytes(key);
        return HexStringConvert.parseByte2HexStr(key);
    }


}
