package com.ai.ble.base.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Map;

import javax.net.ssl.SSLException;

import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;


/**
 */
public abstract class RestClientBase {

	protected String baseHost = null;
	private static Logger logger = LogManager.getLogger(LogManager.ROOT_LOGGER_NAME);
	private static PoolingHttpClientConnectionManager cm = null;
	public String getBaseHost() {
		return baseHost;
	}

	public void setBaseHost(String baseHost) {
		this.baseHost = baseHost;
	}

	protected void setURI(HttpRequestBase requestBase, String requestURI) throws URISyntaxException {
		String uri;
		if (this.getBaseHost() != null) {
			uri = this.getBaseHost() + requestURI;
		} else {
			uri = requestURI;
		}
		requestBase.setURI(new URI(uri));
	}

	protected void initHttpHeader(HttpRequestBase requestBase, Map<String, String> headerParam) {
		if (headerParam != null) {
			for (Map.Entry<String, String> entry : headerParam.entrySet()) {
				requestBase.addHeader(entry.getKey(), entry.getValue());
			}
		}
	}

	protected String getResponse( HttpRequestBase requestBase) {
		CloseableHttpResponse response = null;
		try {
			// 以下是老版本的做法
			// DefaultHttpClient client = new DefaultHttpClient();
			// HttpResponse response = client.execute(requestBase);

			// 以下httpclient 4.3的官方指南修改
			CloseableHttpClient httpClient = HttpClients
					.custom()
					.setConnectionManager(
							getPoolingHttpClientConnectionManager())
					.setRetryHandler(myRetryHandler).build();

			RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(15000).setSocketTimeout(15000).build();
			requestBase.setConfig(requestConfig);
			response = httpClient.execute(requestBase);
			HttpEntity entity = response.getEntity();
			if (entity != null) {
				return EntityUtils.toString(entity, "UTF-8");
			}
		} catch (Exception e) {
			e.printStackTrace();
			System.err.println("Http request failed on "
					+ requestBase.getURI().toString());
		} finally {
			try {
				response.close();
			} catch (Exception e) {
				e.printStackTrace();
			}

		}
		return null;
	}
	private static PoolingHttpClientConnectionManager getPoolingHttpClientConnectionManager() {
		if (cm != null) {
			return cm;
		}

		cm = new PoolingHttpClientConnectionManager();
		// Increase max total connection to 200
		cm.setMaxTotal(200);
		// Increase default max connection per route to 20
		cm.setDefaultMaxPerRoute(40);// 官方值20,但我们的系统出口的地址不多,就40吧
		// Increase max connections for localhost:80 to 50
		HttpHost localhost = new HttpHost("locahost", 80);
		cm.setMaxPerRoute(new HttpRoute(localhost), 50);

		return cm;
	}
	/***
	 * 重试策略
	 */
	private HttpRequestRetryHandler myRetryHandler = new HttpRequestRetryHandler() {

		public boolean retryRequest(IOException exception, int executionCount,
				HttpContext context) {
			if (executionCount >= 5) {
				// Do not retry if over max retry count
				return false;
			}
			if (exception instanceof InterruptedIOException) {
				// Timeout
				return false;
			}
			if (exception instanceof UnknownHostException) {
				// Unknown host
				return false;
			}
			if (exception instanceof ConnectTimeoutException) {
				// Connection refused
				return false;
			}
			if (exception instanceof SSLException) {
				// SSL handshake exception
				return false;
			}
			HttpClientContext clientContext = HttpClientContext.adapt(context);
			HttpRequest request = clientContext.getRequest();
			boolean idempotent = !(request instanceof HttpEntityEnclosingRequest);
			if (idempotent) {
				// Retry if the request is considered idempotent
				return true;
			}
			return false;
		}

	};
	protected InputStream getResponseInput(HttpRequestBase requestBase) {
		CloseableHttpResponse response = null;
		try {
			// 以下是老版本的做法
			// DefaultHttpClient client = new DefaultHttpClient();
			// HttpResponse response = client.execute(requestBase);

			// 以下httpclient 4.3的官方指南修改
			CloseableHttpClient httpClient = HttpClients
					.custom()
					.setConnectionManager(
							getPoolingHttpClientConnectionManager())
					.setRetryHandler(myRetryHandler).build();

			response = httpClient.execute(requestBase);
			logger.error("getResponseInput response: "+response);
		// response.getEntity().getContent()
		HttpEntity entity = response.getEntity();
		if (entity != null) {
			return entity.getContent();
		}
	} catch (IOException e) {
		e.printStackTrace();
		System.err.println("Http request failed on "
				+ requestBase.getURI().toString());
	}
	return null;
}
}
