package com.ai.ble.base.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * 实现HTTPClient的调用封装，更便于调用本base模式下的POST接口
 */
public class RestPostClient extends RestClientBase {
	private static RestPostClient client = new RestPostClient();
	private static Logger logger = LogManager.getLogger(LogManager.ROOT_LOGGER_NAME);
	private RestPostClient(){

	}

	/**
	 * 带请求头的rest  json请求服务
	 * @param requestURI
	 * @param headerParam
	 * @param jsonString
	 * @return
	 */
	public String callRestRPCHeadJson(String requestURI,
									  Map<String, String> headerParam,String jsonString) {
		HttpPost httpPost = new HttpPost();
		StringBuilder sbr=new StringBuilder();
		try{
			setURI(httpPost, requestURI);
			initHttpHeader(httpPost, headerParam);
			StringEntity se = new StringEntity(jsonString, "utf-8");
			se.setContentEncoding("UTF-8");
			se.setContentType("application/json");
			httpPost.setEntity(se);
			InputStream in=getResponseInput(httpPost);
			InputStreamReader inputStreamReader = new InputStreamReader(in,"UTF-8");
			BufferedReader reader = new BufferedReader(inputStreamReader);// 读字符串用的。
			String s;
			while (((s = reader.readLine()) != null)) {
				sbr.append(s);
			}
			reader.close();// 关闭输入流
		}catch (URISyntaxException e) {
			e.printStackTrace();
		}catch(IOException e){
			e.printStackTrace();
		}
		return sbr.toString();

	}

	public static RestPostClient get(){
		return client;
	}
	public String callRestRPC(String requestURI,
			Map<String, String> headerParam, Map<String, String> postParam) {
		try {
			HttpPost httpPost = new HttpPost();

			setURI(httpPost, requestURI);

			initHttpHeader(httpPost, headerParam);

			if (postParam != null) {
				List<NameValuePair> params = new ArrayList<NameValuePair>();
				for (Map.Entry<String, String> entry : postParam.entrySet()) {
					params.add(new BasicNameValuePair(entry.getKey(), entry
							.getValue()));
				}
				HttpEntity entity = new UrlEncodedFormEntity(params, "utf-8");
				httpPost.setEntity(entity);
			}
			System.out.println(EntityUtils.toString(httpPost.getEntity()));
			return getResponse(httpPost);
		} catch (URISyntaxException e) {
			e.printStackTrace();
			System.err.println("Error request uri: " + requestURI);
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			System.err.println("Error request param on :  " + requestURI);
		} catch (ParseException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}

	public String callRestRPC(String requestURI, Map<String, String> postParam) {
		try {
			HttpPost httpPost = new HttpPost();

			setURI(httpPost, requestURI);

			if (postParam != null) {
				List<NameValuePair> params = new ArrayList<NameValuePair>();
				for (Map.Entry<String, String> entry : postParam.entrySet()) {
					params.add(new BasicNameValuePair(entry.getKey(), entry
							.getValue()));
				}
				HttpEntity entity = new UrlEncodedFormEntity(params, "utf-8");
				httpPost.setEntity(entity);
			}
			System.out.println(EntityUtils.toString(httpPost.getEntity()));
			return getResponse(httpPost);
		} catch (URISyntaxException e) {
			e.printStackTrace();
			System.err.println("Error request uri: " + requestURI);
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			System.err.println("Error request param on :  " + requestURI);
		} catch (ParseException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}

	public String callRestRPCJson(String requestURI,String jsonstring) {
		HttpPost httpPost = new HttpPost();
		StringBuilder sbr=new StringBuilder();
		try{
			    setURI(httpPost, requestURI);
	            StringEntity se = new StringEntity(jsonstring, "utf-8");
	            se.setContentEncoding("UTF-8");
	            se.setContentType("application/json");
	            httpPost.setEntity(se);
	            InputStream in=getResponseInput(httpPost);
	            InputStreamReader inputStreamReader = new InputStreamReader(in,"UTF-8");
	            BufferedReader reader = new BufferedReader(inputStreamReader);// 读字符串用的。
	                String s;
	                while (((s = reader.readLine()) != null)) {
	                	sbr.append(s);
	                }
	                reader.close();// 关闭输入流
	                }catch (URISyntaxException e) {
	                	e.printStackTrace();
	                }catch(IOException e){
	                	e.printStackTrace();
	                }
		   return sbr.toString();

	    }
	/**增加json 格式调用 soap，替代商务领航老的请求方式
	 *
	 * @param requestURI
	 * @param jsonstring
	 * @param headerParam
	 * @return
	 */
	public String callRestRPCSoap(String requestURI,String jsonstring,Map<String, String> headerParam) {
		HttpPost httpPost = new HttpPost();
		StringBuilder sbr=new StringBuilder();
		try {
			setURI(httpPost, requestURI);
			initHttpHeader(httpPost, headerParam);
			StringEntity se = new StringEntity(jsonstring, "utf-8");
			se.setContentEncoding("UTF-8");
			se.setContentType("application/json");
			httpPost.setEntity(se);
			InputStream in = getResponseInput(httpPost);
			InputStreamReader inputStreamReader = new InputStreamReader(in, "UTF-8");
			BufferedReader reader = new BufferedReader(inputStreamReader);// 读字符串用的。
			String s;
			while (((s = reader.readLine()) != null)) {
				sbr.append(s);
			}
			reader.close();// 关闭输入流
		}catch (URISyntaxException e) {
	                	e.printStackTrace();
	                }catch(IOException e){
	                	e.printStackTrace();
	                }
		   return sbr.toString();

	    }

	public String callRestRPCXML(String requestURI, String xmlString) {
		HttpPost httpPost = new HttpPost();
		StringBuilder sbr = new StringBuilder();
		try {
			setURI(httpPost, requestURI);
			StringEntity se = new StringEntity(xmlString, "utf-8");
			se.setContentEncoding("UTF-8");
			se.setContentType("application/soap+xml");
			httpPost.setEntity(se);
			InputStream in = getResponseInput(httpPost);
			InputStreamReader inputStreamReader = new InputStreamReader(in, "UTF-8");
			BufferedReader reader = new BufferedReader(inputStreamReader);// 读字符串用的。
			String s;
			while (((s = reader.readLine()) != null)) {
				sbr.append(s);
			}
			reader.close();// 关闭输入流
		} catch (URISyntaxException e) {
			logger.error(e.getMessage(),e);
		} catch (IOException e) {
			logger.error(e.getMessage(),e);
		}
		return sbr.toString();

	}
}
