package com.ai.ble.base.util;

import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;


/**
 * 需要 commons-beanutils 1.9.3
 */
public final class ConfigUtils {
	private static final Logger log = LoggerFactory.getLogger(ConfigUtils.class);
	private static PropertiesConfiguration config = new PropertiesConfiguration();

	static {
		Configurations configs = new Configurations();
		// setDefaultEncoding 是个静态方法, 用于设置指定类型(class)所有对象的编码方式。
		// 本例中是 PropertiesConfiguration,要在PropertiesConfiguration实例创建之前调用。
		FileBasedConfigurationBuilder.setDefaultEncoding(PropertiesConfiguration.class, "UTF-8");
		try {
			config = configs.properties("app.properties");
		} catch (ConfigurationException e) {
			log.error("Init Configuration Error", e);
		}
	}

	public static boolean containsKey(final String key) {
		return config.containsKey(key);
	}

	public static Iterator<String> getKeys() {
		return config.getKeys();
	}

	public static Object getProperty(String key) {
		return config.getProperty(key);
	}

	public static boolean getBoolean(String key) {
		return config.getBoolean(key);
	}

	public static int getInt(final String key) {
		return config.getInt(key);
	}

	public static int getIntValue(final String key) {
		return config.getInt(key);
	}

	public static long getLong(final String key) {
		return config.getLong(key);
	}

	public static long getLongValue(final String key) {
		return config.getLong(key);
	}

	public static double getDouble(final String key) {
		return config.getDouble(key);
	}

	public static double getDoubleValue(final String key) {
		return config.getDouble(key);
	}

	public static BigDecimal getBigDecimal(String key) {
		return config.getBigDecimal(key);
	}

	public static BigInteger getBigInteger(String key) {
		return config.getBigInteger(key);
	}

	public static String getStringValue(String key) {
		return config.getString(key);
	}

	public static String[] getStringArray(String key) {
		return config.getStringArray(key);
	}

	public static List<Object> getList(String key) {
		return config.getList(key);
	}
	public static void main(String[] args){
		System.out.println(getStringValue("token"));
	}
}
