package com.ai.ble.base.util;



/**
 * 十六进制与字符串之间转换
 *
 * @author zouning
 * @time 2015-5-20 下午3:35:46
 *
 */

public class HexStringConvert {
	/**
	 * 将二进制转换成16进制
	 *
	 * @param buf
	 * @return
	 */
	public static String parseByte2HexStr(final byte buf[]) {
		return parseByte2HexStrWithSplit(buf, "");
	}

	/**
	 * 二进制转换成16进制支付
	 *
	 * @param buf
	 * @return
	 */
	public static String parseByte2HexStr(final byte buf) {
		try {
			StringBuffer sb = new StringBuffer();
			String hex = Integer.toHexString(buf & 0xFF);
			if (hex.length() == 1) {
				hex = '0' + hex;
			}
			sb.append(hex.toUpperCase());
			return sb.toString();
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		}
	}

	/**
	 * 将16进制转换为二进制
	 *
	 * @param hexStr
	 * @return
	 */
	public static byte[] parseHexStr2Byte(final String hexStr) {
		try {
			if (hexStr.length() < 1)
				return null;
			byte[] result = new byte[hexStr.length() / 2];
			for (int i = 0; i < hexStr.length() / 2; i++) {
				int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
				int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
				result[i] = (byte) (high * 16 + low);
			}
			return result;
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	/**
	 * 转为16进制字符,中间用空格分开,友好的显示
	 *
	 * @param buf
	 * @return
	 */
	public static String parseByte2HexStrWithSplit(final byte buf[], final String split) {
		String s = split;
		if (split == null) {
			s = "";
		}
		try {
			StringBuffer sb = new StringBuffer();
			for (int i = 0; i < buf.length; i++) {
				String hex = Integer.toHexString(buf[i] & 0xFF);
				if (hex.length() == 1) {
					hex = '0' + hex;
				}
				if (i != 0) {
					sb.append(s);
				}
				sb.append(hex);
			}
			return sb.toString().toUpperCase();
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		}

	}
}
