package com.ai.ble.demo;

import com.ai.ble.base.encrypt.SM4Utils;
import com.ai.ble.base.rest.RestPostClient;
import com.ai.ble.base.util.ConfigUtils;
import com.ai.ble.base.util.JsonUtil;
import com.ai.ble.base.util.TimestampUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

import java.util.Iterator;
import java.util.Map;

/**
 * 重置PIN接口
 * @author yfmei
 * 2019/12/16
 */
public class ResetPin {

    private static final String APP_ID = "1010000000000128";
    private static final String APP_SECRET = "A10941D6ABB57F0FE051D7E640DA722A";
    private static final String IP_PREFIX = "ble.interface.url";
    private static final String INTERFACE_URL = "/third/pin/resetUserPin";

    /**
     * appId 错误对应的错误码
     */
    public static final int EXCLUDE_CODE = 214;

    public static void call(){

        // 测试数据
        String userName = "demo";
        String phoneNumber = "158****4378";
        String idType = "10";
        String idCode = "34122xxxxxxxxxxxxx";

        ObjectNode param = new ObjectMapper().createObjectNode();

        // 组装参数
        param.put("userName",  userName);
        param.put("phoneNumber",  phoneNumber);
        param.put("idType",  idType);
        param.put("idCode",  idCode);

        // 对参数进行签名和加密
        String requestInfo = signDataInfo(param, APP_ID, APP_SECRET);

        try {
            // 发起请求
            String response = RestPostClient.get().callRestRPCJson(ConfigUtils.getStringValue(IP_PREFIX) + INTERFACE_URL, requestInfo);
            System.out.println("response :" + response);
            if(response == null) {
                System.out.println("调用失败");
            } else {
                try {
                    JsonNode resNode = JsonUtil.parse(response);
                    int statusCode = resNode.findPath("statusCode").asInt();
                    // 获取返回信息
                    String returnObj;
                    if (EXCLUDE_CODE == statusCode) {
                        // code: 214 返回结果没有被加密
                        returnObj = resNode.findPath("returnObj").asText();
                    } else {
                        // 解密返回结果
                        returnObj = SM4Utils.decryptData_CBC_DECODE(resNode.findPath("returnObj").asText(), APP_SECRET);
                        // 获取具体信息
                        JsonNode returnObjNode = JsonUtil.parse(returnObj);
                        returnObj = returnObjNode.findPath("resultDesc").asText();
                    }

                    System.out.println("statusCode :" + statusCode);
                    System.out.println("resultDesc :" + returnObj);
                }catch(Exception e1) {
                    System.out.println("解析返回结果异常：原文：" + response + "；异常信息为：" + e1.getMessage());
                }
            }
        } catch(Exception e){
            System.out.println("验签失败："+e.getMessage());
        }

    }

    /**
     * 封装签名和加密方法
     * @param param
     * @param appKey
     * @return
     * @throws Exception
     */
    public static String signDataInfo(ObjectNode param,String appId, String appKey) {
        // 开始组装调用参数
        ObjectMapper om = new ObjectMapper();

        String timestamp = TimestampUtil.getTimeStampYYYYMMDDHHMMSS();
        param.put("appId", appId);
        // 默认添加timestamp时间戳字段
        param.put("timestamp", timestamp);
        try{
            // 排序jsonNode
            ObjectNode jsonNode =  (ObjectNode) JsonUtil.parse(JsonUtil.convertNode(param));
            // 遍历jsonNode节点信息
            Iterator<Map.Entry<String, JsonNode>> it = jsonNode.fields();
            StringBuffer stringBuffer = new StringBuffer();
            while (it.hasNext()) {
                Map.Entry<String, JsonNode> entry = it.next();
                JsonNode jsonNode1 = param.get(entry.getKey());
                //对于jsonNode接点数据类型，可以根据原始接口类型进行判断
                if(jsonNode1.isArray() || jsonNode1.isPojo() || jsonNode1.isContainerNode()){
                    stringBuffer.append(JsonUtil.toJson(entry.getValue()));
                } else{
                    stringBuffer.append(entry.getValue().asText());
                }
            }
            String signature = SM4Utils.getSm3WithSM4Base64(stringBuffer.toString(), appKey);
            System.out.println("签名数据信息："+ signature);
            jsonNode.put("signature", signature);
            System.out.println("请求数据明文："+ JsonUtil.toJson(jsonNode));
            ObjectNode on2 = om.createObjectNode();
            on2.put("appId", appId);
            on2.put("param", SM4Utils.encryptData_CBC_ENCODE(jsonNode.toString(), appKey));
            String requestInfo = on2.toString();
            System.out.println("请求数据密文：" + requestInfo);
            return requestInfo;
        } catch (Exception e){
            System.err.println("signDataInfo 签名出错!" + e.getMessage());

        }
        return null;
    }

}
