package com.ai.ble.demo;

import com.ai.ble.base.rest.RestPostClient;
import com.ai.ble.base.util.ConfigUtils;
import com.ai.ble.base.util.JsonUtil;
import com.ai.ble.base.util.TimestampUtil;
import com.ai.ble.base.encrypt.SM4Utils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

import java.util.Iterator;
import java.util.Map;

/**
 * 验签接口
 * @author yfmei
 * 2019/12/16
 */
public class Verify {

    private static final String APP_ID = "1010000000000128";
    private static final String APP_SECRET = "A10941D6ABB57F0FE051D7E640DA722A";
    private static final String IP_PREFIX = "ble.interface.url";
    private static final String INTERFACE_URL = "/third/verifySign/verify";

    /**
     * appId 错误对应的错误码
     */
    public static final int EXCLUDE_CODE = 214;

    public static void call(){

        // 测试数据
        String userName = "demo";
        String phoneNumber = "158****4378";
        String signCert = "308203DE30820382A003020102020869E300DF000FA7E8300C06082A811CCF5501837505003076310B300906035504061302434E310E300C06035504080C05416E487569310E300C06035504070C05486546656931263024060355040A0C1D416E4875692043657274696669636174696F6E20417574686F72697479310D300B060355040B0C04414843413110300E06035504030C0741484341534D32301E170D3138313132393136303030305A170D3139313133303135353935395A304C310B300906035504061302434E311B3019060355040A0C12333430323035313936343031313730303236310C300A060355040B0C033332333112301006035504030C09E69D8EE7A780E8908D3059301306072A8648CE3D020106082A811CCF5501822D03420004A99648FBFEBD7F879F9E0645871C95631661E29071B32252CB7CAE61D9A4C5F900A171BED14715B5EB51FD8278F6FDCFB1D5077FDC4AB56F986B7744C6DA991EA38202203082021C300C0603551D1304053003010100301D0603551D250416301406082B0601050507030206082B06010505070304300B0603551D0F0404030200C0301F0603551D230418301680144699BC6162E2BA53A90C88D2CD5D96C0C830BACF3081CA0603551D1F0481C23081BF3081BCA081B9A081B686818E6C6461703A2F2F6C6461702E61686563612E636E3A3338392F434E3D41484341534D322C434E3D41484341534D322C204F553D43524C44697374726962757465506F696E74732C206F3D616863613F63657274696669636174655265766F636174696F6E4C6973743F626173653F6F626A656374636C6173733D63524C446973747269627574696F6E506F696E748623687474703A2F2F7777772E61686563612E636E2F63726C2F41484341534D322E63726C3081D206082B060105050701010481C53081C230818B06082B06010505073002867F6C6461703A2F2F6C6461702E61686563612E636E3A3338392F434E3D41484341534D322C434E3D41484341534D322C204F553D63414365727469666963617465732C206F3D616863613F634143657274696669636174653F626173653F6F626A656374436C6173733D63657274696669636174696F6E417574686F72697479303206082B060105050730028626687474703A2F2F7777772E61686563612E636E2F6361636572742F41484341534D322E636572301D0603551D0E04160414D39E006F8A19DF409B079D3EAAC455627339EC82300C06082A811CCF5501837505000348003045022100C2F946A5E085BE04958CD5148F9A5817F3FF62D97780D439E45BE52790C67596022030F263A0ECF78C34CB70A7A749C11A95517FD8D7321AE8C478AF6B5A319CE060";
        String signData = "EA95696D75C3F30172A78D8CA4F420244D5AEDC73ECE10C2120B7B6926CF13B78A2B0F623A97CC0201EEDA34CBCDDE44A0B5C2E13F3F34101BBF2295713A4DB9";
        String srcData = "6IKW6Z2Z55m75b2V";

        ObjectNode param = new ObjectMapper().createObjectNode();

        // 组装参数
        param.put("userName",  userName);
        param.put("phoneNumber",  phoneNumber);
        param.put("signCert",  signCert);
        param.put("signData",  signData);
        param.put("srcData",  srcData);

        // 对参数进行签名和加密
        String requestInfo = signDataInfo(param, APP_ID, APP_SECRET);

        try {
            // 发起请求
            String response = RestPostClient.get().callRestRPCJson(ConfigUtils.getStringValue(IP_PREFIX) + INTERFACE_URL, requestInfo);
            System.out.println("response :" + response);
            if(response == null) {
                System.out.println("调用失败");
            } else {
                try {
                    JsonNode resNode = JsonUtil.parse(response);
                    int statusCode = resNode.findPath("statusCode").asInt();
                    // 获取返回信息
                    String returnObj;
                    if (EXCLUDE_CODE == statusCode) {
                        // code: 214 返回结果没有被加密
                        returnObj = resNode.findPath("returnObj").asText();
                    } else {
                        // 解密返回结果
                        returnObj = SM4Utils.decryptData_CBC_DECODE(resNode.findPath("returnObj").asText(), APP_SECRET);
                        // 获取具体信息
                        JsonNode returnObjNode = JsonUtil.parse(returnObj);
                        returnObj = returnObjNode.findPath("resultDesc").asText();
                    }

                    System.out.println("statusCode :" + statusCode);
                    System.out.println("resultDesc :" + returnObj);
                }catch(Exception e1) {
                    System.out.println("解析返回结果异常：原文：" + response + "；异常信息为：" + e1.getMessage());
                }
            }
        } catch(Exception e){
            System.out.println("验签失败："+e.getMessage());
        }

    }

    /**
     * 封装签名和加密方法
     * @param param
     * @param appKey
     * @return
     * @throws Exception
     */
    public static String signDataInfo(ObjectNode param,String appId, String appKey) {
        // 开始组装调用参数
        ObjectMapper om = new ObjectMapper();

        String timestamp = TimestampUtil.getTimeStampYYYYMMDDHHMMSS();
        param.put("appId", appId);
        // 默认添加timestamp时间戳字段
        param.put("timestamp", timestamp);
        try{
            // 排序jsonNode
            ObjectNode jsonNode =  (ObjectNode) JsonUtil.parse(JsonUtil.convertNode(param));
            // 遍历jsonNode节点信息
            Iterator<Map.Entry<String, JsonNode>> it = jsonNode.fields();
            StringBuffer stringBuffer = new StringBuffer();
            while (it.hasNext()) {
                Map.Entry<String, JsonNode> entry = it.next();
                JsonNode jsonNode1 = param.get(entry.getKey());
                //对于jsonNode接点数据类型，可以根据原始接口类型进行判断
                if(jsonNode1.isArray() || jsonNode1.isPojo() || jsonNode1.isContainerNode()){
                    stringBuffer.append(JsonUtil.toJson(entry.getValue()));
                } else{
                    stringBuffer.append(entry.getValue().asText());
                }
            }
            String signature = SM4Utils.getSm3WithSM4Base64(stringBuffer.toString(), appKey);
            System.out.println("签名数据信息："+ signature);
            jsonNode.put("signature", signature);
            System.out.println("请求数据明文："+ JsonUtil.toJson(jsonNode));
            ObjectNode on2 = om.createObjectNode();
            on2.put("appId", appId);
            on2.put("param", SM4Utils.encryptData_CBC_ENCODE(jsonNode.toString(), appKey));
            String requestInfo = on2.toString();
            System.out.println("请求数据密文：" + requestInfo);
            return requestInfo;
        } catch (Exception e){
            System.err.println("signDataInfo 签名出错!" + e.getMessage());

        }
        return null;
    }

}
